// $Id: RomManbow2.hh 11704 2010-10-14 17:05:58Z m9710797 $

#ifndef ROMMANBOW2_HH
#define ROMMANBOW2_HH

#include "MSXRom.hh"
#include "RomTypes.hh"
#include <memory>

namespace openmsx {

class SCC;
class AmdFlash;

class RomManbow2 : public MSXRom
{
public:
	RomManbow2(MSXMotherBoard& motherBoard, const XMLElement& config,
	           std::auto_ptr<Rom> rom, RomType type);
	virtual ~RomManbow2();

	virtual void powerUp(EmuTime::param time);
	virtual void reset(EmuTime::param time);
	virtual byte peekMem(word address, EmuTime::param time) const;
	virtual byte readMem(word address, EmuTime::param time);
	virtual void writeMem(word address, byte value, EmuTime::param time);
	virtual const byte* getReadCacheLine(word address) const;
	virtual byte* getWriteCacheLine(word address) const;

	template<typename Archive>
	void serialize(Archive& ar, unsigned version);

private:
	void setRom(unsigned region, unsigned block);

	const std::auto_ptr<SCC> scc;
	const std::auto_ptr<AmdFlash> flash;
	byte bank[4];
	bool sccEnabled;
};

} // namespace openmsx

#endif
