// $Id: PrinterPortSimpl.cc 8352 2008-11-12 18:39:08Z m9710797 $

#include "PrinterPortSimpl.hh"
#include "DACSound8U.hh"
#include "XMLElement.hh"
#include "serialize.hh"

namespace openmsx {

PrinterPortSimpl::PrinterPortSimpl(MSXMixer& mixer_)
	: mixer(mixer_)
{
}

bool PrinterPortSimpl::getStatus(EmuTime::param /*time*/)
{
	return true; // TODO check
}

void PrinterPortSimpl::setStrobe(bool /*strobe*/, EmuTime::param /*time*/)
{
	// ignore strobe // TODO check
}

void PrinterPortSimpl::writeData(byte data, EmuTime::param time)
{
	dac->writeDAC(data, time);
}

void PrinterPortSimpl::createDAC()
{
	static XMLElement simplConfig("simpl");
	static bool init = false;
	if (!init) {
		init = true;
		std::auto_ptr<XMLElement> soundElem(new XMLElement("sound"));
		soundElem->addChild(std::auto_ptr<XMLElement>(
			new XMLElement("volume", "12000")));
		soundElem->addChild(std::auto_ptr<XMLElement>(
			new XMLElement("mode", "mono")));
		simplConfig.addChild(soundElem);
	}
	dac.reset(new DACSound8U(mixer, "simpl", getDescription(), simplConfig));
}

void PrinterPortSimpl::plugHelper(Connector& /*connector*/, EmuTime::param /*time*/)
{
	createDAC();
}

void PrinterPortSimpl::unplugHelper(EmuTime::param /*time*/)
{
	dac.reset();
}

const std::string& PrinterPortSimpl::getName() const
{
	static const std::string name("simpl");
	return name;
}

const std::string& PrinterPortSimpl::getDescription() const
{
	static const std::string desc("Play samples via your printer port.");
	return desc;
}

template<typename Archive>
void PrinterPortSimpl::serialize(Archive& ar, unsigned /*version*/)
{
	if (getConnector()) {
		// plugged in
		if (ar.isLoader()) {
			createDAC();
		}
		ar.serialize("dac", *dac);
	}
}
INSTANTIATE_SERIALIZE_METHODS(PrinterPortSimpl);
REGISTER_POLYMORPHIC_INITIALIZER(Pluggable, PrinterPortSimpl, "PrinterPortSimpl");

} // namespace openmsx
