// $Id: DebugDevice.hh 8352 2008-11-12 18:39:08Z m9710797 $

#ifndef DEBUGDEVICE_HH
#define DEBUGDEVICE_HH

#include "MSXDevice.hh"
#include <fstream>
#include <memory>

namespace openmsx {

class FilenameSetting;

class DebugDevice : public MSXDevice
{
public:
	DebugDevice(MSXMotherBoard& motherBoard, const XMLElement& config);
	virtual ~DebugDevice();

	virtual void writeIO(word port, byte value, EmuTime::param time);

	template<typename Archive>
	void serialize(Archive& ar, unsigned version);

	// public for serialization
	enum DebugMode {OFF, SINGLEBYTE, MULTIBYTE, ASCII};

private:
	enum DisplayType {HEX, BIN, DEC, ASC};

	void outputSingleByte(byte value, EmuTime::param time);
	void outputMultiByte(byte value);
	void displayByte(byte value, DisplayType type);
	void openOutput(const std::string& name);

	std::auto_ptr<FilenameSetting> fileNameSetting;
	std::ostream* outputstrm;
	std::ofstream debugOut;
	std::string fileNameString;
	DebugMode mode;
	byte modeParameter;
};

} // namespace openmsx

#endif
