# $Id: buildinfo2code.py 9750 2009-05-03 16:55:49Z mthuurne $

from cpu import getCPU
from makeutils import extractMakeVariables, parseBool
from outpututils import rewriteIfChanged

import sys

def iterBuildInfoHeader(targetPlatform, cpuName, flavour, installShareDir):
	platformVars = extractMakeVariables(
		'build/platform-%s.mk' % targetPlatform,
		dict.fromkeys(
			('COMPILE_FLAGS', 'LINK_FLAGS', 'TARGET_FLAGS',
			 'COMPILE_ENV', 'LINK_ENV'),
			''
			)
		)
	setWindowIcon = parseBool(platformVars.get('SET_WINDOW_ICON', 'true'))

	targetCPU = getCPU(cpuName)

	# TODO: Add support for device-specific configuration.
	platformGP2X = False
	if platformGP2X:
		have16BPP = True
		have32BPP = False
		minScaleFactor = 1
		maxScaleFactor = 1
	else:
		have16BPP = True
		have32BPP = True
		minScaleFactor = 1
		maxScaleFactor = 4

	yield '// Automatically generated by build process.'
	yield ''
	yield '#ifndef BUILD_INFO_HH'
	yield '#define BUILD_INFO_HH'
	yield ''
	yield '#include <string>'
	yield ''
	# Use a macro i.s.o. a boolean to prevent compilation errors on inline asm.
	# A compiler will typically only understand the instruction set that it
	# generates code for.
	for define in targetCPU.asmDefines:
		yield '#define %s' % define
	# Use a macro iso integer because we really need to exclude code sections
	# based on this.
	yield '#define PLATFORM_GP2X %d' % platformGP2X
	yield '#define HAVE_16BPP %d' % have16BPP
	yield '#define HAVE_32BPP %d' % have32BPP
	yield '#define MIN_SCALE_FACTOR %d' % minScaleFactor
	yield '#define MAX_SCALE_FACTOR %d' % maxScaleFactor
	yield ''
	yield 'namespace openmsx {'
	yield ''
	# Note: Don't call it "BIG_ENDIAN", because some system header may #define
	#       that.
	yield 'static const bool OPENMSX_BIGENDIAN = %s;' \
		% str(targetCPU.bigEndian).lower()
	yield 'static const bool OPENMSX_UNALIGNED_MEMORY_ACCESS = %s;' \
		% str(targetCPU.unalignedMemoryAccess).lower()
	yield 'static const bool OPENMSX_SET_WINDOW_ICON = %s;' \
		% str(setWindowIcon).lower()
	yield 'static const std::string DATADIR = "%s";' % installShareDir
	yield 'static const std::string BUILD_FLAVOUR = "%s";' % flavour
	yield ''
	yield '} // namespace openmsx'
	yield ''
	yield '#endif // BUILD_INFO_HH'

if __name__ == '__main__':
	if len(sys.argv) == 6:
		rewriteIfChanged(sys.argv[1], iterBuildInfoHeader(*sys.argv[2 : ]))
	else:
		print >> sys.stderr, \
			'Usage: python buildinfo2code.py CONFIG_HEADER ' \
			'platform cpu flavour share-install-dir'
		sys.exit(2)
