// $Id: WavImage.hh 6766 2007-07-31 19:06:51Z m9710797 $

#ifndef WAVIMAGE_HH
#define WAVIMAGE_HH

#include "CassetteImage.hh"
#include "DynamicClock.hh"
#include "noncopyable.hh"
#include <string>

namespace openmsx {

class WavImage : public CassetteImage, private noncopyable
{
public:
	explicit WavImage(const std::string& fileName);
	virtual ~WavImage();

	virtual short getSampleAt(const EmuTime& time);
	virtual EmuTime getEndTime() const;
	virtual unsigned getFrequency() const;
	virtual void fillBuffer(unsigned pos, int** bufs, unsigned num) const;

private:
	int getSample(unsigned pos) const;

	unsigned nbSamples;
	byte* buffer;
	DynamicClock clock;
	short average;
};

} // namespace openmsx

#endif
