// $Id: RenShaTurbo.cc 5993 2007-01-12 22:12:12Z m9710797 $

#include "RenShaTurbo.hh"
#include "XMLElement.hh"
#include "Autofire.hh"

namespace openmsx {

RenShaTurbo::RenShaTurbo(CommandController& commandController,
                         const XMLElement& machineConfig)
{
	const XMLElement* config = machineConfig.findChild("RenShaTurbo");
	if (config) {
		int min_ints = config->getChildDataAsInt("min_ints", 47);
		int max_ints = config->getChildDataAsInt("max_ints", 221);
		autofire.reset(new Autofire(commandController, min_ints,
		                            max_ints, "renshaturbo"));
	}
}

RenShaTurbo::~RenShaTurbo()
{
}

bool RenShaTurbo::getSignal(const EmuTime& time)
{
	return autofire.get() ? autofire->getSignal(time) : false;
}

} // namespace openmsx
