// $Id: CliServer.hh 5854 2006-11-06 18:24:21Z m9710797 $

#ifndef CLISERVER_HH
#define CLISERVER_HH

#include "Thread.hh"
#include "Socket.hh"
#include <string>

namespace openmsx {

class CommandController;
class EventDistributor;
class GlobalCliComm;

class CliServer : private Runnable
{
public:
	CliServer(CommandController& commandController,
	          EventDistributor& eventDistributor,
	          GlobalCliComm& cliComm);
	~CliServer();

private:
	// Runnable
	virtual void run();

	void mainLoop();
	void createSocket();
	bool exitAcceptLoop();

	Thread thread;
	bool exitLoop;
	std::string socketName;
	int portNumber; // windows only
	SOCKET listenSock;

	CommandController& commandController;
	EventDistributor& eventDistributor;
	GlobalCliComm& cliComm;
};

} // namespace openmsx

#endif
