# $Id: info2code.mk 6188 2007-03-21 23:44:32Z mthuurne $
#
# Write build info to C++ constants, so source can access it.
# Advantages of this approach:
# - file dates used for dependency checks (as opposed to "-D" compile flag)
# - inactive code is still checked by compiler (as opposed to "#if")

# Sanity checks on required Make variables.
$(call DEFCHECK,OPENMSX_TARGET_CPU)
ifneq ($(OPENMSX_TARGET_CPU),univ)
$(call BOOLCHECK,BIG_ENDIAN)
endif
$(call BOOLCHECK,SET_WINDOW_ICON)
#$(call DEFCHECK,INSTALL_SHARE_DIR)

$(CONFIG_HEADER): $(MAKE_PATH)/info2code.mk $(MAKE_PATH)/custom.mk
	@echo "Creating $@..."
	@mkdir -p $(@D)
	@echo "// Automatically generated by build process." > $@
	@echo "" >> $@
	@echo "#ifndef __BUILD_INFO_HH__" >> $@
	@echo "#define __BUILD_INFO_HH__" >> $@
	@echo "" >> $@
	@echo "#include <string>" >> $@
	@echo "" >> $@
	@echo "namespace openmsx {" >> $@
	@echo "" >> $@
# Use a macro iso a boolean to prevent compilation errors on non x86 machines
	@if [ "$(OPENMSX_TARGET_CPU)" = "x86" ] ; then \
		echo "#define ASM_X86_32" >> $@ ; \
		echo "#define ASM_X86" >> $@ ; \
	fi
	@if [ "$(OPENMSX_TARGET_CPU)" = "x86_64" ] ; then \
		echo "#define ASM_X86_64" >> $@ ; \
		echo "#define ASM_X86" >> $@ ; \
	fi
# Don't call it "BIG_ENDIAN", because some system header may #define that.
	@echo "static const bool OPENMSX_BIGENDIAN = $(BIG_ENDIAN);" >> $@
	@echo "static const bool OPENMSX_SET_WINDOW_ICON = $(SET_WINDOW_ICON);" >> $@
	@echo "static const std::string DATADIR = \"$(INSTALL_SHARE_DIR)\";" >> $@
	@echo "" >> $@
	@echo "} // namespace openmsx" >> $@
	@echo "" >> $@
	@echo "#endif //__BUILD_INFO_HH__" >> $@

$(VERSION_HEADER): ChangeLog $(MAKE_PATH)/info2code.mk $(MAKE_PATH)/version.mk
	@echo "Creating $@..."
	@mkdir -p $(@D)
	@echo "// Automatically generated by build process." > $@
	@echo "" >> $@
	@echo "const bool Version::RELEASE = $(RELEASE_FLAG);" >> $@
	@echo "const std::string Version::VERSION = \"$(PACKAGE_VERSION)\";" >> $@
	@echo "const std::string Version::CHANGELOG_REVISION = \"$(CHANGELOG_REVISION)\";" >> $@

