# $Id: version2code.py 9306 2009-03-01 05:15:33Z mfeingol $
# Generates version include file.

from outpututils import rewriteIfChanged
from version import extractRevision, packageVersion, releaseFlag

import sys

def iterVersionInclude():
	revision = extractRevision()

	yield '// Automatically generated by build process.'
	yield 'const bool Version::RELEASE = %s;' % str(releaseFlag).lower()
	yield 'const std::string Version::VERSION = "%s";' % packageVersion
	yield 'const std::string Version::CHANGELOG_REVISION = "%s";' % revision

if __name__ == '__main__':
	if len(sys.argv) == 2:
		rewriteIfChanged(sys.argv[1], iterVersionInclude())
	else:
		print >> sys.stderr, \
			'Usage: python version2code.py VERSION_HEADER'
		sys.exit(2)
