/**
 * VampirTrace
 * http://www.tu-dresden.de/zih/vampirtrace
 *
 * Copyright (c) 2005-2013, ZIH, TU Dresden, Federal Republic of Germany
 *
 * Copyright (c) 1998-2005, Forschungszentrum Juelich, Juelich Supercomputing
 *                          Centre, Federal Republic of Germany
 *
 * See the file COPYING in the package base directory for details
 **/

package grpFilt;

import help.Config;
import help.Pair;
import help.Text;
import help.myMouseListener;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import javax.swing.JViewport;

import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.DefaultFormatter;

import xmlObjects.VtEnv;



/****
 * 	Is a Panel that contains all Components and Gui elements for grouping.
 */
public class Grouping extends javax.swing.JPanel{

	/**
	 * generated Serial finalVersionUID
	 */
	private static final long serialVersionUID = -2195660139809147848L;
	private SymbolGroupTable simbolTable= null;
	private JList grpTable= null;
	private ArrayList<String> standardGrps = new ArrayList<String>(); 
	private DefaultGroups defGroups = null;	
	private MyTableRenderer grpRenderer = new MyTableRenderer();
	private JViewport view = null;
	private JComboBox GroupBox = null;
	private VtEnv env = null;
	private Text mytext = null;
	private boolean isAdvanced = false;
	
	DefaultListModel grpModel = new DefaultListModel(){
		/**
		 * generated serialVersionUID
		 */
		private static final long serialVersionUID = -1244058926110771628L;
		private boolean isEditable = false;
		@SuppressWarnings("unused")
		public boolean isCellEditable(int rowIndex, int vColIndex) { return isEditable; }
	};
	
	/****
	 * initialize all components of this widget
	 * @param sTable SymbolGroupTable used by this class and General and Filtering class.
	 * @param toolTip a panel that is used to show information about setting options
	 * @param defGroups this {@link DefaultGroups Class} contains all informations about default simbols and groups
	 */
	public Grouping(SymbolGroupTable sTable,final VtEnv env,final DefaultGroups defGroups,final Text mytext)
	{	
		this.mytext = mytext;
		this.env = env;
		this.defGroups = defGroups;
		simbolTable = sTable;
		
		
		JPanel panel = new JPanel(new GridBagLayout());
		//panel.setBorder(BorderFactory.createTitledBorder("Grouping"));
		panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0,Color.GRAY), "Grouping", TitledBorder.DEFAULT_JUSTIFICATION,TitledBorder.DEFAULT_POSITION));
		
		GridBagConstraints c = new GridBagConstraints();	
		this.setLayout(new BorderLayout());
		c.fill = GridBagConstraints.HORIZONTAL;
		c.gridx=c.gridy=0;
		c.insets = new Insets(10,10,10,20);
		c.anchor = GridBagConstraints.FIRST_LINE_START;
		c.weightx = 1;
		c.gridwidth = 1;
		
		grpTable = new JList();
		grpTable.setModel(grpModel);
		grpTable.setCellRenderer(grpRenderer);
		
		c.gridy++;
		c.gridx = 0;

		c.insets = new Insets(5,10,5,10);
		c.gridx = 0;
		c.gridwidth = 4;
		panel.add(addTable(),c);
		c.gridwidth = 1;
		c.gridx = 0;
		c.gridy++;

		
		c.anchor = GridBagConstraints.LINE_END;

		JButton moveButton = new JButton("Move Selected Symbols");
		GroupBox = new JComboBox();
		FlowLayout layout = new FlowLayout();
		layout.setAlignment(FlowLayout.RIGHT);
		layout.setHgap(0);
		JPanel moveElement = new JPanel(layout);
		moveElement.add(GroupBox);
		moveElement.add(new JLabel("   "));
		moveElement.add(moveButton);
		c.weightx = 0;
		c.gridx = 1;
		c.gridwidth = 3;
		panel.add(moveElement,c);
		c.weightx = 1;
		c.anchor = GridBagConstraints.LINE_START;
		c.gridx = 0;
		c.gridy++;
		c.gridwidth = 1;
		JButton addGroup = new JButton("Add");
		final JFormattedTextField addGroupT = new JFormattedTextField("");
//		addGroupT.setColumns(8);
		c.weightx = 0;
		panel.add(new JLabel("New group:"),c);
		c.weightx = 1;
		c.gridx++;
		c.gridwidth = 2;
		panel.add(addGroupT,c);
		c.gridwidth = 1;
		c.gridx= c.gridx +2;
		c.weightx = 0;
		panel.add(addGroup,c);
		c.gridx = 0;
		c.gridy++;
		
		JButton rnGroup = new JButton("Rename Group");
		final JFormattedTextField rnGroupT = new JFormattedTextField("");
		
		panel.add(new JLabel("Rename selected group:"),c);
		c.gridx++;
		c.weightx = 1;
		c.gridwidth = 2;
		panel.add(rnGroupT,c);
		c.gridwidth = 1;
		c.gridx= c.gridx + 2;
		c.weightx = 0;
		panel.add(rnGroup,c);
		
		
		c.gridy++;
		JButton rmGroup = new JButton("Remove Group");
		panel.add(rmGroup,c);
		c.weightx = 1;
		JPanel help = new JPanel(new GridBagLayout());
		c.gridx = c.gridy = 0;
		c.insets = new Insets(0,10,0,0);
		help.add(panel,c);
		this.add(help,BorderLayout.NORTH);

		
		rmGroup.setPreferredSize(moveButton.getPreferredSize());
		addGroup.setPreferredSize(moveButton.getPreferredSize());
		rnGroup.setPreferredSize(moveButton.getPreferredSize());
		
		grpRenderer.setGroups(simbolTable.countGroupElements(isAdvanced));
		
		for(int i=1;i < grpModel.getSize();i++)
		{
			GroupBox.addItem(grpModel.get(i).toString());
		}

		GroupBox.validate();
	
		grpTable.setSelectedIndex(0);
		
		/* Handler und Listener */
		grpTable.addMouseListener(new MouseListener(){
			public void mouseClicked(MouseEvent e) {
				int[] selection = grpTable.getSelectedIndices();
				String[] selections =  new String[selection.length];
				
				boolean isAll = false;
				for(int i=0;i<selection.length;i++)
				{
					selections[i] = grpModel.get(selection[i]).toString();
					if(selection[i]== 0)
						isAll = true;
				}
				
				if(isAll)
				{
					((SymbolGroupTable)simbolTable).setGrpFilter(grpModel.toArray());
				}
				else
				{
					((SymbolGroupTable)simbolTable).setGrpFilter(selections);
				}
				
			}

			public void mouseEntered(MouseEvent arg0) {;}

			public void mouseExited(MouseEvent e) {;}


			public void mousePressed(MouseEvent e) {;}


			public void mouseReleased(MouseEvent e) {;}
			
		});
		addGroup.addActionListener(new ActionListener(){

			public void actionPerformed(ActionEvent e) {
				String title = addGroupT.getText();
				if(title != null)
				{
					if(title.trim().contains("=") || title.equals(DefaultGroups.DEFAULTGROUP) || title.trim().equals("") || grpModel.contains(title) || defGroups.isDefaultGroup(title))
					{
						JOptionPane.showMessageDialog(null, "group name is not allowed.");
	        			
					}
					else
					{
						grpModel.add(1,title);
						GroupBox.insertItemAt(title, 0);
						simbolTable.changed.put("g"+title, new Pair<Integer,String>(0,"addGroup"));
						GroupBox.validate();
					}
					
				}
			}
			
		});
		rmGroup.addActionListener(new ActionListener(){

			public void actionPerformed(ActionEvent e) {
				if(!grpTable.isSelectionEmpty() && !grpTable.isSelectedIndex(0) )
				{
					ArrayList<String> deletedGroup = new ArrayList<String>();
					int[] selection = grpTable.getSelectedIndices();
					String[] selections =  new String[selection.length];
					
					for(int i=0;i<selection.length;i++)
					{
						selections[i] = grpModel.get(selection[i]).toString();
						if(defGroups.isDefaultGroup(selections[i])){
							continue;
						}
						if(!selections[i].equals("All"))
						{
							grpModel.remove(selection[i]);
							GroupBox.removeItem(selections[i]);
							deletedGroup.add(selections[i]);
						}
					}
					GroupBox.validate();
					
					renameDeletedGroups(deletedGroup);
					grpRenderer.setGroups(simbolTable.countGroupElements(isAdvanced));
				}
				
			}
			
		});
		rnGroup.addActionListener(new ActionListener(){

			public void actionPerformed(ActionEvent e) {
				if(!grpTable.isSelectionEmpty() && !grpTable.isSelectedIndex(0) && !grpTable.getSelectedValue().equals(DefaultGroups.DEFAULTGROUP))
				{
					String title = rnGroupT.getText();
					String oldGroup = grpTable.getSelectedValue().toString();
					if(title != null)
					{
						if(title.trim().contains("=") || title.equals(DefaultGroups.DEFAULTGROUP) || title.trim().equals(""))
						{
							JOptionPane.showMessageDialog(null, "group name is not allowed.");
		        			
						}
						else
						{
							grpModel.setElementAt(title, grpTable.getSelectedIndex());
							
							renameRenamedGroups(oldGroup, title);
							DefaultComboBoxModel group = ((DefaultComboBoxModel)GroupBox.getModel());
							group.insertElementAt(title, group.getIndexOf(oldGroup));
							group.removeElement(oldGroup);
							grpRenderer.setGroups(simbolTable.countGroupElements(isAdvanced));
						}
					}
				}
			}
			
		});
		
		moveButton.addActionListener(new ActionListener(){

			
			@SuppressWarnings("unchecked")
			public void actionPerformed(ActionEvent e) {
				int[] selections = simbolTable.getSelectedRows();
				DefaultTableModel model = (DefaultTableModel) simbolTable.getModel();
				
				if(GroupBox.getSelectedItem() != null)
				{
					
					DefaultRowSorter sorter = (DefaultRowSorter) simbolTable.getRowSorter();
					simbolTable.setRowSorter(null);
					for(int i=0;i<selections.length;i++)
					{
						model.setValueAt(GroupBox.getSelectedItem().toString(), sorter.convertRowIndexToModel(selections[i]), 4);
						simbolTable.changed.put("s"+model.getValueAt(sorter.convertRowIndexToModel(selections[i]), 1).toString(), new Pair<Integer,String>(sorter.convertRowIndexToModel(selections[i]),"regrouped"));
					}
					
					simbolTable.setRowSorter(sorter);
					sorter.sort();
					grpRenderer.setGroups(simbolTable.countGroupElements(isAdvanced));
					grpTable.repaint();
				}	
			}
		});
	
		myMouseListener n = null;

		grpTable.addMouseListener(new MouseListener()
			{
				/***
				 * overwriting mouseClicked event with nothing
				 * @param e MouseEvent that is detected
				 */
				public void mouseClicked(MouseEvent e) {;}

				/***
				 * overwriting mouseEntered event with showing the {@link #setText(String) text} that was set
				 * @param e MouseEvent that is detected
				 */
				public void mouseEntered(MouseEvent e) {				
					
					if(isAdvanced)
						env.ToolTipView.setText(Config.setToolTipString(mytext.getText("Grouping_groupList_title"), mytext.getText("Grouping_groupList_adv")));
					else
						env.ToolTipView.setText(Config.setToolTipString(mytext.getText("Grouping_groupList_title"), mytext.getText("Grouping_groupList")));
					if(env.getToolTip().getComponent(0) != env.ToolTipView)
					{
			        	env.getToolTip().removeAll();
		        		env.getToolTip().add(env.ToolTipView);
					}
				}
				
				/***
				 * overwriting mouseExited event with the restoring the old text
				 * @param e MouseEvent that is detected
				 */
				public void mouseExited(MouseEvent e) {
					//toolTip.setText(this.old_text);
				}

				/***
				 * overwriting mousePressed event with nothing
				 * @param e MouseEvent that is detected
				 */
				public void mousePressed(MouseEvent e) {;}

				/***
				 * overwriting mouseReleased event with nothing
				 * @param e MouseEvent that is detected
				 */
				public void mouseReleased(MouseEvent e) {;}
		});
		n = new myMouseListener();
		n.setToolTip(env);
		n.setText(Config.setToolTipString(mytext.getText("Grouping_addGroup_title"), mytext.getText("Grouping_addGroup")));
		addGroup.addMouseListener(n);
		addGroupT.addMouseListener(n);
		
		rmGroup.addMouseListener(new MouseListener()
		{
			/***
			 * overwriting mouseClicked event with nothing
			 * @param e MouseEvent that is detected
			 */
			public void mouseClicked(MouseEvent e) {;}

			/***
			 * overwriting mouseEntered event with showing the {@link #setText(String) text} that was set
			 * @param e MouseEvent that is detected
			 */
			public void mouseEntered(MouseEvent e) {				
				
				if(isAdvanced)
					env.ToolTipView.setText(Config.setToolTipString(mytext.getText("Grouping_removeGroup_title"), mytext.getText("Grouping_removeGroup_adv")));
				else
					env.ToolTipView.setText(Config.setToolTipString(mytext.getText("Grouping_removeGroup_title"), mytext.getText("Grouping_removeGroup")));
				if(env.getToolTip().getComponent(0) != env.ToolTipView)
				{
		        	env.getToolTip().removeAll();
	        		env.getToolTip().add(env.ToolTipView);
				}
			}
			
			/***
			 * overwriting mouseExited event with the restoring the old text
			 * @param e MouseEvent that is detected
			 */
			public void mouseExited(MouseEvent e) {
				//toolTip.setText(this.old_text);
			}

			/***
			 * overwriting mousePressed event with nothing
			 * @param e MouseEvent that is detected
			 */
			public void mousePressed(MouseEvent e) {;}

			/***
			 * overwriting mouseReleased event with nothing
			 * @param e MouseEvent that is detected
			 */
			public void mouseReleased(MouseEvent e) {;}
	});
	
		n = new myMouseListener();
		n.setToolTip(env);
		n.setText(Config.setToolTipString(mytext.getText("Grouping_renameGroup_title"), mytext.getText("Grouping_renameGroup")));
		rnGroup.addMouseListener(n);
		rnGroupT.addMouseListener(n);
		n = new myMouseListener();
		n.setToolTip(env);
		n.setText(Config.setToolTipString(mytext.getText("Grouping_moveSymb_title"), mytext.getText("Grouping_moveSymb")));
		moveButton.addMouseListener(n);
		GroupBox.addMouseListener(n);
		
	}
	
	/***
	 * reorder symbols in SymbolGroupTable when a group was deleted
	 * @param deletedGroup list of all deleted groups
	 */
	@SuppressWarnings("unchecked")
	public void renameDeletedGroups(ArrayList<String> deletedGroup)
	{
		DefaultTableModel model = (DefaultTableModel) simbolTable.getModel();

		DefaultRowSorter sorter = (DefaultRowSorter) simbolTable.getRowSorter();
		simbolTable.setRowSorter(null);
		
		for(int i=0;i<deletedGroup.size();i++)
		{
			simbolTable.changed.put("g"+deletedGroup.get(i), new Pair<Integer,String>(0,"groupDeleted"));
		}
		
		for(int i=0;i<model.getRowCount();i++)
		{
			if(deletedGroup.contains(model.getValueAt(i, 4)))
			{
				model.setValueAt(defGroups.getGroup(model.getValueAt(i, 4).toString()), i, 4);
				simbolTable.changed.put("s"+model.getValueAt(i, 1).toString(), new Pair<Integer,String>(i,"regrouped"));
			}
		}
		simbolTable.setRowSorter(sorter);
	}
	
	/***
	 * reorder symbols in SymbolGroupTable when a group was renamed
	 * @param oldGroup name of the group before renaming
	 * @param newGroup new name of the group
	 */
	@SuppressWarnings("unchecked")
	public void renameRenamedGroups(String oldGroup, String newGroup)
	{
		DefaultTableModel model = (DefaultTableModel) simbolTable.getModel();
		DefaultRowSorter sorter = (DefaultRowSorter) simbolTable.getRowSorter();
		simbolTable.setRowSorter(null);
		
		simbolTable.changed.put("g"+oldGroup, new Pair<Integer,String>(0,"grouprenamed:"+newGroup));
		
		for(int i=0;i<model.getRowCount();i++)
		{
			if(model.getValueAt(i, 4) != null && model.getValueAt(i, 4).toString().equals(oldGroup))
			{
					model.setValueAt(newGroup, i, 4);
					simbolTable.changed.put("s"+model.getValueAt(i, 1).toString(), new Pair<Integer,String>(i,"regrouped"));
			}
		}
		simbolTable.setRowSorter(sorter);
	}
	
	/***
	 * add default groups to the SymbolGroupTable
	 */
	@SuppressWarnings("unchecked")
	private void setDefaultGroups()
	{
		boolean help = simbolTable.simbolIsSet;
		DefaultRowSorter sorter = (DefaultRowSorter) simbolTable.getRowSorter();
		simbolTable.setRowSorter(null);
		Hashtable<String,String> groups = defGroups.getGroups();
		Iterator<String> keys = groups.keySet().iterator();
		String simbol = "";
		while(keys.hasNext())
		{
			simbol = keys.next().toString().trim();
			if(simbolTable.entries.containsKey("s"+simbol))
			{
				String curgrp = simbolTable.getModel().getValueAt(simbolTable.entries.get("s"+simbol), 4).toString().trim();
				if(curgrp.equals(DefaultGroups.DEFAULTGROUP) || curgrp.equals(""))
					simbolTable.setValueAt(groups.get(simbol).toString().trim(), simbolTable.entries.get("s"+simbol), 1);
			}else
				simbolTable.addRow(simbol, groups.get(simbol).toString());
		}
		simbolTable.simbolIsSet = help;
		simbolTable.setRowSorter(sorter);
	}
	
	/***
	 * sets all symbols to one of the default groups
	 */
	private void setGroups()
	{
		ArrayList<String> groups = simbolTable.getGroups();
		groups.add(0,DefaultGroups.DEFAULTGROUP);
		groups.add("All");
		boolean firstTime = false;
		if(grpModel.isEmpty())
			firstTime = true;
		for(int i=0; i<groups.size();i++)
		{	
			if(!grpModel.contains(groups.get(i)))
			{
				if(!defGroups.isDefaultGroup(groups.get(i).toString()))
				{
					if(firstTime)
						grpModel.add(0,groups.get(i));
					else
						grpModel.add(1,groups.get(i));
				}
				else
					grpModel.addElement(groups.get(i));

				if(i!=groups.size()-1)
				{
					
					if(!defGroups.isDefaultGroup(groups.get(i).toString()))
						GroupBox.insertItemAt(groups.get(i).toString(), 1);
					else
						GroupBox.addItem(groups.get(i).toString());						
					
					
						simbolTable.changed.put("g"+groups.get(i).toString(), new Pair<Integer,String>(0,"addGroup"));
				}
			}
		}
		GroupBox.validate();
	}
	
	/***
	 * initialize a symbolGroupTable with search  button scrollPane  
	 * @return component with symbolGroupTable 
	 */
	private Component addTable()
	{
		final JFormattedTextField text = new JFormattedTextField("");
		((DefaultFormatter)text.getFormatter()).setOverwriteMode(false);
		text.setColumns(8);
		final JButton find = new JButton("Find");
		simbolTable.find(null);
		simbolTable.setView(SymbolGroupTable.GROUP_VIEW);
		JScrollPane comp = new JScrollPane(simbolTable);
		comp.setPreferredSize(new Dimension(200, 250));
		comp.setVerticalScrollBarPolicy( JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
		comp.setHorizontalScrollBarPolicy( JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		view = comp.getViewport();
		
		JScrollPane comp2 = new JScrollPane(grpTable);
		comp2.setPreferredSize(new Dimension(180, 250));
		comp2.setVerticalScrollBarPolicy( JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
		comp2.setHorizontalScrollBarPolicy( JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		
		
		JPanel search = new JPanel(new GridBagLayout());
		GridBagConstraints c = new GridBagConstraints();
		final JLabel SearchFor = new JLabel(mytext.getText("Grouping_Search_For"));
		search.add(SearchFor);
		c.anchor = GridBagConstraints.LINE_END;
		
		search.add(text,c);
		//search.add(find);
		
		
		JPanel output = new JPanel(new GridBagLayout());

		c.anchor = GridBagConstraints.LINE_START;
		c.gridx=0;c.gridy=0;
		c.insets = new Insets(0,0,0,20);
		output.add(new JLabel(mytext.getText("Grouping_list_title")),c);
		c.gridx = 1;
		output.add(new JLabel(mytext.getText("Grouping_table_title")),c);
		c.gridx=2;
		
		c.anchor = GridBagConstraints.LINE_END;
		c.insets = new Insets(0,0,0,0);
		output.add(search,c);
		c.anchor = GridBagConstraints.LINE_START;
		c.gridy++;
		c.gridx=1;
		c.gridwidth=2;
		c.fill = GridBagConstraints.HORIZONTAL;
		c.weightx = 1;
		output.add(comp,c);
		c.weightx = 0;
		c.gridx=0;
		c.gridwidth=1;
		c.insets = new Insets(0,0,0,20);
		output.add(comp2,c);
		
		final SearchFunction myFunc = new SearchFunction(simbolTable,text);
		final Thread searchThread = new Thread(myFunc);
		searchThread.start();
		text.addKeyListener(new KeyListener(){


			public void keyPressed(KeyEvent e) {;}

			public void keyReleased(KeyEvent e) {
				if(myFunc.searchisRunning)
				{
					try {
						myFunc.currentDelay = 0;
					} catch (Exception err) {
						Config.errorHandler(err);
					}
				}else{	
					try {
						myFunc.searchisRunning = true;
						myFunc.currentDelay = 0;
					} catch (Exception err) {
						Config.errorHandler(err);
					}
				}
			}

			public void keyTyped(KeyEvent e) {;}
			
		});
		
		myMouseListener n = new myMouseListener();
		n.setToolTip(env);
		n.setText(Config.setToolTipString(mytext.getText("Grouping_search_title"), mytext.getText("Grouping_search")));
		
		text.addMouseListener(n);
		find.addMouseListener(n);
		return output;
	}
	
	/***
	 * changes view 
	 * @param visible true if advanced settings are shown otherwise false
	 * @return this panel in the special view.
	 */
	public JPanel getPanel(boolean visible)
	{	
		isAdvanced = visible;
		//grpModel.removeAllElements();
		if(!visible)
		{
			ArrayList<String> groups = simbolTable.getGroups();
			for(int i=0; i<groups.size();i++)
			{
					if(defGroups.isDefaultGroup(groups.get(i).toString()) && !groups.get(i).toString().equals(DefaultGroups.DEFAULTGROUP))
					{
						if(!simbolTable.hideGroups.contains(groups.get(i)))
							simbolTable.hideGroups.add(groups.get(i));
						grpModel.removeElement(groups.get(i));
						GroupBox.removeItem(groups.get(i).toString());
					}
			}
		}
		else
		{
			for(int i=0; i<simbolTable.hideGroups.size();i++)
			{
				if(!grpModel.contains(simbolTable.hideGroups.get(i)))
				{
					grpModel.addElement(simbolTable.hideGroups.get(i));
					GroupBox.addItem(simbolTable.hideGroups.get(i));
				}
			}
			simbolTable.hideGroups.clear();
		}
		grpRenderer.setGroups(simbolTable.countGroupElements(isAdvanced));
		simbolTable.setGrpFilter(null);
		return this;
	}
	
	
	/*** 
	 * set simbolGroupTable and gui elements to search for symbols
	 * @param table Table of type SymbolGroupTable
	 */
	public void setSTable(SymbolGroupTable table)
	{
		table.setView(SymbolGroupTable.GROUP_VIEW);
		this.simbolTable = table;
		table.find(null);
		setDefaultGroups();
		setGroups();
		grpRenderer.setGroups(simbolTable.countGroupElements(isAdvanced));
		grpTable.setSelectedIndex(0);
		
		myMouseListener n = new myMouseListener();
		n = new myMouseListener();
		n.setToolTip(env);
		n.setText(Config.setToolTipString(mytext.getText("Grouping_symbols_title"), mytext.getText("Grouping_symbols")));
		
		MouseListener[] help = this.simbolTable.getMouseListeners();
		for(int i=1;i<help.length;i++)
		{
				if(help[i].getClass() == myMouseListener.class)
					this.simbolTable.removeMouseListener(help[i]);
		}
		
		this.simbolTable.addMouseListener(n);
		
		
		((SymbolGroupTable)table).remGrpFilter();
		view.removeAll();
		view.add(table);
	}
	
	/***
	 * Generates a String that can be saved as a group file 
	 * @return group file string
	 */
	public String generateGroupFile()
	{
		String output = "";
		try{
				
				//comments
				output += "# VampirTrace region groups specification\n";
				output += "# generated with VTSetup\n";
				output += "\n\n";
				
				Hashtable<String,ArrayList<String>> groups = new Hashtable<String,ArrayList<String>>();
				DefaultTableModel model = (DefaultTableModel) simbolTable.getModel();
				String group = "";
				String symbol = "";
				
				for(int i=0;i<model.getRowCount();i++)
				{
						if(		model.getValueAt(i, 4) == null || model.getValueAt(i, 4).toString().trim().equals("") 
								|| model.getValueAt(i, 4).toString().trim().equals(DefaultGroups.DEFAULTGROUP)
						   )
							continue;
						group = model.getValueAt(i, 4).toString();
						
					
					
					symbol = model.getValueAt(i, 1).toString();
					
					if(groups.containsKey(group))
					{
						groups.get(group).add(symbol);
					}
					else
					{
						ArrayList<String> helpgroup = new ArrayList<String>();
						helpgroup.add(symbol);
						groups.put(group, helpgroup);
					}
				}
				
				Iterator<String> ite = groups.keySet().iterator();
				String ausgabe ="";
				ArrayList<String> help = null;
				while(ite.hasNext())
				{
					group = ite.next().toString();
					ausgabe = group.trim()+"=";
					help = groups.get(group);
					for(int i=0;i<help.size()-1;i++)
					{
						ausgabe = ausgabe+help.get(i).toString().trim()+";";
					}
					ausgabe = ausgabe+help.get(help.size()-1).toString().trim();
					output += ausgabe;
					output += "\n";
				}
				
		}catch(Exception ex)
		{
			Config.errorHandler(ex);
		}	
		
		return output;
	}
	
	/***
	 * Generates a String that can be used to restore all gui and group informations of this widget
	 * @return String with all informations about the current {@link SymbolGroupTable symbolGroupTable}
	 */
	public String generateSaveString()
	{
		DefaultTableModel model = (DefaultTableModel) simbolTable.getModel();
		String output = "#save group settings\n";
		Object help = "";
		for(int i=0;i<model.getRowCount();i++)
		{
			if(model.getValueAt(i, 0).toString().endsWith("system"))
				continue;
			for(int j=0;j<model.getColumnCount();j++)
			{
				help = model.getValueAt(i, j);
				if(help==null)
					help="";
				output += help.toString()+";";
			}
			output +="\n";
			
		}
		return output;
	}
	
	/***
	 * uses a string generated by the {@link #generateSaveString() generateSaveString method} to restore settings
	 * @param loadString String with all informations to restore settings
	 */
	public void loadSettings(String loadString)
	{
		try{
			String[] array = loadString.split("\n");
			ArrayList<String> name = new ArrayList<String>();
			ArrayList<String> group = new ArrayList<String>();
			ArrayList<String> system = new ArrayList<String>();
			ArrayList<String> libtype = new ArrayList<String>();
			
			for(int i=0;i<array.length;i++)
			{
				if(array[i].length() <= 1)
					continue;
				if(array[i].startsWith("#"))
					continue;
				
				if(array[i].contains(";"))
				{
					array[i] = array[i].replace(";", " ;");
					String[] array2 = array[i].split(";");
					system.add(array2[0].trim());
					name.add(array2[1].trim());
					libtype.add(array2[2].trim());
					group.add(array2[4].trim());
				}	
			}
			
			simbolTable.addRow(name, group, system, libtype);
			setGroups();
		}catch(Exception ex)
		{
			Config.errorHandler(ex);
		}

	}
	
	
	/***
	 * Renderer class to format the view of the groupBox 
	 */
	public class MyTableRenderer extends DefaultListCellRenderer{
		/**
		 * generated serialVersionUID
		 */
		private static final long serialVersionUID = 8474590569159487404L;
		@SuppressWarnings("unused")
		private String currentChoice = ALL;    
		public static final String ALL = "All"; 
		private Hashtable<String,Integer> groups = null;
		private int allSymb = 0;
		public boolean isAdvanced = false;
		/***
		 * format current Object in list.
		 * @param list list Object
		 * @param value value of the current index
		 * @param index that is rendered
		 * @param isSelected true if this index is selected otherwise false
		 * @param cellHasFocus true if this index has focus otherwise false
		 */
		public Component getListCellRendererComponent(JList list, Object value,int index, boolean isSelected,boolean cellHasFocus)   
		{
			if(value == null)
				   return this;
			setText((value != null)?value.toString():"");
			 setFont(getFont().deriveFont(Font.PLAIN)); 
			
		      if(isSelected)
		    	  this.setBackground(Color.CYAN);
		      else
		    	  this.setBackground(Color.WHITE);

		      
		      if(groups != null && groups.containsKey(value.toString()))
		      {

		    	  this.setText(value+" ("+groups.get(value.toString())+" Symbols)");
		    	  
		    	  if(defGroups.isDefaultGroup(value.toString()))
		    	  {
		    		  setFont(getFont().deriveFont(Font.ITALIC));
		    		  this.setVisible(false);
		    	  }
			  }
		      else if(groups != null && index == 0)
		      {
		    	 setFont(getFont().deriveFont(Font.BOLD));
		    	 setText(value+" ("+allSymb+" Symbols)");
		      }
		      else
			      this.setText(value+" (0 Symbols)");
			  
		      if(value.toString().trim().equals(DefaultGroups.DEFAULTGROUP))
	    	  {
	    		  setFont(getFont().deriveFont(Font.BOLD));
	    	  }		    	  
		    
			  return this;
		 }
		
		
		/***
		 * set informations about the amount of symbols in a group
		 * @param groups Hashtable with group name as key and the amount of symbols in this group as value
		 */
		public void setGroups(Hashtable<String,Integer> groups)
		{
			this.groups = groups;
			 Collection<Integer> col = groups.values();
	    	  Iterator<Integer> it = col.iterator();
	    	  int count = 0;
	    	  while(it.hasNext())
	    	  {
	    		  count += it.next();
	    	  }
	    	  this.allSymb = count;
		}
		
		
		
	}
}
