/***************************************************************************
                          openmosixview.h  -  description
                             -------------------
    begin                : Son Jul 14 10:15:18 CEST 2002
    copyright            : (C) 2002 by Matt Rechenburg
    email                : mosixview@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OPENMOSIXVIEW_H
#define OPENMOSIXVIEW_H

// include files for QT
#include <qapp.h>
#include <qmainwindow.h>
#include <qaction.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qstatusbar.h>
#include <qwhatsthis.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qmsgbox.h>
#include <qfiledialog.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qgroupbox.h>
#include <qscrollbar.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qslider.h>
#include <qlcdnumber.h>
#include <qprogressbar.h>
#include <qtimer.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qtextstream.h>
#include <qlistbox.h>
#include <qaccel.h>
#include <qtabdialog.h>
#include <qmultilineedit.h>
#include <qlineedit.h>
#include <qfont.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qdial.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qcheckbox.h>


#include <stdlib.h>
#include <string>
#include <list>
#include <iostream>
#include <fstream>
#include <dirent.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/resource.h>


// application specific includes
#include "openmosixviewview.h"
#include "openmosixviewdoc.h"
#include "resource.h"


#define VERSION "1.5"
#define clustercommand "mosctl"
#define clusterdirectory "/proc/hpc/nodes/"
#define configfile "/root/.openMosixview"
#define displayfile "/root/.openMosixview.disp"
#define init1 "/etc/init.d/openmosix"
#define init2 "/etc/rc.d/init.d/openmosix"
#define collectorpid "/var/run/openMosixcollector.pid"
#define threedmosmon "/usr/bin/3dmosmon"


using namespace std;

/**
  * This Class is the base class for your application. It sets up the main
  * window and providing a menubar, toolbar
  * and statusbar. For the main view, an instance of class OpenMosixViewView is
  * created which creates your view.
  */
class OpenMosixViewApp : public QMainWindow
{
  Q_OBJECT
  
  public:
	/** construtor */
	OpenMosixViewApp();
	/** destructor */
	~OpenMosixViewApp();
	/** initializes all QActions of the application */
	void initActions();
	/** initMenuBar creates the menu_bar and inserts the menuitems */
	void initMenuBar();
	/** setup the statusbar */
	void initStatusBar();

	// get nodes hostname by its node id
	string getnodename(string node);
	
	// get how many nodes we are
	int gethowmanynodes();

	// check if the cluster configuration changed
	bool checknodes();

	// returns values from the proc-interface
	string getprocvalue( string nodeid, string what );

	// ssh configuration
	bool sshconfig;


	// public values

	// the nodelist
	list<string> nodelist;

	// the main refresh timer
 	QTimer *internalTimer;
	
	// if we should restart the next refersh
	int restart;


  public slots:

	/** exits the application */
	void slotFileQuit();

	/** toggle the statusbar*/
	void slotViewStatusBar(bool toggle);

	/** shows an about dlg*/
	void slotHelpAbout();

	/** shows help*/
	void slotHelp();

	// scroll the main widget
	void scroll_view( int value );

	// open the configuration window
	void neuwin();

	// close config window
	void close_config();

	// draw the cluster on the main-widget
	void drawcluster();

	// redraw
	void redrawcluster();

	// refresh
	void refresh();

	// set clusternodes to nodes
	void setclusternodes(int nodes);

	// enter what's this mode
	void slot_whatisthis();

	// set sshconfig
	void setsshconfig();

	// set the speed of a node
	void setspeed(int speed);

	// saves the config
	void save_config();

	// loads the config
	void load_config();

	// toggle the action buttons
	void action_lstay();
	void action_nolstay();
 	void action_migration();
 	void action_nomigration();
	void action_stop();
	void action_start();
 	void action_block();
 	void action_noblock();
 	void action_noquiet();
 	void action_quiet();

	// clears the display history file
	void clear_history();

	// cancel the changes in the configuration window
	void cancel_changes();

	// open remote console
	void open_remotecon();

	// apply configuration
	void apply_changes();

	// execute a program
	void slotFileOpen();

	// run program
	void execute_it();

	// sync the display of the execution window
	void parallel_command();

	// sync the display of the execution window
	void no_parallel();

	// parallel execution
	void parallel_execute_it();

	// sync the paralle execution spinboxes
	void sync_qspinbox(int val);

	// open a local processbox
	void proc_box();

	// open a remote processbox
	void open_remoteprocs();

	// managing the openMosixcollector
	void start_openMosixcollector();
	void stop_openMosixcollector();
	void checkpoint_openMosixcollector();
	void restart_openMosixcollector();

	// start the openMosixanalyzer
	void start_openMosixanalyzer();

	// start the openMosixmigmon
	void start_openMosixmigmon();

	// start 3dmosmon
	void start_3dmosmon();
	
	// to adjust the timer by the qspinbox
	void adjusttimer(int val);

protected:
	// widgets for the main-view
	QGroupBox *QGroupBox_1;
	QScrollBar *QScrollBar_1;
	QLabel *QLabel_clusternodes;
	QLabel *QLabel_clusterid;
	QLabel *QLabel_clusterid_label;
	QPushButton *QPushButton_all_nodes;
	QPushButton *QPushButton_host[1000];
	QLabel *QLabel_stat[1000];
	QSlider *QSlider_host[1000];
	QLCDNumber *QLCDNumber_host[1000];
	QProgressBar *QProgressBar_host[1000];
 	QProgressBar *QProgressBar_mem[1000];
 	QLabel *QLabel_memo[1000];
	QLabel *QLabel_howmany_cpus[1000];
	QProgressBar *QProgressBar_overall;
	QProgressBar *QProgressBar_balance;
 	QLabel *QLabel_balance;
	QLabel *QLabel_overall_load;
	QLabel *QLabel_overall_mem;
	QLabel *QLabel_overall_mem1;
	QLabel *QLabel_overall_mem2;
	QLabel *QLabel_overall_mem3;
	QProgressBar *QLabel_overall_memory;
	QLabel *QLabel_overall_memory1;
	QLabel *QLabel_allcpu;
	QLabel *QLabel_allcpu1;
	QLabel *ontop;
	QToolButton *fileOpen;
	QToolButton *configsave;
	QToolButton *exec_procbox;
	QToolButton *whatisthis;
	QToolButton *helpme;
	QToolButton *analyzer;
	QToolButton *migmon;
	QToolButton *tdmosmon;
	QLabel *label_collector1;
	QLabel *label_collector2;
	QSpinBox *refreshtimeoutbox;
	QLabel *label_refresh1;
	QLabel *label_refresh2;
	
	// widget for the configuration window
	QPushButton *QPushButton_config_remotebox;
	QPushButton *QPushButton_config_remoteconsole;
	QPushButton *QPushButton_config_automig_on;
	QPushButton *QPushButton_config_automig_off;
	QPushButton *QPushButton_config_lstay;
	QPushButton *QPushButton_config_nolstay;
	QPushButton *QPushButton_config_block;
	QPushButton *QPushButton_config_noblock;
	QPushButton *QPushButton_config_cluster_start;
	QPushButton *QPushButton_config_cluster_stop;
	QPushButton *QLabel_config_quiet_yes;
	QPushButton *QLabel_config_quiet_no;
	QPushButton *QPushButton_config_closewindow;
	QLabel *QLabel_hostconf;
	QLabel *QLabel_config_automig_label;
	QLabel *QPushButton_config_lstay_label;
	QLabel *QPushButton_config_noblock_label;
	QLabel *QPushButton_config_cluster_label;
	QLabel *QLabel_config_title;
	QLabel *QLabel_config_quiet_label;
	QLabel *QLabel_config_node;
	QLabel *QLabel_config_icon;
	QLabel *QLabel_config_display;
	QLabel *QLabel_config_display1;
	QLabel *QLabel_config_display2;
	QComboBox *display_edit;
	QPushButton *QPushButton_clear;
	QPushButton *QPushButton_chistory;
	QPushButton *QPushButton_config_cancelconfig;
	QWidget *hinten1;
	QSpinBox *display_one;
	QSpinBox *display_two;
	QPushButton *QPushButton_config_applyconfig;
	QLabel *label_rule;


	// widgets from the advanced execution dialog
	QWidget *hinten2;
 	QRadioButton *nomig_check;
	QRadioButton *runhome_check;
	QRadioButton *runon_check;
	QRadioButton *cpu_check;
	QRadioButton *iojob_check;
	QRadioButton *nodecay_check;
	QRadioButton *slowdecay_check;
	QRadioButton *fastdecay_check;
	QRadioButton *parallel_check;
	QDial *host_chooser;
	QLCDNumber *lcd_host_chooser;
	QLabel *option_label1;
	QLabel *option_label2;
	QLabel *option_label3;
	QLabel *node_hint;
	QSpinBox *parallel_from;
	QSpinBox *parallel_to;
	QLabel *parallel_label1;
	QLabel *parallel_label2;
	QLabel *parallel_label3;
	QPushButton *QPushButton_exe_end;
	QPushButton *QPushButton_parallel_exe;
	QPushButton *QPushButton_exe;
	QLineEdit *command_line;
 	QLabel *exec_label1;
	QLabel *exec_label2;



	// howmany nodes we are
	int clusternodes;

	// adjust the scrollbar at resize
	virtual void resizeEvent(QResizeEvent* ev) {
	  QScrollBar_1->setGeometry(720,90,20,ev->size().height()-110);
	}

  private:

    /** view is the main widget which represents your working area. The View
     * class should handle all events of the view widget.  It is kept empty so
     * you can create your view according to your application's needs by
     * changing the view class.
     */
    OpenMosixViewView *view;
    /** doc represents your actual document and is created only once. It keeps
     * information such as filename and does the serialization of your files.
     */
    OpenMosixViewDoc *doc;
  
	QPopupMenu *fileMenu;
	QPopupMenu *confmenu;
	QPopupMenu *viewMenu;
	QPopupMenu *helpMenu;
	QPopupMenu *collectormenu;
	QPopupMenu *collector_start_stop;
 	QAction *config_stat;
	QAction *fileQuit;
	QAction *viewStatusBar;

    QAction *helpAboutApp;
};
#endif 

