/***************************************************************************
                          movieplayer.h  -  description
                             -------------------
    begin                : Son Mr 16 2003
    copyright            : (C) 2003 by Matt Rechenburg
    email                : mosixview@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MOVIEPLAYER_H
#define MOVIEPLAYER_H

#include <qwidget.h>
#include <qframe.h>
#include <qfiledialog.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qpainter.h>
#include <qmessagebox.h>
#include <qmovie.h>
#include <qvbox.h>


/**
  *@author Matt Rechenburg
  */

class movieplayer : public QFrame  {
    Q_OBJECT
    QMovie movie;
    QString filename;
    QSize sh;


public:
    movieplayer(const char* fname, QMovie m, QWidget* p=0, const char* name=0, WFlags f=0) :
        QFrame(p, name, f),
        sh(32,32)
    {
        setCaption(fname);
        filename = fname;
        movie = m;

        // No background needed, since we draw on the whole widget.
//        movie.setBackgroundColor(backgroundColor());
//        setBackgroundMode(NoBackground);

        // Get the movie to tell use when interesting things happen.
        movie.connectUpdate(this, SLOT(movieUpdated(const QRect&)));
        movie.connectResize(this, SLOT(movieResized(const QSize&)));
        movie.connectStatus(this, SLOT(movieStatus(int)));

        setSizePolicy(QSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding));
    }

    QSize sizeHint() const
    {
        return sh;
    }


protected:

    // Draw the contents of the QFrame - the movie and on-screen-display
    void drawContents(QPainter* p)
    {
        // Get the current movie frame.
        QPixmap pm = movie.framePixmap();

        // Get the area we have to draw in.
        QRect r = contentsRect();

        if ( !pm.isNull() ) {
            // Only rescale is we need to - it can take CPU!
            if ( r.size() != pm.size() ) {
                QWMatrix m;
                m.scale((double)r.width()/pm.width(),
                        (double)r.height()/pm.height());
                pm = pm.xForm(m);
            }

            // Draw the [possibly scaled] frame.  movieUpdated() below calls
            // repaint with only the changed area, so clipping will ensure we
            // only do the minimum amount of rendering.
            //
            p->drawPixmap(r.x(), r.y(), pm);

        }

    }

public slots:
    void restart()
    {
        movie.restart();
        repaint();
    }

    void togglePause()
    {
        if ( movie.paused() )
            movie.unpause();
        else
            movie.pause();
        repaint();
    }


    void run()  {
     movie.unpause();
     repaint();
    }

    void stop()  {
     movie.pause();
    }


    void step()
    {
        movie.step();
        repaint();
    }

    void step10()
    {
        movie.step(10);
        repaint();
    }

private slots:
    void movieUpdated(const QRect& area)
    {
        if (!isVisible())
            show();

        // The given area of the movie has changed.

        QRect r = contentsRect();

        if ( r.size() != movie.framePixmap().size() ) {
            // Need to scale - redraw whole frame.
            repaint( r );
        } else {
            // Only redraw the changed area of the frame
            repaint( area.x()+r.x(), area.y()+r.x(),
                     area.width(), area.height() );
        }
    }

    void movieResized(const QSize& size)
    {
        // The movie changed size, probably from its initial zero size.

        int fw = frameWidth();
        sh = QSize( size.width() + fw*2, size.height() + fw*2 );
        updateGeometry();
        if ( parentWidget() && parentWidget()->isHidden() )
            parentWidget()->show();
    }

    void movieStatus(int status)
    {
        // The movie has sent us a status message.

        if (status < 0) {
            QString msg;
            msg.sprintf("Could not play movie \"%s\"", (const char*)filename);
            QMessageBox::warning(this, "movies", msg);
            parentWidget()->close();
        } else if (status == QMovie::Paused || status == QMovie::EndOfMovie) {
            repaint(); // Ensure status text is displayed
        }
    }



};

#endif
