/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Sam Mr 15 14:50:08 CET 2003
    copyright            : (C) 2003 by Matt Rechenburg
    email                : mosixview@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qapplication.h>
#include <qfont.h>
#include <qstring.h>
#include <qtextcodec.h>
#include <qtranslator.h>

#include "openmosixpidlog.h"

extern int file_exist(string filename);


int main(int argc, char *argv[])
{
  if (argc!=2) {
    cout << "Usage: openmosixpidlog [PID]" << endl;
    cout << "Try again" << endl;
    exit(-1);
  }

  string processid=argv[1];
  int mypid=atoi(processid.c_str());
  string checkfile="/proc/";
  checkfile=checkfile+processid;
  checkfile=checkfile+"/cmdline";

  if ((mypid>0) && (file_exist(checkfile.c_str()))) {
    cout << "attached to PID " << processid << endl;
    } else {
    cout << "bad commandline argument or PID does not exist!" << endl;
    cout << "Usage: openmosixpidlog [PID]" << endl;
    cout << "Try again" << endl;
    exit(-1);
  }



  QApplication a(argc, argv);
  a.setFont(QFont("helvetica", 10));
  QTranslator tor( 0 );
  tor.load( QString("openmosixpidlog.") + QTextCodec::locale(), "." );
  a.installTranslator( &tor );

  OpenMosixpidlogApp *openmosixpidlog=new OpenMosixpidlogApp(processid);
  a.setMainWidget(openmosixpidlog);

  openmosixpidlog->setMinimumSize(300,100);
  openmosixpidlog->setMaximumSize(300,100);
  openmosixpidlog->setGeometry(400,100,300,100);
  
  QFont hfont("helvetica");
  hfont.setPixelSize(10);
  openmosixpidlog->setFont(hfont);
	     
  openmosixpidlog->show();

  return a.exec();
}


