/***************************************************************************
                          omproc.h  -  description
                             -------------------
    begin                : Son Jan 5 2003
    copyright            : (C) 2003 by Matt
    email                : mosixview@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OMPROC_H
#define OMPROC_H

#include <stdlib.h>
#include <stdio.h>
#include <string>
#include <list>
#include <map>
#include <iostream>
#include <fstream>
#include <dirent.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/resource.h>
#include <math.h>

#include "procwidget.h"

using namespace std;

/**
  *@author Matt
  */

class oMProc {

public:

// constructors
	oMProc();
	oMProc(int c_ompid, int c_where);
	oMProc(int c_ompid, int c_where, string commandline);

// destructor
	~oMProc();

// public methods

  void setProc(int s_where, int s_localX, int s_localY);

  // returns true if the process is local, false for remote procs
  bool islocal();

  // returns the remote node ID where the process is running
  int ishere();

  // returns the PID
  int getompid();

  // returns Xpos
  int getxpos();

  // returns ypos
  int getypos();

  // set xpos
  void setxpos(int s_localX);

  // set ypos
  void setypos(int s_localY);

private:


  int ompid;
  int where;
  int localX;
  int localY;

  string commandline;




};


#endif
