/***************************************************************************
                          nodewidget.h  -  description
                             -------------------
    begin                : Mon Jan 6 2003
    copyright            : (C) 2003 by Matt
    email                : mosixview@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef NODEWIDGET_H
#define NODEWIDGET_H


#include <qwidget.h>
#include <qlabel.h>
#include <qtooltip.h>
#include <qdragobject.h>



#include <stdlib.h>
#include <stdio.h>
#include <string>
#include <iostream>
#include <fstream>

#include <dirent.h>
#include <sys/types.h>

#define MAXMIGGROUPS 1000

using namespace std;


/**
  *@author Matt
  */

class nodewidget : public QLabel  {
   Q_OBJECT
public: 

// constructor
nodewidget::nodewidget(QWidget *parent, const char *name ) : QLabel(parent,name) {

  myname=name;
  QString nodetip;
  nodetip.sprintf("openMosix node %s", name);
  QToolTip::add(this, nodetip);

  // for drag + drop
  setAcceptDrops(true);

}

// destructor
nodewidget::~nodewidget(){
}


string nodewidget::getmyname() {
  return myname;
}

string int2string(const int i) {
  char buf[12];
  sprintf(buf,"%d",i);
  return(string(buf));
}


protected:


  virtual void dragEnterEvent(QDragEnterEvent *event) {
    if (QTextDrag::canDecode(event)) {
      event->accept();
    }
  }


  virtual void dropEvent(QDropEvent *event) {
    QString textdrop;
    if(QTextDrag::decode(event, textdrop)) {

     DIR *dir;
     struct dirent *dir_info;
     string processname;
     string temp;
     string miggroupvalue;
     string procdir = "/proc/";
     char zeile[21];
     string migcommand;

     string mynodeID;
     mynodeID=this->getmyname();

     // prepare the cmdline
     int migpid=textdrop.toInt();

     // get mymiggroup
     string miggroup;
     int mymiggroupnumber=0;
     int miggroupnumber=0;
     char zeile1[21];
     string mypgfile=procdir;
     mypgfile=mypgfile + int2string(migpid);
     mypgfile=mypgfile+ "/miggroup";

     std::ifstream getpgconf(mypgfile.c_str());
     if (getpgconf) {
      getpgconf.getline(zeile1, 20);
      miggroup.erase();
      miggroup=miggroup+zeile1;
      getpgconf.close();
      mymiggroupnumber=atoi(miggroup.c_str());
      if(mymiggroupnumber>MAXMIGGROUPS) {
        mymiggroupnumber=0;
      }

      } else {
      cout << "could not get processgroup for " << migpid << endl;
     }

     // if mymiggroup > 0
     if ((mymiggroupnumber>0) && (mymiggroupnumber<MAXMIGGROUPS)) {

      // for each proc->miggroup = mymiggroup
    	if ((dir=opendir("/proc/"))!=NULL) {

    		while ((dir_info = readdir(dir))!=NULL) {
    			processname.erase();
    			processname = processname + dir_info->d_name;

    			if((strchr(processname.c_str(), '1'))||(strchr(processname.c_str(), '2'))||(strchr(processname.c_str(), '3'))||(strchr(processname.c_str(), '4'))||(strchr(processname.c_str(), '5'))||(strchr(processname.c_str(), '6'))||(strchr(processname.c_str(), '7'))||(strchr(processname.c_str(), '8'))||(strchr(processname.c_str(), '9')) ) {

       			temp.erase();
    				temp = temp + procdir;
    				temp = temp + processname;
    				temp = temp + "/miggroup";				
    				std::ifstream readprocmiggrp(temp.c_str());
    				if (readprocmiggrp) {
    					readprocmiggrp.getline(zeile, 20);
    					miggroupvalue.erase();
    					miggroupvalue= miggroupvalue+zeile;
              miggroupnumber=atoi(miggroupvalue.c_str());

              if ((miggroupnumber>0) && (miggroupnumber<MAXMIGGROUPS) && (miggroupnumber==mymiggroupnumber)) {
                // here we migrate because the processes belongs to the same miggroup
                migcommand.erase();
                migcommand = migcommand + "migrate ";
                migcommand = migcommand +  processname;
                migcommand = migcommand + " ";
                migcommand = migcommand + mynodeID;
                cout << migcommand << endl;
                system(migcommand.c_str());
               }

    					readprocmiggrp.close();
            }
    			}

    		} //while
    		closedir(dir);
      }



      } else {
      // if miggroup == 0 or > MAXGROUP
      migcommand.erase();
      migcommand = migcommand + "migrate ";
      migcommand = migcommand +  int2string(migpid);
      migcommand = migcommand + " ";
      migcommand = migcommand + mynodeID;
      cout << migcommand << endl;
      system(migcommand.c_str());
    }
   }
  }


private:

  int ddButton;
  QPoint dragStartPos;

  string myname;


};

#endif
