/***************************************************************************
                          openmosixhistory.h  -  description
                             -------------------
    begin                : Don Aug  8 10:07:58 CEST 2002
    copyright            : (C) 2002 by Matt Rechenburg
    email                : mosixview@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OPENMOSIXHISTORY_H
#define OPENMOSIXHISTORY_H

// include files for QT
#include <qapp.h>
#include <qmainwindow.h>
#include <qaction.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qstatusbar.h>
#include <qwhatsthis.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qmsgbox.h>
#include <qfiledialog.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qslider.h>


#include <stdlib.h>
#include <string>
#include <list>
#include <iostream>
#include <fstream>
#include <dirent.h>

// application specific includes
#include "openmosixhistoryview.h"
#include "openmosixhistorydoc.h"

#define VERSION "1.5"
#define logdirectory "/tmp/openmosixcollector/"

using namespace std;


/**
  * This Class is the base class for your application. It sets up the main
  * window and providing a menubar, toolbar
  * and statusbar. For the main view, an instance of class OpenMosixHistoryView is
  * created which creates your view.
  */
class OpenMosixHistoryApp : public QMainWindow
{
  Q_OBJECT
  
  public:
    /** construtor */
    OpenMosixHistoryApp(string name);
    /** destructor */
    ~OpenMosixHistoryApp();
    /** initializes all QActions of the application */
    void initActions();
    /** initMenuBar creates the menu_bar and inserts the menuitems */
    /** setup the statusbar */
    void initStatusBar();
    /** setup the document*/

	// which directory to analyze
	string logg;

  public slots:

	// for entering what is this mode
	void slot_whatisthis();

	// fills the processbox with data from /proc
	void fill_procbox(int when);

	// syncronize user list box
	void sync_user(int index);

	// set the logdirectory variable to the current logdir
	void setlogdirectory(string logdir);


	protected:

	QComboBox *userbox;
	QLabel *user_select_label;
	QLabel *QLabel_userbox;
	QListView *processbox;
	QToolButton *what_this_button;
	QPushButton *QPushButton_1;
	QSlider *QSlider_timeline;
	QLabel *QLabel_time_label;
	QLabel *QLabel_start_time;
	QLabel *QLabel_start_time_label;



	virtual void resizeEvent(QResizeEvent* ev) {
		processbox->setGeometry(5,85,ev->size().width()-10,ev->size().height()-140);
		QPushButton_1->setGeometry(ev->size().width()-65,ev->size().height()-40,60,20);
		QSlider_timeline->setGeometry(5,30,ev->size().width()-10,30);
	}



  private:



};
#endif 

