/***************************************************************************
                          openmosixcollector.cpp  -  description
                             -------------------
    begin                : Sat Jul 27 2002
    copyright            : (C) 2002 by Matt Rechenburg
    email                : mosixview@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "openmosixcollector.h"

openmosixcollector::openmosixcollector(){
}
openmosixcollector::~openmosixcollector(){
}


// helping functions

int writepidfile(int pid) {
	std::ofstream pidfile(collectorpid);
	if (pidfile) {
		pidfile << pid;
		pidfile.close();
		return 1;
		} else {
		cout << "could not write to " << collectorpid << endl;
		return 0;
	}
}

int removepidfile() {
	return unlink(collectorpid);
}



  int file_exist(string filename)
{
	std::ifstream readfilename(filename.c_str());
	if (readfilename) {
		readfilename.close();
		return 1;
		} else {
		return 0;
	}
}

int string2int(const string s) {
        if (s.length() == 0) {
                return -1;
        } else {
                return(atoi(s.c_str()));
        }
}

string int2string(const int i) {
        char buf[12];
        sprintf(buf,"%d",i);
        return(string(buf));
}

int min(int eins, int zwei) {
	if(eins>zwei) {
		return zwei;
		} else {
		return eins;
	}
}

int max(int eins, int zwei) {
 	if(eins<zwei) {
		return zwei;
		} else {
		return eins;
	}
}



void checklogdirectory() {

	string prochistorydir;
	prochistorydir.erase();
	prochistorydir = prochistorydir + logdirectory;
	prochistorydir = prochistorydir + "/phist";
	if (!file_exist(logdirectory)) {
		mkdir(logdirectory, 0777);
	}
	if (!file_exist(prochistorydir.c_str())) {
		mkdir(prochistorydir.c_str(), 0777);
	}
}



string currentdate() {
	struct tm datestring;
	time_t yet;
	time(&yet);
	datestring = *localtime(&yet);
	string returndate;
	returndate.erase();
	returndate = returndate + int2string(datestring.tm_mday);
	returndate = returndate + ".";
	returndate = returndate + int2string(datestring.tm_mon);
	returndate = returndate + ".";
	returndate = returndate + int2string(datestring.tm_year+1900);
	returndate = returndate + "-";
	returndate = returndate + int2string(datestring.tm_hour);
	returndate = returndate + ".";
	returndate = returndate + int2string(datestring.tm_min);
	returndate = returndate + ".";
	returndate = returndate + int2string(datestring.tm_sec);
	return returndate;
}


string removespaces(string remove) {
string endstr;
string::iterator p = remove.begin();
	for (p=remove.begin(); p!=remove.end(); p++) {
		string tmpstr;
		tmpstr = *p;
		if(tmpstr==" ") {
			tmpstr.erase();
		}
		endstr = endstr + tmpstr;
	}
	return endstr;
}


string onlyfirstpart(string firstpart) {
string endstr;
string::iterator p = firstpart.begin();
	for (p=firstpart.begin(); p!=firstpart.end(); p++) {
		string tmpstr;
		tmpstr = *p;
		if(tmpstr==" ") {
			return endstr;
		}
		endstr = endstr + tmpstr;
	}
	return endstr;
}



string readfromproc(string pid, string what) {
 char zeile[201];
 string temps, tempret;
 temps = temps + "/proc/";
 temps = temps + pid;
 temps = temps + "/";
 temps = temps + what;
 std::ifstream readprocval(temps.c_str());
 if (readprocval) {
  readprocval.getline(zeile, 200);
  tempret.erase();
  tempret= tempret+zeile;
  readprocval.close();
  } else {
  tempret="0";
 }
 return tempret;
}


// end of helping functions



int openmosixcollector::daemonize() {
	int pid;

	if(file_exist(collectorpid)) {
		cout << "openMosixcollector PID file exists!" << endl;
		cout << "Trying to stop old openMosixcollector-instance..." << endl;
   	kill();
	}


	if ((pid = fork()) == -1) {
		cout << "openMosixcollector daemon not started." << endl;
		cout << "Problems during fork!" << endl;
		return -1;
		} else {
		if (pid) {
			cout << "openMosixcollector daemon succesfull started PID " << pid << endl;
			if(!writepidfile(pid)) {
				return -1;
			}			
			exit(0);
		}
	return 1;
	}
}




int openmosixcollector::kill() {
   char zeile[101];
	string getpid;
	string killcommand;
	int error;
	if (file_exist(collectorpid)) {
	// we have a pid file
		std::ifstream readcollectorpid(collectorpid);
		if (readcollectorpid) {
			readcollectorpid.getline(zeile, 100);
			getpid.erase();
			getpid= getpid+zeile;
			readcollectorpid.close();
			removepidfile();
			} else {
			cout << "could not read from "  << collectorpid << endl;
			return 0;
		}
		killcommand.erase();
		killcommand = killcommand + "kill ";
		killcommand = killcommand + getpid;
		if((error=system(killcommand.c_str())) > 0) {
			cout << "Could not stop PID "  << getpid << endl;
			return 0;
			} else {
			cout << "Successfully stopped collector with PID "  << getpid << endl;   		
		}

		} else {
		// no pid file
		cout << "No PID file: "  << collectorpid << endl;
		killcommand.erase();
		killcommand = killcommand + "killall  openmosixcollector";
		if((error=system(killcommand.c_str())) > 0) {
			cout << "Could not stop collector"  << endl;
			return 0;
			} else {
			cout << "Successfully stopped collector" << endl;   		
			return 1;
		}
	}
return 1;
}




// returns howmany nodes we are
int openmosixcollector::gethowmanynodes() {
	struct dirent **namelist;
	int n;
	int howmanynodes=0;
	n = scandir(clusterdirectory, &namelist, 0, 0);
	if (n < 0) {
		perror("scandir");
		return 0;
		} else {
		while(n--) {
			if(!strchr(namelist[n]->d_name, '.')) {
				howmanynodes++;
				free(namelist[n]);
			}
		}
		free(namelist);
	return howmanynodes;
	}	
}



 // check if the cluster-config changed
 bool openmosixcollector::checknodes() {
	if (gethowmanynodes()==clusternodes) {
		return true;
		} else {
   	return false;
	}
}



void openmosixcollector::updatenodelist() {
	struct dirent **namelist;
	int n;
	int howmany = 0;
	n = scandir(clusterdirectory, &namelist, 0, 0);
	if (n < 0) {
		perror("scandir");
		} else {
		nodelist.clear();
		while(n--) {
			if(!strchr(namelist[n]->d_name, '.')) {
				// add node id to nodelist
				nodelist.push_front(namelist[n]->d_name);
				howmany++;
				free(namelist[n]);
			}
		}
		free(namelist);
		clusternodes = howmany;
	}	
}


void openmosixcollector::lognodes() {

	int load_percent, omemory_percent, omemo;
	int oload, omem, otmem, ocpus, ospeed;
	int allcpus=0;
	int mean=0;
	int online=0;
	int mem_mean=0;
	int allmemo=0;
	int mem_mean_percent=0;
	int diff=0;
	int mini=200;
	int maxi=0;
	string nodelogfile_txt;
	string clusterlogfile_txt;
	string now, now1;
  int s;

	
	// checks if the logdirectory exist
	checklogdirectory();

	// gathering nodes values
	list<string>::iterator p = nodelist.begin();
	while (p != nodelist.end()) {
		string nodeid=(string)*p;

		// speed
		ospeed=string2int(getprocvalue(nodeid, "speed"));
		if(ospeed>0) {
			online++;
		}
		// load
		oload=string2int(getprocvalue(nodeid, "load"));
		if (oload>0) {
			if(oload>200) {
				oload=200;
			}
			load_percent=(oload*100)/200;
			mini=min(mini, load_percent);
			maxi=max(maxi, load_percent);
			mean=mean+oload;
         } else {
			// node is online but has no load
			if(ospeed>0) {
				mini=0;
			}
			load_percent=0;
		}

		// mem
		omem=string2int(getprocvalue(nodeid, "mem"));
		omem=omem/1048576;
		otmem=string2int(getprocvalue(nodeid, "tmem"));
		otmem=otmem/1048576;
		omemo = otmem-omem;
		if((omemo>0) && (otmem>0)) {
			omemory_percent=(omemo*100)/otmem;
			allmemo=allmemo+otmem;
			mem_mean=mem_mean+omemo;
			} else {
			omemory_percent = 0;
		}

		// cpus
		ocpus=string2int(getprocvalue(nodeid, "cpus"));
		allcpus=allcpus+ocpus;

		// write to nodefile
		now.erase();
		now = now + currentdate();
		nodelogfile_txt.erase();
		nodelogfile_txt = nodelogfile_txt + logdirectory;
		nodelogfile_txt = nodelogfile_txt + "/";
		nodelogfile_txt = nodelogfile_txt + nodeid;

    // here we check if the nodelog-file exist
    // if not we sync it
    if (file_exist(nodelogfile_txt)) {

  		std::ofstream nodelogfile(nodelogfile_txt.c_str(), ios::app);
  		if (nodelogfile) {
  			// T -> currenttime
  			nodelogfile << now;
  			// L -> load
  			nodelogfile << " ";
  			nodelogfile << load_percent;
  			// S -> speed
  			nodelogfile << " ";
  			nodelogfile << ospeed;
  			// M -> available memory
  			nodelogfile << " ";
  			nodelogfile << otmem;
  			// U -> used memory
  			nodelogfile << " ";
  			nodelogfile << omemory_percent;
  			// C -> cpus
  			nodelogfile << " ";
  			nodelogfile << ocpus;
  			// E -> end
  			nodelogfile << "\n";
        nodelogfile.close();
   			} else {
  			cout << "could not write to " << nodelogfile_txt << endl;
  		}

      } else {
      // we need to sync the nodelog-file

    	string tmpstr;
    	string cread;
    	int countit=0;
    	char zeile[21];
    	tmpstr=tmpstr + logdirectory + "/" + syncfile;
    	std::ifstream readval(tmpstr.c_str());
    	if (readval) {
    		readval.getline(zeile, 20);
    		cread.erase();
    		cread=cread+ zeile;
    		readval.close();
    		countit=string2int(cread);
    		if(countit<0) {
    			countit=0;
    		}
    	}

      // add countit 0 values to the nodelog-file to sync
      for (s=0; s<countit; s++) {

    		std::ofstream synclogfile(nodelogfile_txt.c_str(), ios::app);
    		if (synclogfile) {
    			// T -> currenttime
    			synclogfile << now;
    			// L -> load
    			synclogfile << " ";
    			synclogfile << 0;
    			// S -> speed
    			synclogfile << " ";
    			synclogfile << 0;
    			// M -> available memory
    			synclogfile << " ";
    			synclogfile << 0;
    			// U -> used memory
    			synclogfile << " ";
    			synclogfile << 0;
    			// C -> cpus
    			synclogfile << " ";
    			synclogfile << 0;
    			// E -> end
    			synclogfile << "\n";
          synclogfile.close();
     			} else {
    			cout << "could not write to " << nodelogfile_txt << endl;
    		}
       } // end of for
        cout << "synced the file " << nodelogfile_txt << endl;


    }
    // end of sync check

		
		p++;
	} // end of node loop

	// overall values
	diff=maxi-mini;
	maxi=200;
	mini=0;
	if(online>0) {
		mean=mean/online;
		mean=(mean*100)/200;
		if(allmemo>0) {
			mem_mean_percent=(mem_mean*100)/allmemo;
			} else {
			mem_mean_percent=0;
		}
		} else {
		mean=0;
		mem_mean_percent=0;
	}

	// write to clusterfile
	now1.erase();
	now1 = now1 + currentdate();
	clusterlogfile_txt.erase();
	clusterlogfile_txt = clusterlogfile_txt + logdirectory;
	clusterlogfile_txt = clusterlogfile_txt + "/cluster";
	std::ofstream clusterlogfile(clusterlogfile_txt.c_str(), ios::app);
	if (clusterlogfile) {
		// T -> currenttime
		clusterlogfile << now1;
		// L -> load
		clusterlogfile << " ";
		clusterlogfile << mean;
		// B -> balancing
		clusterlogfile << " ";
		clusterlogfile << 200-diff;
		// M -> available memory
		clusterlogfile << " ";
		clusterlogfile << allmemo;
		// U -> used memory
		clusterlogfile << " ";
		clusterlogfile << mem_mean_percent;
		// C -> cpus
		clusterlogfile << " ";
		clusterlogfile << allcpus;
		// E -> end
		clusterlogfile << "\n";
		clusterlogfile.close();
		} else {
		cout << "could not write to " << clusterlogfile_txt << endl;
	}
}






// returns values from /proc interface
string openmosixcollector::getprocvalue( string nodeid, string what ) {

	string tmpstr;
	string cread;
	char zeile[21];
	tmpstr=tmpstr + clusterdirectory + nodeid + "/" + what;
	std::ifstream readval(tmpstr.c_str());
	if (readval) {
		readval.getline(zeile, 20);
		cread.erase();
		cread=cread+ zeile;
		readval.close();
		if(string2int(cread)<0) {
			return "0";
			} else {
			return cread;
		}
		} else {
		cout << "could not read from " << clusterdirectory << what << tmpstr << endl;
		return "0";
	}
}




void openmosixcollector::logprocesshistory(int tsecs) {

	DIR *dir;
	FILE *fp;
	struct dirent *dir_info;
	string processname;
	string temp;
	string cmdlinevalue, wherevalue, cannotvalue, processnicevalue, statusvalue, nmigsvalue, lockvalue;
	char *userid;
	userid = new char[50];
	char *userid1;
	userid1 = new char[50];
	char *stat;
	stat = new char[50];
  	string procdir = "/proc/";
	string stripwhere;
	char zeile[201];
	int proc_nice=0;
	int current_procprio=0;
	int raus=0;
	string processlogfile_txt;
	string now;
        char *cmdtmp;
        cmdtmp = new char[50];
        char *cmdtmp1;
        cmdtmp1 = new char[50];
				

	if ((dir=opendir("/proc"))!=NULL) {

		while ((dir_info = readdir(dir))!=NULL) {
			processname.erase();
			processname = processname + dir_info->d_name;

			if((strchr(processname.c_str(), '1'))||(strchr(processname.c_str(), '2'))||(strchr(processname.c_str(), '3'))||(strchr(processname.c_str(), '4'))||(strchr(processname.c_str(), '5'))||(strchr(processname.c_str(), '6'))||(strchr(processname.c_str(), '7'))||(strchr(processname.c_str(), '8'))||(strchr(processname.c_str(), '9')) ) {

	


                                temp.erase();
                                temp = temp + procdir;
                                temp = temp + processname;
                                temp = temp + "/status";
                                if ((fp=fopen(temp.c_str(), "r"))!=NULL) {
                                 fscanf(fp, "%s %s", cmdtmp, cmdtmp1);
                                 raus=0;
                                 while ((fgets(zeile, 200, fp) != NULL)&&(raus==0) ) {
                                  if (strstr(zeile, "TracerPid:")) {
                                   fscanf(fp, "%s %s", userid1, userid);
                                    raus=1;
                                   }
                                  }
                                  fclose(fp);
                                 }
				

                                cmdlinevalue = cmdtmp1;
                                wherevalue.erase();
                                wherevalue=readfromproc(processname, "where");
                                lockvalue.erase();
                                lockvalue=readfromproc(processname, "lock");
                                nmigsvalue.erase();
                                nmigsvalue=readfromproc(processname, "nmigs");
                                cannotvalue.erase();
                                cannotvalue=readfromproc(processname, "cantmove");

				temp.erase();
                                temp = temp + procdir;
				temp = temp + processname;
				temp = temp + "/stat";
				if ((fp=fopen(temp.c_str(), "r"))!=NULL) {
				 fscanf(fp, "%s", stat);
				 fscanf(fp, "%s", stat);
				 fscanf(fp, "%s", stat);
				 fclose(fp);
				}
											    
				// priority
				proc_nice = atoi(processname.c_str());
				current_procprio = getpriority(PRIO_PROCESS, proc_nice);
				processnicevalue = int2string(current_procprio);

				if (cannotvalue.length()==0) {
					cannotvalue="M";
				}


				if (cmdlinevalue.length()>0) {
					// write process history
					now.erase();
					now = now + currentdate();
					processlogfile_txt.erase();
					processlogfile_txt = processlogfile_txt + logdirectory;
					processlogfile_txt = processlogfile_txt + "/phist/";
					processlogfile_txt = processlogfile_txt + int2string(tsecs);
					processlogfile_txt = processlogfile_txt + "tsecs.dat";
					std::ofstream processlogfile(processlogfile_txt.c_str(), ios::app);

					if (processlogfile) {
						// T -> timestamp
						processlogfile << now;
						// P -> PID of the process
						processlogfile << " ";
						processlogfile << processname;
						// W -> on which node the process is running
						processlogfile << " ";
						processlogfile << wherevalue;
						// L -> if the process is locked
						processlogfile << " ";
						processlogfile << lockvalue;
						// M -> how often the process migrates
						processlogfile << " ";
						processlogfile << nmigsvalue;
						// S -> status
						processlogfile << " ";
						processlogfile << stat;
						// O -> cannot move the process
						cannotvalue=removespaces(cannotvalue);
						processlogfile << " ";
						processlogfile << cannotvalue;
						// N -> nice (process priority)
						processlogfile << " ";
						processlogfile << processnicevalue;
						// U -> userid
						processlogfile << " ";
						processlogfile << userid;

						// C -> commandline
						cmdlinevalue=onlyfirstpart(cmdlinevalue);
						processlogfile << " ";
						processlogfile << cmdlinevalue;
						processlogfile << "\n";
						processlogfile.close();
						} else {
						cout << "could not write to " << processlogfile_txt << endl;
					}
				}
			}
		} //while
		closedir(dir);
	} //if
}





void openmosixcollector::checkpoint() {

	string nodelogfile_txt;
	string clusterlogfile_txt;
	string now;
	string now1;

	list<string>::iterator p = nodelist.begin();
	while (p != nodelist.end()) {
		string nodeid=(string)*p;

		// write checkpoint to nodefiles
		nodelogfile_txt.erase();
		nodelogfile_txt = nodelogfile_txt + logdirectory;
		nodelogfile_txt = nodelogfile_txt + "/";
		nodelogfile_txt = nodelogfile_txt + nodeid;
		now.erase();
		now = now + currentdate();
		std::ofstream nodelogfile(nodelogfile_txt.c_str(), ios::app);
		if (nodelogfile) {
			// T -> timestamp
			nodelogfile << now;
			// L -> load
			nodelogfile << "-999";
			// S -> speed
			nodelogfile << " ";
			nodelogfile << "-999";
			// M -> available memory
			nodelogfile << " ";
			nodelogfile << "-999";
			// U -> used memory
			nodelogfile << " ";
			nodelogfile << "-999";
			// C -> cpus
			nodelogfile << " ";
			nodelogfile << "-999";
			// E -> end
			nodelogfile << "\n";
			nodelogfile.close();
			} else {
			cout << "could not write to " << nodelogfile_txt << endl;
		}

		p++;
	}

	// write checkpoint to clusterfile
	clusterlogfile_txt.erase();
	clusterlogfile_txt = clusterlogfile_txt + logdirectory;	
	clusterlogfile_txt = clusterlogfile_txt + "/cluster";
	now1.erase();
	now1 = now1 + currentdate();
	std::ofstream clusterlogfile(clusterlogfile_txt.c_str(), ios::app);
	if (clusterlogfile) {
		// T -> timestamp
		clusterlogfile << now1;
		// L -> load
		clusterlogfile << " ";
		clusterlogfile << "-999";
		// B -> balancing
		clusterlogfile << " ";
		clusterlogfile << "-999";
		// M -> available memory
		clusterlogfile << " ";
		clusterlogfile << "-999";
		// U -> used memory
		clusterlogfile << " ";
		clusterlogfile << "-999";
		// C -> cpus
		clusterlogfile << " ";
		clusterlogfile << "-999";
		// E -> end
		clusterlogfile << "\n";
		clusterlogfile.close();
		} else {
		cout << "could not write to " << clusterlogfile_txt << endl;
	}
}



void openmosixcollector::storelogfiles() {

	string copycommand;
	string now;
	int error;

	now.erase();
	now = now + currentdate();
	copycommand.erase();
	copycommand = copycommand + "/bin/mv ";
	copycommand = copycommand + logdirectory;
	copycommand = copycommand + "/ ";
	copycommand = copycommand + logdirectory;
	copycommand = copycommand + "_";
	copycommand = copycommand + now;
	if((error=system(copycommand.c_str())) > 0) {
		cout << "Could not store the logfiles"  << endl;
		} else {
		cout << "Successfully stored the logfiles" << endl;
	}
}



int openmosixcollector::incrementcounter() {

	string tmpstr;
	string cread;
	int countit=0;
	char zeile[21];
	tmpstr=tmpstr + logdirectory + "/" + syncfile;
	std::ifstream readval(tmpstr.c_str());
	if (readval) {
		readval.getline(zeile, 20);
		cread.erase();
		cread=cread+ zeile;
		readval.close();
		countit=string2int(cread);
		if(countit<0) {
			countit=0;
		}
	}
	countit++;
	std::ofstream writeval(tmpstr.c_str());
	if (writeval) {
		writeval << int2string(countit);
		writeval.close();
		return countit;
		} else {
		cout << "could not write to " << tmpstr << endl;
		return 0;
	}
}


