/***************************************************************************
                          openmosixanalyzer.cpp  -  description
                             -------------------
    begin                : Mon Jul 29 17:10:18 CEST 2002
    copyright            : (C) 2002 by Matt Rechenburg
    email                : mosixview@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qaccel.h>
#include "openmosixanalyzer.h"
#include "filesave.xpm"
#include "fileopen.xpm"
#include "fileprint.xpm"
#include "helpicon.xpm"
#include "white.xpm"
#include "whatis.xpm"
#include "load.xpm"
#include "memory.xpm"
#include "find.xpm"
#include "proc_g.xpm"



OpenMosixAnalyzerApp::OpenMosixAnalyzerApp()
{
  setCaption(tr("OpenMosixAnalyzer " VERSION));

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initActions();
  initMenuBar(); initStatusBar();

}

OpenMosixAnalyzerApp::~OpenMosixAnalyzerApp() { }

// helping functions

  int file_exist(string filename) { std::ifstream
	  readfilename(filename.c_str()); if (readfilename) {
		  readfilename.close(); return 1; } else { return 0; } }

string int2string(const int i) { char buf[12]; sprintf(buf,"%d",i);
	return(string(buf)); }







/** initializes all QActions of the application */
void OpenMosixAnalyzerApp::initActions(){

	QPixmap openIcon, saveIcon, whatsthat, lo, help, white_pix, mem_pix,
	info, procicon; openIcon = QPixmap(fileopen); saveIcon =
		QPixmap(filesave); help = QPixmap(helpicon); white_pix=
		QPixmap(white_xpm); whatsthat = QPixmap(whatis); lo =
		QPixmap(load); mem_pix = QPixmap(memory); info =
		QPixmap(find_xpm); procicon = QPixmap(proc_g);

	QFont bfont( "helvetica", 12, QFont::Bold );
        bfont.setPixelSize(14);

	this->resize(660,400);
	this->setMinimumSize(600,380);

	helpAboutApp = new QAction(tr("About"), tr("&About..."), 0, this);
	helpAboutApp->setStatusTip(tr("About the application"));
	helpAboutApp->setWhatsThis(tr("About\n\nAbout the application"));
	connect(helpAboutApp, SIGNAL(activated()), this, SLOT(slotHelpAbout()));

	fileQuit = new QAction(tr("Exit"), tr("E&xit"), QAccel::stringToKey(tr("Ctrl+Q")), this);
	fileQuit->setStatusTip(tr("Quits the application"));
	fileQuit->setWhatsThis(tr("Exit\n\nQuits the application"));
	connect(fileQuit, SIGNAL(activated()), qApp, SLOT(quit()));

	// toplevel background
	QLabel_top= new QLabel(this,"NoName");
	QLabel_top->setGeometry(0,25,4350,155);
	QLabel_top->setMinimumSize(0,0);
	QWhatsThis::add(QLabel_top,"This widget displays informations about the openMosix-cluster during the log time.");

	// refresh checkbox
	QCheckBox_autorefresh= new QCheckBox(QLabel_top,"NoName");
	QCheckBox_autorefresh->setGeometry(180,5,90,20);
	QCheckBox_autorefresh->setMinimumSize(0,0);
	QCheckBox_autorefresh->setText("auto-refresh");
	QCheckBox_autorefresh->setChecked(true);
	QWhatsThis::add(QCheckBox_autorefresh,"Enable this checkbox to\nauto-refresh the cluster-view.");

	refreshtimeoutbox= new QSpinBox(QLabel_top, "refresh");
	refreshtimeoutbox->setGeometry(280,5,35,20);
	refreshtimeoutbox->setMinimumSize(0,0);
	refreshtimeoutbox->setValue(10);
	refreshtimeoutbox->setLineStep (10);
	refreshtimeoutbox->setMinValue(10);
	refreshtimeoutbox->setMaxValue(90);
	QWhatsThis::add(refreshtimeoutbox ,"set the timeout value in seconds for the main refresh");

	label_refresh2= new QLabel(QLabel_top,"refresh2");
	label_refresh2->setGeometry(315,5,20,20);
	label_refresh2->setMinimumSize(0,0);
	label_refresh2->setText("s");
	label_refresh2->setMargin(1);
	QWhatsThis::add(label_refresh2 ,"set the timeout value in seconds for the main refresh");

	
	// displays what is displayed ;)
	QLabel_display= new QLabel(QLabel_top,"NoName");
	QLabel_display->setGeometry(340,5,200,20);
	QLabel_display->setFont(bfont);
	QLabel_display->setText("LOAD - OVERVIEW");
	QLabel_display->setMinimumSize(0,0);
	QWhatsThis::add(QLabel_display,"Displays if currently the load- or the memory view is displayed.");

	// clusterbar
	QLabel_clusterbar= new QLabel(QLabel_top,"NoName");
	QLabel_clusterbar->setGeometry(0,55,30,155);
	QLabel_clusterbar->setMinimumSize(0,0);
	QWhatsThis::add(QLabel_clusterbar,"Click the button to get more infos about the cluster.");

	// the toolbar
	fileOpen = new QToolButton(QLabel_top, "open logfile");
	fileOpen->setGeometry(0,0,25,25);
	fileOpen->setPixmap(openIcon);
	connect(fileOpen, SIGNAL(clicked()), this, SLOT(slotFileOpen()));
	QWhatsThis::add(fileOpen,"Open stored logfiles.");

	showLoad = new QToolButton(QLabel_top, "shows the loadview");
	showLoad->setGeometry(25,0,25,25);
	showLoad->setPixmap(lo);
	showLoad->setToggleButton(true);
	showLoad->setOn(true);
	connect(showLoad, SIGNAL(clicked()), this, SLOT(showLoadView()));
	QWhatsThis::add(showLoad,"Displays the memory overview of your openMosix cluster.");

	showMem = new QToolButton(QLabel_top, "shows the memoryview");
	showMem->setGeometry(50,0,25,25);
	showMem->setPixmap(mem_pix);
	showMem->setToggleButton(false);
	showMem->setOn(false);
	connect(showMem, SIGNAL(clicked()), this, SLOT(showMemView()));
	QWhatsThis::add(showMem,"Displays the memory overview of your openMosix cluster.");

	openprochistory = new QToolButton(QLabel_top, "open the process-history");
	openprochistory->setGeometry(75,0,25,25);
	openprochistory->setPixmap(procicon);
	connect(openprochistory, SIGNAL(clicked()), this, SLOT(openhistory()));
	QWhatsThis::add(openprochistory,"Open openMosixhistory which display the processes which were running during the collecting phase.");

	helpme = new QToolButton(QLabel_top, "help");
	helpme->setGeometry(100,0,25,25);
	helpme->setPixmap(help);
	connect(helpme, SIGNAL(clicked()), this, SLOT(slotHelp()));
	QWhatsThis::add(helpme,"Open the help of the openMosixAnalyzer.");

	whatisthis = new QToolButton(QLabel_top, "whatisthis");
	whatisthis->setGeometry(125,0,25,25);
	whatisthis->setPixmap(whatsthat);
	connect(whatisthis, SIGNAL(clicked()), this, SLOT(slot_whatisthis()));
	QWhatsThis::add(whatisthis,"Switch to what-is-this mode which is a usefull helpfunction.");

	
	// the memory view
	QGroupBox_2= new QGroupBox(this,"NoName");
	QGroupBox_2->setGeometry(0,180,4350,10);
	QGroupBox_2->setMinimumSize(0,0);
	QGroupBox_2->setTitle("");
	QWhatsThis::add(QGroupBox_2,"This is the memory overview of your cluster.");

	// the load view
	QGroupBox_1= new QGroupBox(this,"NoName");
	QGroupBox_1->setGeometry(0,180,4350,10);
	QGroupBox_1->setMinimumSize(0,0);
	QGroupBox_1->setTitle("");
	QWhatsThis::add(QGroupBox_1,"This is the load overview of your cluster.");

	// leftbar
	QLabel_left= new QLabel(this,"NoName");
	QLabel_left->setGeometry(0,180,30,10);
	QLabel_left->setMinimumSize(0,0);
	QWhatsThis::add(QGroupBox_2,"Click on the button to get more infos about your nodes at the time the logfiles were created.");

	QScrollBar_1= new QScrollBar(0, 90, 1, 10, 0, QScrollBar::Vertical, this,"vertical");
	QScrollBar_1->setGeometry(640,180,20,180);
	QScrollBar_1->setMinimumSize(0,0);
	QScrollBar_1->setRange(0,0);
	QObject::connect(QScrollBar_1, SIGNAL(sliderMoved ( int )), this, SLOT(scroll_view( int  )) );
	QObject::connect(QScrollBar_1, SIGNAL(valueChanged ( int )), this, SLOT(scroll_view( int  )) );

	QWhatsThis::add(QScrollBar_1,"Scrolls the node view up or down.");

	QScrollBar_2= new QScrollBar(0, 50, 1, 10, 0, QScrollBar::Horizontal, this,"horizontal");
	QScrollBar_2->setGeometry(20,360,620,20);
	QScrollBar_2->setRange(0,3800);
	QObject::connect(QScrollBar_2, SIGNAL(sliderMoved ( int )), this, SLOT(right_left( int  )) );
	QObject::connect(QScrollBar_2, SIGNAL(valueChanged ( int )), this, SLOT(right_left( int  )) );

	QWhatsThis::add(QScrollBar_2,"Scrolls the node view to the left or right.");

	// the tux
	QLabel_tux= new QLabel(this,"power");
	QLabel_tux->setGeometry(640,360,20,20);
	QLabel_tux->setMinimumSize(0,0);
	QLabel_tux->setPixmap(help);
	QWhatsThis::add(QLabel_tux,"I am the power of your cluster :)");

	proctimer = new QTimer( this );
	proctimer->start(10000);
	QObject::connect( proctimer, SIGNAL(timeout()), this, SLOT(refreshit()) );
	QObject::connect( refreshtimeoutbox, SIGNAL(valueChanged( int )), this, SLOT(adjusttimer( int )) );

}




void OpenMosixAnalyzerApp::initMenuBar()
{
  ///////////////////////////////////////////////////////////////////
  // MENUBAR

  ///////////////////////////////////////////////////////////////////
  // menuBar entry fileMenu
  fileMenu=new QPopupMenu();
  fileQuit->addTo(fileMenu);


  ///////////////////////////////////////////////////////////////////
  // menuBar entry helpMenu
	helpMenu=new QPopupMenu();
	helpMenu->insertItem("Help", this, SLOT(slotHelp()), 0, 100040);
	helpMenu->insertSeparator();
	helpAboutApp->addTo(helpMenu);




  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  menuBar()->insertItem(tr("&File"), fileMenu);
  menuBar()->insertSeparator();
  menuBar()->insertItem(tr("&Help"), helpMenu);

}



void OpenMosixAnalyzerApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //STATUSBAR
  statusBar()->message(tr("Ready."), 2000);
}


/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////



void OpenMosixAnalyzerApp::slotFileOpen() {
	statusBar()->message(tr("Opening logfile..."));
	QString fileName = QFileDialog::getOpenFileName(0,0,this);
	if (!fileName.isEmpty())  {
		if(fileName.contains("cluster", 1)) {
			fileName.replace( QRegExp("cluster"), "" );
			doc->load(fileName);
			} else {
		  QMessageBox::about(this,tr("This is not a openmosixcollector logfile"),tr("Please load a main openmosixcollector logfile!\n e.g. /tmp/openmosixcollector_[date]/cluster") );
		}
		QString message=tr("Logfile loaded : ")+fileName;
		statusBar()->message(message, 2000);
		} else {
		statusBar()->message(tr("Opening aborted"), 2000);
	}
}





void OpenMosixAnalyzerApp::slotHelpAbout()
{
  QMessageBox::about(this,tr("About..."),
                      tr("openMosixAnalyzer\nVersion " VERSION "\n(c) 2002 by Matt Rechenburg") );
}





void OpenMosixAnalyzerApp::scroll_view( int value ) {
	int current_h=0;
	current_h=QGroupBox_1->height();
	QGroupBox_1->setGeometry(-QScrollBar_2->value(), -value+180, 4350, current_h);
	QGroupBox_2->setGeometry(-QScrollBar_2->value(), -value+180, 4350, current_h);
	QLabel_left->setGeometry(0, -value+182,30,current_h-4);
}

void OpenMosixAnalyzerApp::right_left( int value ) {
	int current_h=0;
	current_h=QGroupBox_1->height();
	QGroupBox_1->setGeometry (-value, -QScrollBar_1->value()+180, 4350, current_h );
	QGroupBox_2->setGeometry (-value, -QScrollBar_1->value()+180, 4350, current_h );
	allload->setGeometry (-value+30, 35, 4320, 120 );
	allmem->setGeometry (-value+30, 35, 4320, 120);
}


void OpenMosixAnalyzerApp::showMemView() {
	QGroupBox_1->lower();
	QGroupBox_2->raise();
	QScrollBar_1->raise();
	QScrollBar_2->raise();
	QLabel_left->raise();
	QLabel_top->raise();
	statusBar()->raise();
	menuBar()->raise();
	allmem->raise();
	allload->lower();
	QLabel_clusterbar->raise();

	// toggle the buttons
	showMem->setToggleButton(true);
	showMem->setOn(true);
  	showLoad->setOn(false);
  	showLoad->setToggleButton(false);

	QLabel_display->setText("MEMORY - OVERVIEW");
	QLabel_tux->raise();
	statusBar()->message("displaying the memory overview now");
}


void OpenMosixAnalyzerApp::showLoadView() {
	QGroupBox_2->lower();
	QGroupBox_1->raise();
	QScrollBar_1->raise();
	QScrollBar_2->raise();
	QLabel_left->raise();
	QLabel_top->raise();
	statusBar()->raise();
	menuBar()->raise();
	allmem->lower();
	allload->raise();
	QLabel_clusterbar->raise();

	// toggle the buttons
	showMem->setOn(false);
	showMem->setToggleButton(false);
  	showLoad->setToggleButton(true);
  	showLoad->setOn(true);

	QLabel_display->setText("LOAD - OVERVIEW");
	QLabel_tux->raise();
	statusBar()->message("displaying the load overview now");
}


// enter what is this mode
void OpenMosixAnalyzerApp::slot_whatisthis()
{
QWhatsThis::enterWhatsThisMode();
}


// the help-method
void OpenMosixAnalyzerApp::slotHelp() {

  QPixmap white_pix, help, lo, mem_pix, procicon;
	white_pix= QPixmap(white_xpm);
	help = QPixmap(helpicon);
	lo = QPixmap(load);
	mem_pix = QPixmap(memory);
	procicon = QPixmap(proc_g);

        QFont hfont("helvetica");
        hfont.setPixelSize(12);

	QTabDialog *tabs = new QTabDialog();
	tabs->setGeometry(200,50,300,200);
	tabs->resize(530, 300);
        tabs->setFont(hfont);
	
	
	QLabel *a = new QLabel(tabs, 0, 0);
	a->setGeometry(5,5,20,20);
	a->resize(200, 200);
	a->setMargin(3);
	a->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	a->setBackgroundPixmap(QPixmap(white_pix));
	a->setText("Help on openMosixanalyzer\n" \
	"With the openMosixanalyzer you will know what your cluster is/was doing\n" \
	"at every time. There is a Load- and Memory-overview and a process-history\n" \
	"which let you know what was going on\n" \
	"The openMosixanalyzer displays 12 hours of cluster-informations gatherd by the\n" \
	"openmosixcollector which automatically saves the logfiles every 12 hours for a\n" \
	"continously history. Several overall- and mean-values are calculated from the logfiles\n" \
	"and you can print-out reports for each node or the whole cluster.\n" \
	"You will find help on each part of the openMosixanalyzer on the next pages.\n\n" \
	"M. Rechenburg / mosixview@t-online.de");

	QLabel *b = new QLabel(tabs, 0, 0);
	b->setGeometry(5,5,20,20);
	b->resize(200, 200);
	b->setMargin(3);
	b->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	b->setBackgroundPixmap(QPixmap(white_pix));
	b->setText("the Load-overview\n" \
	"By default openMosixanalyzer will display the Load-overview.\n" \
	"The first 'line' shows the mean load of you cluster for a range of 12 hours.\n" \
	"There is one 'line' for each cluster-node created below this cluster-overview.\n" \
	"You can scroll this time-lines which shows the exact time each hour in a scala.\n" \
	"Use the 'find-button' to find out more about the average load and balacing.\n" \
	"The displayed load-views are also printable for your cluster-documentation.\n" \
	"You can open 'older-logfiles' which were saved by the openMosixcollector\n" \
	"every 12 hours by the file-open button. The 'older-logfiles' are in :\n" \
	"/tmp/openmosixcollector[date] and you always have to open the main logfile :\n" \
	"/tmp/openmosixcollector[date]/cluster only.");

	QLabel *c = new QLabel(tabs, 0, 0);
	c->setGeometry(5,5,20,20);
	c->resize(200, 200);
	c->setMargin(3);
	c->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	c->setBackgroundPixmap(QPixmap(white_pix));
	c->setText("the Memory-overview\n" \
	"Click on the memory-toolbar button to open the Memory-overview.\n" \
	"The memory usage for each node and the average memory usage for the\n" \
	"whole cluster is displayed in the main window.\n" \
	"Like the Load-overview you can print-out this node- and cluster views too.\n" \
	"The Memory- and Load-views are 'toggleable' with the load- and memory\n" \
	"toolbar-buttons.\n" \
	"");

 	QLabel *d = new QLabel(tabs, 0, 0);
	d->setGeometry(5,5,20,20);
	d->resize(200, 200);
	d->setMargin(3);
	d->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	d->setBackgroundPixmap(QPixmap(white_pix));
	d->setText("the Process-history\n" \
	"The whole process-history from the node the openMosixcollector is running on\n" \
	"is logged. Use the openMosixHistory to 'walk' through this logfiles.\n" \
	"Similar to openMosixProcs all processes are displayed with their important\n" \
	"informations (commandline, where the process ran, which priority, userid...).\n" \
	"You can 'move on' in this process-history with a 'time-slider' on the top.\n" \
	"The exact time when the process-information were gathered is displayed in\n" \
	"a time-box and lets you know when, what was running where.\n" \
	"");

	tabs->addTab(a, help,  "general");
	tabs->addTab(b, lo,  "load-overview");
	tabs->addTab(c, mem_pix,  "memory-overview");
	tabs->addTab(d, procicon,  "process-history");
	tabs->show();
	statusBar()->message("displaying the help-window.");

}


// displays information about the cluster and logfile
void OpenMosixAnalyzerApp::showallinfo() {
	const  char *nodefilename;
	const QObject *button = sender();
	nodefilename=button->name();

        QFont cfont("helvetica");
        cfont.setPixelSize(12);
	
	clusterinfo *getclusterinfo = new clusterinfo(0,nodefilename);
	getclusterinfo->setGeometry(100,100,485,165);
	getclusterinfo->resize(485, 165);
	getclusterinfo->setFixedSize(485, 165);
        getclusterinfo->setFont(cfont);
	getclusterinfo->show();
	statusBar()->message("displaying cluster informations");

}


// displays information about one node in the cluster
void OpenMosixAnalyzerApp::showsingleinfo() {

	const  char *nodefilename;
	const QObject *button = sender();
	nodefilename=button->name();

        QFont sfont("helvetica");
        sfont.setPixelSize(12);
	
	nodeinfo *getnodeinfo = new nodeinfo(0,nodefilename);
	getnodeinfo->setGeometry(100,100,365,165);
	getnodeinfo->resize(365, 165);
	getnodeinfo->setFixedSize(365, 165);
	getnodeinfo->setFont(sfont);
	getnodeinfo->show();
	statusBar()->message("displaying node informations");

}



// draws the cluster
void OpenMosixAnalyzerApp::drawcluster(string logdirectory) {

	DIR *logdir;
	struct dirent *dir_info;
	int loggerheight=0;
	int currentheight=0;
	int currentrange=0;
	string currentlogfile;
	int howmany=0;

	QPixmap white_pix, info, printit;
	white_pix= QPixmap(white_xpm);
	info = QPixmap(find_xpm);
	printit = QPixmap(fileprint);

        QFont cfont("helvetica");
        cfont.setPixelSize(8);
	
	// set the logdirectory variable to the right directory
	setlogdirectory(logdirectory);

	// checks if the directory exists
	checklogdirectory(logdirectory);

	// ########### open the all node logfile ###########

	if ((logdir=opendir(logdirectory.c_str()))!=NULL) {
		while ((dir_info = readdir(logdir))!=NULL) {
			if((strchr(dir_info->d_name, '1'))||(strchr(dir_info->d_name, '2'))||(strchr(dir_info->d_name, '3'))||(strchr(dir_info->d_name, '4'))||(strchr(dir_info->d_name, '5'))||(strchr(dir_info->d_name, '6'))||(strchr(dir_info->d_name, '7'))||(strchr(dir_info->d_name, '8'))||(strchr(dir_info->d_name, '9')) ) {

				// fill the nodelist
				nodelist.push_front(dir_info->d_name);

				// fill directory variable
				currentlogfile.erase();
				currentlogfile = currentlogfile + logdirectory;
				currentlogfile = currentlogfile + dir_info->d_name;

				// loadview
				loadlog[howmany] = new loadanalyzer(QGroupBox_1, currentlogfile.c_str());
				loadlog[howmany]->setGeometry(30,loggerheight,4320,100);
				loadlog[howmany]->setMinimumSize(0,0);
				loadlog[howmany]->setBackgroundMode( QWidget::PaletteBase );
				loadlog[howmany]->setFont(cfont);
				QWhatsThis::add(loadlog[howmany],"This widget displays the load-view of one openMosix-node.");
	
				// memview
				memlog[howmany] = new memanalyzer(QGroupBox_2, currentlogfile.c_str());
				memlog[howmany]->setGeometry(30,loggerheight,4320,100);
				memlog[howmany]->setMinimumSize(0,0);
				memlog[howmany]->setBackgroundMode( QWidget::PaletteBase );
				memlog[howmany]->setFont(cfont);
				QWhatsThis::add(memlog[howmany],"This widget displays the load-view of one openMosix-node.");

				// the node label
				QLabel_cluster_node= new QLabel(QLabel_left, dir_info->d_name);
				QLabel_cluster_node->setGeometry(0,loggerheight,30,40);
				QLabel_cluster_node->setMinimumSize(0,0);
				QLabel_cluster_node->setBackgroundPixmap(QPixmap(white_pix));
				QLabel_cluster_node->setFont(cfont);
				QLabel_cluster_node->setText(dir_info->d_name);
				QLabel_cluster_node->setMargin(0);
				QLabel_cluster_node->setAlignment( AlignVCenter | AlignCenter );
				QLabel_cluster_node->setFrameStyle( QFrame::Panel | QFrame::Sunken );
				QWhatsThis::add(QLabel_cluster_node ,"This box display the values from your openMosix-cluster.\n");

				// open nodeinfo - widget
				shownodeinfo = new QToolButton(QLabel_left, currentlogfile.c_str());
				shownodeinfo->setGeometry(0,loggerheight+40,30,30);
				shownodeinfo->setPixmap(info);
				connect(shownodeinfo, SIGNAL(clicked()), this, SLOT(showsingleinfo()));
				QWhatsThis::add(shownodeinfo,"Click this button to get more statistical informations about the nodes during the log time.");

				// print nodes informations
				printnode = new QToolButton(QLabel_left, currentlogfile.c_str());
				printnode->setGeometry(0,loggerheight+70,30,30);
				printnode->setPixmap(printit);
				connect(printnode, SIGNAL(clicked()), this, SLOT(print_nodes()));
				QWhatsThis::add(printnode,"Click this button to print this informations.");



				// adjust all widgets
				loggerheight = loggerheight + 100;
				currentheight = currentheight +  100;
				QGroupBox_2->setGeometry(0,180,4350,currentheight);
				QGroupBox_1->setGeometry(0,180,4350,currentheight);
				QLabel_left->setGeometry(0,182,30,currentheight-4);

				currentrange=QScrollBar_1->maxValue ();
				currentrange=currentrange+100;
				QScrollBar_1->setRange ( 0, currentrange );

				howmany++;
			}
		}
		closedir(logdir);
		// adjust the range again
		if (howmany) {
			currentrange=QScrollBar_1->maxValue ();
			currentrange=currentrange-100;
			QScrollBar_1->setRange ( 0, currentrange );
		}
	}


	// ########### open the cluster logfile ###########

	// fill directory variable
	currentlogfile.erase();
	currentlogfile = currentlogfile + logdirectory;
	currentlogfile = currentlogfile + "cluster";

	allmem = new clustermem(QLabel_top, currentlogfile.c_str());
	allmem->setGeometry(30,35,4320,120);
	allmem->setMinimumSize(0,0);
	allmem->setBackgroundMode( QWidget::PaletteBase );
	allmem->setFont(cfont);
	QWhatsThis::add(allmem,"This widget displays the memory-view of your openMosix-cluster.");

	allload = new clusterload(QLabel_top, currentlogfile.c_str());
	allload->setGeometry(30,35,4320,120);
	allload->setMinimumSize(0,0);
	allload->setBackgroundMode( QWidget::PaletteBase );
	allload->setFont(cfont);
	QWhatsThis::add(allload,"This widget displays the load-view of your openMosix-cluster.");


	// draw additional cluster widgets
	QLabel_cluster_all= new QLabel(QLabel_clusterbar,"all");
	QLabel_cluster_all->setGeometry(0,0,30,40);
	QLabel_cluster_all->setMinimumSize(0,0);
	QLabel_cluster_all->setBackgroundPixmap(QPixmap(white_pix));
	QLabel_cluster_all->setFont(cfont);
	QLabel_cluster_all->setText("all");
	QLabel_cluster_all->setMargin(0);
	QLabel_cluster_all->setAlignment( AlignVCenter | AlignCenter );
	QLabel_cluster_all->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	QWhatsThis::add(QLabel_cluster_all ,"This box display the values from your openMosix-cluster.\n");

	// open clusterinfo widget
	showclusterinfo = new QToolButton(QLabel_clusterbar, currentlogfile.c_str());
	showclusterinfo->setGeometry(0,40,30,30);
	showclusterinfo->setPixmap(info);
	connect(showclusterinfo, SIGNAL(clicked()), this, SLOT(showallinfo()));
	QWhatsThis::add(shownodeinfo,"Click this button to get more statistical informations about the cluster during the log time.");

	// print cluster informations
	printcluster = new QToolButton(QLabel_clusterbar, currentlogfile.c_str());
	printcluster->setGeometry(0,70,30,30);
	printcluster->setPixmap(printit);
	connect(printcluster, SIGNAL(clicked()), this, SLOT(print_cluster()));
	QWhatsThis::add(printcluster,"Click this button to print this informations.");

	QLabel_left->raise();
	QLabel_top->raise();
	QLabel_clusterbar->raise();
	menuBar()->raise();



}


// autorefresh the view
void OpenMosixAnalyzerApp::refreshit() {

	int howmany=0;
	if(QCheckBox_autorefresh->isChecked()) {
		allmem->repaint();
		allload->repaint();
		list<string>::iterator p = nodelist.begin();
		while (p != nodelist.end()) {
 		loadlog[howmany]->repaint();
 		memlog[howmany]->repaint();
		howmany++;
		p++;
		}
	}
}




// print cluster logs
void OpenMosixAnalyzerApp::print_cluster() {
	const  char *afilename;
	const QObject *button = sender();
	afilename=button->name();
	if(showLoad->isOn()) {
		print_clusterload(afilename);
		} else {
		print_clustermem(afilename);
	}
}

// print node logs
void OpenMosixAnalyzerApp::print_nodes() {
	const  char *afilename;
	const QObject *button = sender();
	afilename=button->name();
	if(showLoad->isOn()) {
		print_loadanalyzer(afilename);
		} else {
		print_memanalyzer(afilename);
	}
}


// ################# printing functions ###########################

// print clusterload
void OpenMosixAnalyzerApp::print_clusterload(const  char *filename) {

	int oload, obalance, oallmem, ousedmem, cpus;
	FILE *readfile;
	char *when;
	when = new char[50];
	int j=50;
	int pages=0;
	int lastload=0;

	QPen pen1(black, 0);
	QPen pen2(black, 2);
	QPrinter printer;
	printer.setOrientation(QPrinter::Landscape);
	if (printer.setup(this)) {

		// main painter
		QPainter painter;
		painter.begin(&printer);
		painter.setPen(pen1);
		painter.drawRect(50, 50, 720, 400);

		// title
		painter.setFont(QFont( "helvetica", 12, QFont::Bold ));
		painter.drawText( 50, 20, "LOAD-OVERVIEW for the whole cluster" );
		painter.setFont(QFont( "helvetica", 10));
		painter.drawText( 50, 40, "logfile :");
		painter.drawText( 100, 40, filename);


		// scala
		painter.setFont(QFont("Helvetica", 10));
		painter.drawText( 55, 65, "100%" );
		painter.drawText( 55, 240, "50%" );
		painter.drawText( 55, 435, "0%" );
		painter.drawText( 55, 470, "minutes ->" );

		// minute scala
		for(int i=50;i<=770; i=i+12) {
			painter.moveTo(i, 440);
			painter.lineTo(i, 450);
		}
		// 50% percent line
		painter.moveTo(50, 250);
		painter.lineTo(770, 250);

		// open the logfile and draw the line

		if((readfile=fopen(filename, "r")) == NULL) {
			cout << "could not open openMosix data information file" << filename << endl;
			} else {
			painter.moveTo(50, 450);
			while  ((!feof(readfile))&&(j<4320)) {
				fscanf(readfile, "%s %d %d %d %d %d", when, &oload, &obalance, &oallmem, &ousedmem, &cpus);
				if(oload==-999) {
         		// there is a checkpoint
					painter.moveTo(j, 50);
					painter.lineTo(j, 450);
               oload=lastload;
					painter.moveTo(j, 450-lastload);
	         	} else {
					oload=(oload*400)/100;
				}

				// here we draw the date the page starts with
				if(j==50) {
					painter.setFont(QFont( "helvetica", 10, QFont::Bold ));
					painter.drawText( 300, 20, when);
				}

				j=j+2;

				// we are on a new page !!
				if(j>=770) {
					// reset the counter
					j=50;
					pages++;
					printer.newPage();
					// draw template for new page and move painter

					painter.drawRect(50, 50, 720, 400);

					// title
					painter.setFont(QFont( "helvetica", 12, QFont::Bold ));
					painter.drawText( 50, 20, "LOAD-OVERVIEW for the whole cluster" );
					painter.setFont(QFont( "helvetica", 10));
					painter.drawText( 50, 40, "logfile :");
					painter.drawText( 100, 40, filename);

					// scala
					painter.setFont(QFont("Helvetica", 10));
					painter.drawText( 55, 65, "100%" );
					painter.drawText( 55, 240, "50%" );
					painter.drawText( 55, 435, "0%" );
					painter.drawText( 55, 470, "minutes ->" );

					// minute scala
					for(int i=50;i<=770; i=i+12) {
						painter.moveTo(i, 440);
						painter.lineTo(i, 450);
					}
					// 50% percent line
					painter.moveTo(50, 250);
					painter.lineTo(770, 250);

         		// move to the start point again
					painter.moveTo(50, 450);
					} else {
					// here we paint
					painter.lineTo(j, 450-oload);
					lastload=oload;
				}
			}
			fclose(readfile);
		}

		painter.end();
		} else {
		cout << "canceld " << endl;
	}
}




// print clustermem
void OpenMosixAnalyzerApp::print_clustermem(const  char *filename) {
	int oload, obalance, oallmem, ousedmem, cpus;
	FILE *readfile;
	char *when;
	when = new char[50];
	int j=50;
	int pages=0;
	int lastmem=0;

	QPen pen1(black, 0);
	QPen pen2(black, 2);
	QPrinter printer;
	printer.setOrientation(QPrinter::Landscape);
	if (printer.setup(this)) {

		// main painter
		QPainter painter;
		painter.begin(&printer);
		painter.setPen(pen1);
		painter.drawRect(50, 50, 720, 400);

		// title
		painter.setFont(QFont( "helvetica", 12, QFont::Bold ));
		painter.drawText( 50, 20, "MEMORY-OVERVIEW for the whole cluster" );
		painter.setFont(QFont( "helvetica", 10));
		painter.drawText( 50, 40, "logfile :");
		painter.drawText( 100, 40, filename);


		// scala
		painter.setFont(QFont("Helvetica", 10));
		painter.drawText( 55, 65, "100%" );
		painter.drawText( 55, 240, "50%" );
		painter.drawText( 55, 435, "0%" );
		painter.drawText( 55, 470, "minutes ->" );

		// minute scala
		for(int i=50;i<=770; i=i+12) {
			painter.moveTo(i, 440);
			painter.lineTo(i, 450);
		}
		// 50% percent line
		painter.moveTo(50, 250);
		painter.lineTo(770, 250);

		// open the logfile and draw the line

		if((readfile=fopen(filename, "r")) == NULL) {
			cout << "could not open openMosix data information file" << filename << endl;
			} else {
			painter.moveTo(50, 450);
			while  ((!feof(readfile))&&(j<4320)) {
				fscanf(readfile, "%s %d %d %d %d %d", when, &oload, &obalance, &oallmem, &ousedmem, &cpus);
				if(ousedmem==-999) {
         		// there is a checkpoint
					painter.moveTo(j, 50);
					painter.lineTo(j, 450);
               ousedmem=lastmem;
					painter.moveTo(j, 450-lastmem);
	         	} else {
					ousedmem=(ousedmem*400)/100;
				}

				// here we draw the date the page starts with
				if(j==50) {
					painter.setFont(QFont( "helvetica", 10, QFont::Bold ));
					painter.drawText( 350, 20, when);
				}

				j=j+2;

				// we are on a new page !!
				if(j==770) {
					// reset the counter
					j=50;
					pages++;
					printer.newPage();
					// draw template for new page and move painter

					painter.drawRect(50, 50, 720, 400);

					// title
					painter.setFont(QFont( "helvetica", 12, QFont::Bold ));
					painter.drawText( 50, 20, "MEMORY-OVERVIEW for the whole cluster" );
					painter.setFont(QFont( "helvetica", 10));
					painter.drawText( 50, 40, "logfile :");
					painter.drawText( 100, 40, filename);

					// scala
					painter.setFont(QFont("Helvetica", 10));
					painter.drawText( 55, 65, "100%" );
					painter.drawText( 55, 240, "50%" );
					painter.drawText( 55, 435, "0%" );
					painter.drawText( 55, 470, "minutes ->" );

					// minute scala
					for(int i=50;i<=770; i=i+12) {
						painter.moveTo(i, 440);
						painter.lineTo(i, 450);
					}
					// 50% percent line
					painter.moveTo(50, 250);
					painter.lineTo(650, 250);

         		// move to the start point again
					painter.moveTo(50, 450);
					} else {
					// here we paint
					painter.lineTo(j, 450-ousedmem);
					lastmem=ousedmem;
				}
			}
			fclose(readfile);
		}

		painter.end();
		} else {
		cout << "canceld " << endl;
	}
}

// print loadanalyzer
void OpenMosixAnalyzerApp::print_loadanalyzer(const  char *filename) {

	int oload, ospeed, otmem, omem, cpus;
	FILE *readfile;
	char *when;
	when = new char[50];
	int j=50;
	int pages=0;
	int lastload=0;

	QPen pen1(black, 0);
	QPen pen2(black, 2);
	QPrinter printer;
	printer.setOrientation(QPrinter::Landscape);
	if (printer.setup(this)) {

		// main painter
		QPainter painter;
		painter.begin(&printer);
		painter.setPen(pen1);
		painter.drawRect(50, 50, 720, 400);

		// title
		painter.setFont(QFont( "helvetica", 12, QFont::Bold ));
		painter.drawText( 50, 20, "LOAD-OVERVIEW for a single node" );
		painter.setFont(QFont( "helvetica", 10));
		painter.drawText( 50, 40, "logfile :");
		painter.drawText( 100, 40, filename);


		// scala
		painter.setFont(QFont("Helvetica", 10));
		painter.drawText( 55, 65, "100%" );
		painter.drawText( 55, 240, "50%" );
		painter.drawText( 55, 435, "0%" );
		painter.drawText( 55, 470, "minutes ->" );

		// minute scala
		for(int i=50;i<=770; i=i+12) {
			painter.moveTo(i, 440);
			painter.lineTo(i, 450);
		}
		// 50% percent line
		painter.moveTo(50, 250);
		painter.lineTo(770, 250);

		// open the logfile and draw the line

		if((readfile=fopen(filename, "r")) == NULL) {
			cout << "could not open openMosix data information file" << filename << endl;
			} else {
			painter.moveTo(50, 450);
			while  ((!feof(readfile))&&(j<4320)) {
			fscanf(readfile, "%s %d %d %d %d %d", when, &oload, &ospeed, &otmem, &omem, &cpus);
				if(oload==-999) {
         		// there is a checkpoint
					painter.moveTo(j, 50);
					painter.lineTo(j, 450);
               oload=lastload;
					painter.moveTo(j, 450-lastload);
	         	} else {
					oload=(oload*400)/100;
				}

				// here we draw the date the page starts with
				if(j==50) {
					painter.setFont(QFont( "helvetica", 10, QFont::Bold ));
					painter.drawText( 300, 20, when);
				}

				j=j+2;

				// we are on a new page !!
				if(j==770) {
					// reset the counter
					j=50;
					pages++;
					printer.newPage();
					// draw template for new page and move painter

					painter.drawRect(50, 50, 720, 400);

					// title
					painter.setFont(QFont( "helvetica", 12, QFont::Bold ));
					painter.drawText( 50, 20, "LOAD-OVERVIEW for a single node" );
					painter.setFont(QFont( "helvetica", 10));
					painter.drawText( 50, 40, "logfile :");
					painter.drawText( 100, 40, filename);

					// scala
					painter.setFont(QFont("Helvetica", 10));
					painter.drawText( 55, 65, "100%" );
					painter.drawText( 55, 240, "50%" );
					painter.drawText( 55, 435, "0%" );
					painter.drawText( 55, 470, "minutes ->" );

					// minute scala
					for(int i=50;i<=770; i=i+12) {
						painter.moveTo(i, 440);
						painter.lineTo(i, 450);
					}
					// 50% percent line
					painter.moveTo(50, 250);
					painter.lineTo(770, 250);

         		// move to the start point again
					painter.moveTo(50, 450);
					} else {
					// here we paint
					painter.lineTo(j, 450-oload);
					lastload=oload;
				}
			}
			fclose(readfile);
		}

		painter.end();
		} else {
		cout << "canceld " << endl;
	}
}

// print memanalyzer
void OpenMosixAnalyzerApp::print_memanalyzer(const  char *filename) {

	int oload, ospeed, otmem, omem, ousedmem, cpus;
	FILE *readfile;
	char *when;
	when = new char[50];
	int j=50;
	int pages=0;
	int lastmem=0;

	QPen pen1(black, 0);
	QPen pen2(black, 2);
	QPrinter printer;
	printer.setOrientation(QPrinter::Landscape);
	if (printer.setup(this)) {

		// main painter
		QPainter painter;
		painter.begin(&printer);
		painter.setPen(pen1);
		painter.drawRect(50, 50, 720, 400);

		// title
		painter.setFont(QFont( "helvetica", 12, QFont::Bold ));
		painter.drawText( 50, 20, "MEMORY-OVERVIEW for a single node" );
		painter.setFont(QFont( "helvetica", 10));
		painter.drawText( 50, 40, "logfile :");
		painter.drawText( 100, 40, filename);


		// scala
		painter.setFont(QFont("Helvetica", 10));
		painter.drawText( 55, 65, "100%" );
		painter.drawText( 55, 240, "50%" );
		painter.drawText( 55, 435, "0%" );
		painter.drawText( 55, 470, "minutes ->" );

		// minute scala
		for(int i=50;i<=770; i=i+12) {
			painter.moveTo(i, 440);
			painter.lineTo(i, 450);
		}
		// 50% percent line
		painter.moveTo(50, 250);
		painter.lineTo(770, 250);

		// open the logfile and draw the line

		if((readfile=fopen(filename, "r")) == NULL) {
			cout << "could not open openMosix data information file" << filename << endl;
			} else {
			painter.moveTo(50, 450);
			while  ((!feof(readfile))&&(j<4320)) {
			fscanf(readfile, "%s %d %d %d %d %d", when, &oload, &ospeed, &otmem, &omem, &cpus);
				if(ousedmem==-999) {
         		// there is a checkpoint
					painter.moveTo(j, 50);
					painter.lineTo(j, 450);
               ousedmem=lastmem;
					painter.moveTo(j, 450-lastmem);
	         	} else {
					ousedmem=(omem*400)/100;
				}

				// here we draw the date the page starts with
				if(j==50) {
					painter.setFont(QFont( "helvetica", 10, QFont::Bold ));
					painter.drawText( 350, 20, when);
				}

				j=j+2;

				// we are on a new page !!
				if(j==770) {
					// reset the counter
					j=50;
					pages++;
					printer.newPage();
					// draw template for new page and move painter

					painter.drawRect(50, 50, 720, 400);

					// title
					painter.setFont(QFont( "helvetica", 12, QFont::Bold ));
					painter.drawText( 50, 20, "MEMORY-OVERVIEW for a single node" );
					painter.setFont(QFont( "helvetica", 10));
					painter.drawText( 50, 40, "logfile :");
					painter.drawText( 100, 40, filename);

					// scala
					painter.setFont(QFont("Helvetica", 10));
					painter.drawText( 55, 65, "100%" );
					painter.drawText( 55, 240, "50%" );
					painter.drawText( 55, 435, "0%" );
					painter.drawText( 55, 470, "minutes ->" );

					// minute scala
					for(int i=50;i<=770; i=i+12) {
						painter.moveTo(i, 440);
						painter.lineTo(i, 450);
					}
					// 50% percent line
					painter.moveTo(50, 250);
					painter.lineTo(770, 250);

         		// move to the start point again
					painter.moveTo(50, 450);
					} else {
					// here we paint
					painter.lineTo(j, 450-ousedmem);
					lastmem=ousedmem;
				}
			}
			fclose(readfile);
		}

		painter.end();
		} else {
		cout << "canceld " << endl;
	}
}


// sets the logg (logdirectory) variable
void OpenMosixAnalyzerApp::setlogdirectory(string name) {
	logg=name;
}


// open openMosixhistory
void OpenMosixAnalyzerApp::openhistory() {

	int error;
	string historycommand;
	historycommand.erase();
	historycommand = historycommand + "openmosixhistory ";
	historycommand = historycommand + logg;
	historycommand = historycommand + "&";

	if((error=system(historycommand.c_str())) > 0) {
	  statusBar()->message("could not open openMosixhistory");
		} else {
	  statusBar()->message("open openMosixhistory");
	}

}


// check if the logdirectory + logfile exists
void OpenMosixAnalyzerApp::checklogdirectory(string logdir) {
	string logfilename;
	logfilename.erase();
	logfilename = logfilename + logdir;
	logfilename = logfilename + "cluster";
	if (!file_exist(logfilename)) {
		QMessageBox::about(this,tr("There are no logfiles to analyze!"),tr("There are no logfiles to analyze!\nPlease run the openMosixcollector to create these logfiles!\nThen, execute the openMosixanalyzer again.") );
		exit(1);
	}
}


// to adjust the timer
void OpenMosixAnalyzerApp::adjusttimer(int val) {
	int secval=val*1000;
	proctimer->changeInterval(secval);
	string refreshmes;
	refreshmes = "set refresh timeout to ";
	refreshmes = refreshmes + int2string(val);
	refreshmes = refreshmes + " seconds";
//	cout << refreshmes << endl;
	statusBar()->message(refreshmes.c_str());
}




