#!/bin/bash


MIGGROUP=$1
PROCESSES=`ls /proc | grep [0-9]`

function usage() {
 echo "Usage: showgroup [process-group]"
 echo
 exit -1
}

if [ $# != 1 ]; then
 usage
fi

echo $MIGGROUP | grep [0-9] 1>/dev/null 2>&1
if [ $? != 0 ]; then
 echo "ERROR: wrong miggroup"
 usage
fi

for PROC in $PROCESSES; do
 if [ -f /proc/$PROC/miggroup ]; then
  PROCGROUP=`cat /proc/$PROC/miggroup`
  if [ "$MIGGROUP" == "$PROCGROUP" ]; then
   CMDLINE=`cat /proc/$PROC/cmdline`
   echo "$PROC with commandline $CMDLINE belongs to $MIGGROUP"
  fi
 fi
done



