/*
   Copyright (C) 1994-2001 Digitool, Inc
   This file is part of OpenMCL.  

   OpenMCL is licensed under the terms of the Lisp Lesser GNU Public
   License , known as the LLGPL and distributed with OpenMCL as the
   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
   which is distributed with OpenMCL as the file "LGPL".  Where these
   conflict, the preamble takes precedence.  

   OpenMCL is referenced in the preamble as the "LIBRARY."

   The LLGPL is also available online at
   http://opensource.franz.com/preamble.html
*/





	include(lisp.s)
	_beginfile
	.globl ksignalerr

/* like misc_ref, only the boxed subtag is in arg_x. 
*/
_spentry(subtag_misc_ref)
	__(trap_unless_fulltag_equal(arg_y,fulltag_misc,imm0))
	__(trap_unless_lisptag_equal(arg_z,tag_fixnum,imm0))
	__(vector_length(imm0,arg_y,imm1))
	__(twlge arg_z,imm0)
	__(unbox_fixnum(imm1,arg_x))
	__(b misc_ref_common)

/* Reference index arg_z of a misc-tagged object (arg_y). 
   Note that this conses in some cases.  Return a properly-tagged 
   lisp object in arg_z.  Do type and bounds-checking. 
*/
_spentry(misc_ref)
	__(trap_unless_fulltag_equal(arg_y,fulltag_misc,imm0))
	__(trap_unless_lisptag_equal(arg_z,tag_fixnum,imm0))
	__(vector_length(imm0,arg_y,imm1))
	__(twlge arg_z,imm0)
	__(extract_lowbyte(imm1,imm1))	/* imm1 = subtag */

misc_ref_common:
	__(extract_fulltag(imm2,imm1))
	__(cmpwi cr0,imm2,fulltag_nodeheader)
	__(cmpwi cr1,imm1,max_32_bit_ivector_subtag)
	__(cmpwi cr2,imm1,max_8_bit_ivector_subtag)
	__(addi imm0,arg_z,misc_data_offset)
	__(bne cr0,ref_imm)
	/* A node vector. */
	__(lwzx arg_z,arg_y,imm0)
	__(blr)
ref_imm:
	__(bgt cr1,ref_not32)
	__(cmpwi cr1,imm1,subtag_single_float_vector)
	__(cmpwi cr0,imm1,subtag_s32_vector)
	__(lwzx imm0,arg_y,imm0)
	__(beq cr1,ref_sfloat)
	__(beq cr0,ref_signed)
ref_unsigned:
	__(srawi. imm1,imm0,31-nfixnumtagbits)
	__(box_fixnum(arg_z,imm0))
	__(beqlr+ cr0)
	__(uuo_box_unsigned(arg_z,imm0))
	__(blr)
ref_signed:
	__(mcrxr cr0)
	__(addo imm1,imm0,imm0)
	__(addo. arg_z,imm1,imm1)
	__(bnslr)
	__(uuo_box_signed(arg_z,imm0))
	__(blr)
ref_sfloat:
	__(li imm1,(1<<num_subtag_bits)|subtag_single_float)
	__(stwu rzero,single_float.size(freeptr))
	__(la arg_z,fulltag_misc(initptr))
	__(stw imm1,single_float.header(arg_z))
	__(stw imm0,single_float.value(arg_z))
	__(mr initptr,freeptr)
	__(blr)
ref_not32:	
	__(cmpwi cr1,imm1,max_16_bit_ivector_subtag)
	__(bgt cr2,ref_not8)
	/* 8-bit objects are either u8, s8, or base_strings. */
	/* cr2_eq is set if base_string (= max_8_bit_ivector_subtag) */
	__(cmpwi cr1,imm1,subtag_s8_vector)
	__(srwi imm0,arg_z,2)
	__(la imm0,misc_data_offset(imm0))
	__(lbzx imm0,arg_y,imm0)
	__(beq cr2,ref_char)
	__(bne cr1,ref_box)
	__(extsb imm0,imm0)
ref_box:	
	__(box_fixnum(arg_z,imm0))
	__(blr)
ref_char:	
	__(slwi arg_z,imm0,charcode_shift)
	__(ori arg_z,arg_z,subtag_character)
	__(blr)
ref_not8:
	__(cmpwi cr2,imm1,subtag_bit_vector)
	__(bgt cr1,ref_not16)
	/* 16-bit objects are either u16, s16, or general_strings. */
	/* cr1_eq is set if s16_vector (= max_16_bit_ivector_subtag) */
	__(cmpwi cr0,imm1,subtag_simple_general_string)
	__(srwi imm0,arg_z,1)
	__(la imm0,misc_data_offset(imm0))
	__(lhzx imm0,arg_y,imm0)
	__(beq cr0,ref_char)
	__(bne cr1,ref_box)
	__(extsh imm0,imm0)
	__(b ref_box)
ref_not16:
	__(bne cr2,ref_dfloat)
	__(extrwi imm1,arg_z,5,32-(fixnumshift+5))	/* imm1 = bitnum */
	__(la imm1,1+fixnumshift(imm1))
	__(rlwinm imm0,arg_z,32-5,5,31-fixnumshift)
	__(la imm0,misc_data_offset(imm0))
	__(lwzx imm0,arg_y,imm0)
	__(rlwnm arg_z,imm0,imm1,31-fixnumshift,31-fixnumshift)
	__(blr)
ref_dfloat:
	__(slwi imm0,arg_z,1)
	__(la imm0,misc_dfloat_offset(imm0))
	__(la imm1,4(imm0))
	__(lwzx imm0,arg_y,imm0)
	__(lwzx imm1,arg_y,imm1)
	__(li imm2,(double_float.element_count<<num_subtag_bits)|subtag_double_float)
	__(stwu rzero,double_float.size(freeptr))
	__(la arg_z,fulltag_misc(initptr))
	__(stw imm2,double_float.header(arg_z))
	__(stw imm0,double_float.value(arg_z))
	__(stw imm1,double_float.value+4(arg_z))
	__(mr initptr,freeptr)
	__(blr)

/* like misc_set, only pass the (boxed) subtag in temp0 */
_spentry(subtag_misc_set)
	__(trap_unless_fulltag_equal(arg_x,fulltag_misc,imm0))
	__(trap_unless_lisptag_equal(arg_y,tag_fixnum,imm0))
	__(vector_length(imm0,arg_x,imm1))
	__(twlge arg_y,imm0)
	__(unbox_fixnum(imm1,temp0))
	__(b misc_set_common)

/* misc_set (vector index newval) : if a node object, may need to 
   memoize the assignment.  Otherwise, pretty damned similar to 
   misc_ref, as one might imagine. 
*/
_spentry(misc_set)
	__(trap_unless_fulltag_equal(arg_x,fulltag_misc,imm0))
	__(trap_unless_lisptag_equal(arg_y,tag_fixnum,imm0))
	__(vector_length(imm0,arg_x,imm1))
	__(twlge arg_y,imm0)
	__(extract_lowbyte(imm1,imm1))
misc_set_common:
	__(extract_fulltag(imm2,imm1))
	__(cmpwi cr0,imm2,fulltag_nodeheader)
	__(cmpwi cr1,imm1,max_32_bit_ivector_subtag)
	__(cmpwi cr2,imm1,max_8_bit_ivector_subtag)
	__(addi imm0,arg_y,misc_data_offset)
	__(bne cr0,set_imm)
	/* A node vector. If value is other than fixnum, tag_imm, nil, */
	/* need to memoize for EGC. */
	__(cmpw cr0,arg_z,rnil)
	__(extract_lisptag(imm2,arg_z))
	__(cmpwi cr1,imm2,tag_imm)
	__(cmpwi cr2,imm2,tag_fixnum)
	__(beq cr0,set_simple)
	__(beq cr1,set_simple)
	__(beq cr2,set_simple)
	__(add loc_g,arg_x,imm0)
	__(push(loc_g,memo))
	__(stw arg_z,0(loc_g))
	__(blr)
set_simple:
	__(stwx arg_z,arg_x,imm0)
	__(blr)
set_imm:
	__(extract_lisptag(imm2,arg_z))
	__(cmpwi cr7,imm2,tag_misc)
	__(cmpwi cr6,imm2,tag_imm)
	__(cmpwi cr5,imm2,tag_fixnum)
	__(bgt cr1,set_not32)
	__(cmpwi cr1,imm1,subtag_single_float_vector)
	__(cmpwi cr0,imm1,subtag_s32_vector)
	__(beq cr1,set_sfloat)
	__(beq cr0,set_signed)
	/* Either a non-negative fixnum, a one-digit bignum, or a two-digit */
	/* bignum whose sign-digit is 0 is ok. */
	__(srawi. imm1,arg_z,fixnum_shift)
	__(bne cr5,set_not_fixnum_u32)
	__(blt- cr0,set_bad)
set_set32:
	__(stwx imm1,arg_x,imm0)
	__(blr)
set_not_fixnum_u32:
	__(bne cr7,set_bad)
	__(extract_header(imm2,arg_z))
	__(cmpwi cr0,imm2,one_digit_bignum_header)
	__(cmpwi cr1,imm2,two_digit_bignum_header)
	__(vref32(imm1,arg_z,0))
	__(cmpwi cr2,imm1,0)
	__(bne cr0,set_not_1_digit)
	__(bge cr2,set_set32)
	__(b set_bad)
set_not_1_digit:
	__(bne- cr1,set_bad)
	__(vref32(imm2,arg_z,1))
	__(cmpwi cr0,imm2,0)
	__(bne- cr1,set_bad)
	__(beq cr0,set_set32)
set_bad:
	/* arg_z does not match the array-element-type of arg_x. */
	__(mr arg_y,arg_z)
	__(mr arg_z,arg_x)
	__(li arg_x,XNOTELT)
	__(set_nargs(3))
	__(b ksignalerr)
set_signed:
	__(unbox_fixnum(imm1,arg_z))
	__(beq cr5,set_set32)
	__(bne cr7,set_bad)
	__(extract_header(imm2,arg_z))
	__(cmpwi cr0,imm2,one_digit_bignum_header)
	__(vref32(imm1,arg_z,0))
	__(bne- cr0,set_bad)
	__(stwx imm1,arg_x,imm0)
	__(blr)
set_sfloat:
	__(bne- cr7,set_bad)
	__(extract_header(imm2,arg_z))
	__(cmpwi cr0,imm2,single_float_header)
	__(bne- cr0,set_bad)
	__(lwz imm1,single_float.value(arg_z))
	__(stwx imm1,arg_x,imm0)
	__(blr)
	
set_not32:
	__(cmpwi cr1,imm1,max_16_bit_ivector_subtag)
	__(bgt cr2,set_not8)
	/* 8-bit objects are either u8, s8, or base_strings. */
	/* cr2_eq is set if base_string (= max_8_bit_ivector_subtag) */
	__(cmpwi cr1,imm1,subtag_s8_vector)
	__(extract_lisptag(imm2,arg_z))
	__(srwi imm0,arg_y,2)
	__(la imm0,misc_data_offset(imm0))
	__(extract_unsigned_byte_bits_(imm1,arg_z,8))
	__(beq cr2,set_char8)
	__(beq cr1,set_signed8)
	__(unbox_fixnum(imm1,arg_z))
	__(bne- cr0,set_bad)
	__(stbx imm1,arg_x,imm0)
	__(blr)
set_char8:
	__(extract_lowbyte(imm2,arg_z))
	__(cmpwi cr2,imm2,subtag_character)
	__(srwi imm1,arg_z,charcode_shift)
	__(bne- cr2,set_bad)
	__(stbx imm1,arg_x,imm0)
	__(blr)
set_signed8:
	__(unbox_fixnum(imm1,arg_z))
	__(extsb imm2,imm1)
	__(cmpw cr0,imm2,imm1)
	__(bne- cr5,set_bad)
	__(bne- cr0,set_bad)
	__(stbx imm1,arg_x,imm0)
	__(blr)
set_not8:
	__(cmpwi cr2,imm1,subtag_bit_vector)
	__(bgt cr1,set_not16)
/* 16-bit objects are either u16, s16, or general_strings. */
/* cr1_eq is set if s16_vector (= max_16_bit_ivector_subtag) */
	__(cmpwi cr0,imm1,subtag_simple_general_string)
	__(srwi imm0,arg_y,1)
	__(la imm0,misc_data_offset(imm0))
	__(beq cr1,set_s16)
	__(beq cr0,set_char16)
	__(extract_unsigned_byte_bits_(imm1,arg_z,16))
	__(unbox_fixnum(imm1,arg_z))
	__(bne- cr0,set_bad)
	__(sthx imm1,arg_x,imm0)
	__(blr)
set_s16:
	__(unbox_fixnum(imm1,arg_z))
	__(extsh imm2,imm1)
	__(cmpw cr0,imm2,imm1)
	__(bne- cr5,set_bad)
	__(bne- cr0,set_bad)
	__(sthx imm1,arg_x,imm0)
	__(blr)
set_char16:
	__(extract_lowbyte(imm2,arg_z))
	__(cmpwi cr0,imm2,subtag_character)
	__(srwi imm1,arg_z,charcode_shift)
	__(bne- cr0,set_bad)
	__(sthx imm1,arg_x,imm0)
	__(blr)
set_not16:	
	__(bne cr2,set_dfloat)
	/* Bit vector case. */
	__(cmplwi cr2,arg_z,fixnumone)   /* nothing not a (boxed) bit  */
	__(extrwi imm1,arg_y,5,32-(fixnumshift+5))	/* imm1 = bitnum */
	__(extlwi imm2,arg_z,1,31-fixnumshift)
	__(srw imm2,imm2,imm1)
	__(lis imm3,0x8000)
	__(rlwinm imm0,arg_y,32-5,5,31-fixnumshift)
	__(la imm0,misc_data_offset(imm0))
	__(srw imm3,imm3,imm1)
	__(bgt- cr2,set_bad)
	__(lwzx imm1,arg_x,imm0)
	__(andc imm1,imm1,imm3)
	__(or imm1,imm1,imm2)
	__(stwx imm1,arg_x,imm0)
	__(blr)

set_dfloat:
	__(bne- cr7,set_bad)		/* not tag_misc */
	__(extract_header(imm2,arg_z))
	__(cmpwi cr0,imm2,double_float_header)
	__(slwi imm0,arg_y,1)  /* imm0 gets index * 2 */
	__(la imm0,misc_dfloat_offset(imm0)) /* + offset */
	__(bne- cr0,set_bad)
	__(lwz imm1,double_float.value(arg_z)) /* get value parts */
	__(lwz imm2,double_float.value+4(arg_z))
	__(stwx imm1,arg_x,imm0)
	__(la imm0,4(imm0))
	__(stwx imm2,arg_x,imm0)
	__(blr)
	_endfn
	_endfile

