/*
   Copyright (C) 1994-2001 Digitool, Inc
   This file is part of OpenMCL.  

   OpenMCL is licensed under the terms of the Lisp Lesser GNU Public
   License , known as the LLGPL and distributed with OpenMCL as the
   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
   which is distributed with OpenMCL as the file "LGPL".  Where these
   conflict, the preamble takes precedence.  

   OpenMCL is referenced in the preamble as the "LIBRARY."

   The LLGPL is also available online at
   http://opensource.franz.com/preamble.html
*/


/* Stack-consing subprims (except for those associated with &rest args.) */


	include(lisp.s)
	_beginfile
	.globl init_list_from_stack
	.globl _SPmisc_alloc

/* Make a cons cell on the vstack.  Always push 3 words, 'cause we're  
   not sure how the vstack will be aligned. */
_spentry(stkconsyz)
	__(vpush(rnil))
	__(vpush(rnil))
	__(vpush(rnil))
	__(andi. imm0,vsp,1<<2) /* (oddp vsp ?) */
	__(beq cr0,1f)
	__(stw arg_y,8(vsp)) /* car */
	__(stw arg_z,4(vsp)) /* cdr */
	__(la arg_z,fulltag_cons+4(vsp))
	__(blr)
1:
	__(stw arg_y,4(vsp)) /* car, again */
	__(stw arg_z,0(vsp))
	__(la arg_z,fulltag_cons(vsp))
	__(blr)

/* Make a stack-consed value cell.  Much like the case of stack-allocating a cons 
   cell.  Imm0 points to the closed-over value (already vpushed).  Replace 
   that locative with the vcell. */
_spentry(stkvcellvsp)
	__(mr imm0,vsp)
_spentry(stkvcell0)
	__(sub imm1,imm0,vsp) /* imm1 = delta from vsp to value cell loc */
	__(vpush(rnil))
	__(vpush(rnil))
	__(vpush(rnil))
	__(addi imm1,imm1,12)
	__(add imm0,vsp,imm1) /* in case stack overflowed */
	__(andi. imm1,vsp,1<<2) /* (oddp vsp) ? */
	__(li imm1,value_cell_header)
	__(lwz arg_z,0(imm0))
	__(beq cr0,1f)
	__(stw arg_z,8(vsp))
	__(stw imm1,4(vsp))
	__(la arg_z,fulltag_misc+4(vsp))
	__(stw arg_z,0(imm0))
	__(blr)
1:
	__(stw arg_z,4(vsp))
	__(stw imm1,0(vsp))
	__(la arg_z,fulltag_misc(vsp))
	__(stw arg_z,0(imm0))
	__(blr)

/* Make a "raw" area on the temp stack, stack-cons a macptr to point to it, 
   and return the macptr.  Size (in bytes, boxed) is in arg_z on entry; macptr in 
   arg_z on exit. 
   It would be nice to cons in the Mac heap if there's not room on 
   the tstack. This code will handle a new tstack segment being added. */
_spentry(makestackblock)
	__(unbox_fixnum(imm0,arg_z))
	__(la imm0,8+macptr.size+7(imm0))
	__(clrrwi imm0,imm0,3)
	__(cmplwi cr0,imm0,tstack_alloc_limit)
	__(neg imm0,imm0)
	__(bge cr0,1f)

	__(stwux tsp,tsp,imm0)
	__(stw tsp,4(tsp)) /* "raw" block. */
	__(li imm0,macptr_header)
	__(la imm1,8+macptr.size(tsp))
	__(la arg_z,8+fulltag_misc(tsp))
	__(stw imm0,macptr.header(arg_z))
	__(stw imm1,macptr.address(arg_z)) /* makestackblock0 expects the address to be in imm1 */
	__(blr)

/* Too big. Heap cons a gcable macptr */
1:
	__(stwu tsp,-8(tsp))
	__(stw tsp,4(tsp)) /* "raw" block to make the compiler happy */
	__(set_nargs(1))
	__(la fname,nrs.new_gcable_ptr(rnil))
	__(jump_fname())


/* As above, only set the block's contents to 0. */
_spentry(makestackblock0)
	__(mr arg_y,arg_z) /* save block size */
	__(unbox_fixnum(imm0,arg_z))
	__(la imm0,8+macptr.size+7(imm0))
	__(clrrwi imm0,imm0,3)
	__(cmplwi cr0,imm0,tstack_alloc_limit)
	__(neg imm0,imm0)
	__(bge cr0,3f)

	__(stwux tsp,tsp,imm0)
	__(stw tsp,4(tsp)) /* "raw" block. */
	__(li imm0,macptr_header)
	__(la imm1,8+macptr.size(tsp))
	__(la arg_z,8+fulltag_misc(tsp))
	__(stw imm0,macptr.header(arg_z))
	__(stw imm1,macptr.address(arg_z)) /* makestackblock0 expects the address to be in imm1 */

	__(unbox_fixnum(imm0,arg_y))
	__(la imm0,7(imm0))
	__(clrrwi imm0,imm0,3)
	__(add imm2,imm1,imm0) /* end of the line */
	__(cmpw cr0,imm1,imm2)
	__(la imm2,-8(imm2))
	__(b 2f)
1:
	__(cmpw cr0,imm1,imm2)
	__(stw rzero,0(imm1))
	__(la imm1,8(imm1))
	__(stw rzero,-4(imm1))
2:
	__(bne cr0,1b)
	__(blr)

/* Too big. Heap cons a gcable macptr */
3:
	__(stwu tsp,-8(tsp))
	__(stw tsp,4(tsp)) /* "raw" block to make the compiler happy */

	__(la arg_z,nrs.tsym(rnil)) /* clear-p arg to %new-gcable-ptr */
	__(set_nargs(2))
	__(la fname,nrs.new_gcable_ptr(rnil))
	__(jump_fname())

/* Make a list of length arg_y (boxed), initial-element arg_z (boxed) on 
   the tstack.  Return the list in arg_z. */
_spentry(makestacklist)
	__(add imm0,arg_y,arg_y)
	__(cmplwi cr1,imm0,((tstack_alloc_limit+1)-8))
	__(addi imm0,imm0,8)
	__(neg imm0,imm0)
	__(bge cr1,3f)
	__(mr imm1,arg_y)
	__(cmpwi cr1,imm1,0)
	__(mr arg_y,arg_z)
	__(mr arg_z,rnil)
	__(mr initptr,tsp) /* uninterruptable */
	__(stwux tsp,tsp,imm0)
	__(stw rzero,4(tsp))
	__(sub initptr,tsp,imm0) /* correct for stack overflow */
	__(la initptr,-8+tag_list(initptr))
	__(b 2f)
1:
	__(subi imm1,imm1,fixnum1)
	__(cmpwi cr1,imm1,0)
	__(rplacd(initptr,arg_z))
	__(rplaca(initptr,arg_y))
	__(mr arg_z,initptr)
	__(subi initptr,initptr,cons.size)
2:
	__(bne cr1,1b)
	__(mr initptr,freeptr)
	__(blr)

3:
	__(cmpwi cr1,arg_y,0)
	__(stwu tsp,-8(tsp)) /* make the compiler happy */
	__(stw rzero,4(tsp))
	__(mr imm1,arg_y) /* count */
	__(mr arg_y,arg_z) /* initial value */
	__(mr arg_z,rnil) /* result */
	__(b 5f)
4:
	__(subi imm1,imm1,fixnum1)
	__(cmpwi cr1,imm1,0)
	__(stwu rzero,cons.size(freeptr))
	__(la initptr,tag_list(initptr))
	__(rplaca(initptr,arg_y))
	__(rplacd(initptr,arg_z))
	__(mr arg_z,initptr)
	__(mr initptr,freeptr)
5:
	__(bne cr1,4b)
	__(blr)


/* subtype (boxed) vpushed before initial values. (Had better be a 
	node header subtag.) Nargs set to count of things vpushed. */
_spentry(stkgvector)
	__(la imm0,-4(nargs))
	__(cmpwi cr0,imm0,0)
	__(add imm1,vsp,nargs)
	__(lwzu temp0,-4(imm1))
	__(slwi imm2,imm0,num_subtag_bits-fixnumshift)
	__(rlwimi imm2,temp0,32-fixnumshift,32-num_subtag_bits,31)
	__(la imm0,(8+4+7)(imm0))
	__(clrrwi imm0,imm0,3)
	__(neg imm0,imm0)
	__(mr initptr,tsp) /* uninterruptable */
	__(stwux tsp,tsp,imm0)
	__(sub initptr,tsp,imm0) /* correct for stack overflow */
	__(stw rzero,-4(initptr))
	__(stw rzero,4(tsp))
	__(la arg_z,8+fulltag_misc(tsp))
	__(la initptr,misc_header_offset(arg_z))
	__(stw imm2,0(initptr))
	__(li imm0,fixnum1)
	__(b 2f)
1:
	__(addi imm0,imm0,fixnum1)
	__(cmpw cr0,imm0,nargs)
	__(lwzu temp0,-4(imm1))
	__(stwu temp0,4(initptr))
2:
	__(bne cr0,1b)
	__(mr initptr,freeptr)
	__(add vsp,vsp,nargs)
	__(blr)


/* We always have to create a tsp frame (even if nargs is 0), so the compiler 
   doesn't get confused. */
_spentry(stkconslist)
	__(mr arg_z,rnil)
/* do list*: last arg in arg_z, all others vpushed, 
	nargs set to #args vpushed. */
_spentry(stkconslist_star)
	/*stw rzero,-4096(tsp)		; half-hearted stack probe. */
	__(cmpwi nargs,0)
	__(add imm1,nargs,nargs)
	__(addi imm1,imm1,8)
	__(neg imm1,imm1)
	__(mr initptr,tsp) /* uninterruptable */
	__(stwux tsp,tsp,imm1)
	__(sub initptr,tsp,imm1) /* correct for stack overflow */
	__(la initptr,-8+fulltag_cons(initptr))
	__(stw rzero,4(tsp))
	__(b init_list_from_stack)

/* Make a stack-consed simple-vector out of the NARGS objects 
	on top of the vstack; it in arg_z. */
_spentry(mkstackv)
	/*stw rzero,-4096(tsp) */
	__(cmpwi nargs,0)
	__(neg imm1,nargs)
	__(la imm1,-(4+8)(imm1))
	__(bitclr(imm1,imm1,2))
	__(mr initptr,tsp) /* uninterruptable */
	__(stwux tsp,tsp,imm1)
	__(sub initptr,tsp,imm1) /* correct for stack overflow */
	__(stw rzero,4(tsp))
	__(stw rzero,-4(initptr))
	__(slwi imm0,nargs,num_subtag_bits-fixnumshift)
	__(ori imm0,imm0,subtag_simple_vector)
	__(stw imm0,8(tsp))
	__(la arg_z,8+fulltag_misc(tsp))
	__(beq- 2f)
	__(la imm0,8+4(tsp))
	__(add initptr,imm0,nargs)
1:
	__(la nargs,-4(nargs))
	__(cmpwi nargs,0)
	__(lwz temp1,0(vsp))
	__(la vsp,4(vsp))
	__(stwu temp1,-4(initptr))
	__(bne 1b)
2:
	__(mr initptr,freeptr)
	__(blr)

/* Allocate a miscobj on the temp stack.  (Push a frame on the tsp and 
   heap-cons the object if there's no room on the tstack.) */

_spentry(stack_misc_alloc)
	__(rlwinm. imm2,arg_y,32-fixnumshift,0,(8+fixnumshift)-1)
	__(unbox_fixnum(imm0,arg_z))
	__(extract_fulltag(imm1,imm0))
	__(bne- cr0,9f)
	__(cmpwi cr0,imm1,fulltag_nodeheader)
	__(mr imm3,imm0)
	__(cmplwi cr1,imm0,max_32_bit_ivector_subtag)
	__(rlwimi imm0,arg_y,num_subtag_bits-fixnum_shift,0,31-num_subtag_bits) /* imm0 now = header */
	__(mr imm2,arg_y)
	__(beq cr0,1f)	/* do probe if node object 
			   (fixnum element count = byte count). */
	__(cmplwi cr0,imm3,max_16_bit_ivector_subtag)
	__(bng cr1,1f) /* do probe if 32-bit imm object */
	__(cmplwi cr1,imm3,max_8_bit_ivector_subtag)
	__(srwi imm2,imm2,1)
	__(bgt cr0,3f)
	__(bgt cr1,1f)
	__(srwi imm2,imm2,1)
/* imm2 now = byte count.  Add 4 for header, 7 to align, then 
	clear low three bits. */
1:
	__(addi imm2,imm2,4+7)
	__(clrrwi imm2,imm2,3)
	__(la imm3,8(imm2)) /* account for tsp header */
	__(cmplwi cr0,imm3,tstack_alloc_limit) /* more than limit ? */
	__(bgt- cr0,0f)
	__(neg imm3,imm3)
	__(mr initptr,tsp) /* no interrupts */
	__(stwux tsp,tsp,imm3)
	__(sub initptr,tsp,imm3) /* correct for stack overflow */
	__(stw rzero,4(tsp))
/* Even if we're going to initialize this to some non-zero value in a 
	second, we initialize the vector's contents to 0 now, so that
	the period in which we're not  gc-safe is as short as possible. 
	Note that the loop can be written to assume that we've always 
	got at least a doubleword to initialize (because of the vector header.) 
*/
2:
	__(subi imm2,imm2,8)
	__(cmpwi cr0,imm2,0)
	__(subi initptr,initptr,8)
	__(stw rzero,4(initptr))
	__(stw rzero,0(initptr))
	__(bne cr0,2b)
/* Slap the header on the vector, then fix initptr & return. */
	__(la arg_z,fulltag_misc(initptr))
	__(mr initptr,freeptr)
	__(stw imm0,misc_header_offset(arg_z))
	__(blr)
9: 



/* Too large to safely fit on tstack.  Heap-cons the vector, but make 
   sure that there's an empty tsp frame to keep the compiler happy. */
0:
	__(stwu tsp,-8(tsp))
	__(stw rzero,4(tsp))
	__(b _SPmisc_alloc)
3:
	__(cmplwi imm3,subtag_double_float_vector)
	__(slwi imm2,arg_y,1)
	__(beq 1b)
	__(addi imm2,arg_y,7<<fixnumshift)
	__(srwi imm2,imm2,fixnumshift+3)
	__(b 1b)

/* As in stack_misc_alloc above, only with a non-default initial-value. */

_spentry(stack_misc_alloc_init)
	__(mflr loc_pc)
	__(create_lisp_frame())
	__(stw fn,lisp_frame.savefn(sp))
	__(stw loc_pc,lisp_frame.savelr(sp))
	__(stw vsp,lisp_frame.savevsp(sp))
	__(li fn,0)
	__(mr temp0,arg_z) /* initval */
	__(mr arg_z,arg_y) /* subtag */
	__(mr arg_y,arg_x) /* element-count */
	__(bl stack_misc_alloc)
	__(lwz loc_pc,lisp_frame.savelr(sp))
	__(mtlr loc_pc)
	__(lwz fn,lisp_frame.savefn(sp))
	__(lwz vsp,lisp_frame.savevsp(sp)) /* vsp may have changed due to overflowing a stack segment */
	__(discard_lisp_frame())
	__(la fname,nrs.init_misc(rnil))
	__(set_nargs(2))
	__(mr arg_y,temp0)
	__(jump_fname())

	_endfile


