/*
   Copyright (C) 1994-2001 Digitool, Inc
   This file is part of OpenMCL.  

   OpenMCL is licensed under the terms of the Lisp Lesser GNU Public
   License , known as the LLGPL and distributed with OpenMCL as the
   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
   which is distributed with OpenMCL as the file "LGPL".  Where these
   conflict, the preamble takes precedence.  

   OpenMCL is referenced in the preamble as the "LIBRARY."

   The LLGPL is also available online at
   http://opensource.franz.com/preamble.html
*/

/* 
   A simple server loop for vxppccl.
*/



#include <stdio.h>
#include <setjmp.h>
#include "sockets.h"

#define LISP_PORT 1717


int default_lisp_port = LISP_PORT;


jmp_buf vxppccl_exit;

#ifdef TESTING
extern
server_test_loop(void);
#else
extern
vxppcclMain(void);
#endif
vxppccl()
{
  int sock, sock1;
  int old_in, old_out, old_err;

  old_in = ioTaskStdGet(0, 0);
  old_out = ioTaskStdGet(0, 1);
  old_err = ioTaskStdGet(0, 2);

  sock = open_server_socket(default_lisp_port);

  do {
    sock1 = accept_client_socket(sock);
    if (sock1 < 0) {
      close(sock);
      sock = -1;
      break;
    }
    if (setjmp(vxppccl_exit) == 0) {
      ioTaskStdSet(0, 0, sock1);
      ioTaskStdSet(0, 1, sock1);
      ioTaskStdSet(0, 2, sock1);
      fprintf(stderr, "Connected; starting vxppccl ... \n");
      fflush(stderr);
#ifdef TESTING
      server_test_loop();
#else
      vxppcclMain();
#endif
    }
    close(sock1);
  } while (0);
  ioTaskStdSet(0, 0, old_in);
  ioTaskStdSet(0, 1, old_out);
  ioTaskStdSet(0, 2, old_err);
  close(sock);
  return 0;
}

#ifdef TESTING
server_test_loop()
{
  char buf[512];
  fd_set infds;


  while(1) {
    fprintf(stdout, "type something: ");
    fflush(stdout);
    FD_ZERO(&infds);
    FD_SET(0, &infds);
    select(1, &infds, NULL, NULL, NULL);
    fgets(buf, 80, stdin);
    fprintf(stdout, "input was %s\n", buf);
  }
}
#endif
