;;-*-Mode: LISP; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of OpenMCL.  
;;;
;;;   OpenMCL is licensed under the terms of the Lisp Lesser GNU Public
;;;   License , known as the LLGPL and distributed with OpenMCL as the
;;;   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
;;;   which is distributed with OpenMCL as the file "LGPL".  Where these
;;;   conflict, the preamble takes precedence.  
;;;
;;;   OpenMCL is referenced in the preamble as the "LIBRARY."
;;;
;;;   The LLGPL is also available online at
;;;   http://opensource.franz.com/preamble.html


(eval-when (:compile-toplevel :load-toplevel :execute)
  (export				;remember "CCL" at end of list
					;setq %ccl-package-export-syms
   '(
     local
     set-local
     *elements-per-buffer*
     save-application
     def-load-pointers
     *save-exit-functions*
     *restore-lisp-functions*
     *lisp-cleanup-functions*
     *lisp-startup-functions*
     *break-on-warnings*
					; misc
     record-source-file
     get-source-files
     edit-definition
     edit-definition-p
     *loading-file-source-file*
     show-documentation
     %set-toplevel
     toplevel-loop
     toplevel-function
    toplevel
     cancel
     catch-cancel
     throw-cancel
     *backtrace-on-break*
     print-call-history
     compiler-macroexpand
     compiler-macroexpand-1
     compile-load
     uncompile-function
     abort-break
     *trace-print-level*
     *trace-print-length*
     *trace-bar-frequency*
     advise
     unadvise
     advisedp
     nfunction
     function-name

     assq
     bignump
     bitp
     constant-symbol-p
     proclaimed-special-p
     delq
     fixnump
     quit
     include
     memq
     nremove
					;put
     ratiop
     structure-typep
     structurep
     type-specifier-p
     displaced-array-p
     without-interrupts
     true
     false
     neq
     whitespacep
     *print-structure*
     *print-simple-vector*
     *print-simple-bit-vector*
     *print-string-length*
     *print-abbreviate-quote*
     *signal-printing-errors*
     unignore
     *warn-if-redefine-kernel*
     require-type
     dovector
     debugging-function-name
     *make-package-use-defaults*
     *autoload-lisp-package*
     tyo
     tyi
     untyi
     compiled-lexical-closure		; the type name
     lsh


					; The MOP
     metaobject
     long-method-combination
     short-method-combination
     standard-accessor-method
     standard-reader-method
     standard-writer-method
     specializer

     funcallable-standard-class

     class-prototype
     clear-specializer-direct-methods-caches
     *check-call-next-method-with-args*
     clear-gf-cache
     clear-all-gf-caches
     clear-clos-caches

     method-function
     method-name
     method-generic-function
     method-exists-p
     method-specializers
     generic-function-methods
     class-own-wrapper
     class-precedence-list
     class-direct-superclasses
     class-direct-subclasses
     specializer-direct-methods
     specializer-direct-generic-functions
     class-direct-instance-slots
     class-direct-class-slots
     class-instance-slots
     class-class-slots
     slot-definition-name
     slot-definition-initargs
     slot-definition-initform
     slot-definition-initfunction
     slot-definition-type
     slot-readers
     slot-writers
     accessor-method-slot-definition
     *defmethod-congruency-override*
     *super-optimize-primary-slot-access*
     copy-instance

     string-studlify			;** DO NOT REMOVE, DO NOT DOCUMENT
     nstring-studlify			;** DO NOT REMOVE, DO NOT DOCUMENT

					; User Options
     *compile-definitions*
     *record-source-file*
     *save-doc-strings*
     *warn-if-redefine*
     *break-on-errors* 
     *save-definitions*
     *save-local-symbols*
     *fasl-save-local-symbols*
     *always-eval-user-defvars*

					;These 3 need to be set by the user in order for the correspondingly named
					;functions to return something other than "unspecified".
     *short-site-name*
     *long-site-name*
     machine-owner

     init-list-default
     fset

					; Files.
     mac-default-directory
     directory-pathname-p
     full-pathname
     create-file
     create-directory
     file-create-date
     set-file-write-date
     set-file-create-date
     copy-file
     lock-file
     unlock-file
     file-locked-p
     directoryp

     *module-file-alist*
     *module-search-path*
     *.lisp-pathname*
     *.fasl-pathname*
     *pathname-translations-pathname*
     *default-external-format*
     fasl-concatenate
     event-ticks
     set-event-ticks
     event-dispatch

     *application*
     arglist
     arglist-string
     arglist-to-stream
     function-args


     get-string-from-user
     with-terminal-input
     *request-terminal-input-via-break*
     select-item-from-list


					; Low-level
     %stack-block
     %vstack-block
     %get-byte
     %get-signed-byte
     %get-unsigned-byte
     %get-word
     %get-signed-word
     %get-unsigned-word
     %get-long
     %get-unsigned-long
     %get-signed-long
     %get-fixnum
     %get-point
     %get-ptr
     %get-full-long
     %get-string
     %get-cstring
     %str-from-ptr-in-script
     %get-ostype
     %put-byte
     %put-word
     %put-long
     %put-ptr
     %put-full-long
     %get-double-float
     %get-single-float
     %put-double-float
     %put-single-float
     %inc-ptr
     %incf-ptr
     %setf-macptr
     %null-ptr
     %null-ptr-p
     %ptr-eql
     %ptr-to-int
     %int-to-ptr
     %word-to-int
     %address-of
     ensure-simple-string
     %copy-float
     with-macptrs
     pointerp
     macptrp
     macptr
     rlet
     pref
     rref
     with-cstrs
     with-string-vector

     define-entry-point
     define-callback
     defcallback
     ff-call

     uvref
     uvectorp
     uvsize

     ;;Streams (should be made more complete sometime)
     input-stream
     output-stream
     stream-eofp

     *open-file-streams*
     stream-line-length
     string-output-stream
     truncating-string-stream
     make-truncating-string-stream
     stream-rubout-handler


					; Tools
     gc
     egc
     egc-enabled-p
     egc-active-p
     configure-egc
     egc-configuration
     gccounts
     gctime
     lisp-heap-gc-threshold
     use-lisp-heap-gc-threshold
     set-lisp-heap-gc-threshold
     *trace-max-indent* 
     *trace-level* 
     *record-types* 
     *fasl-save-doc-strings* 
     *fasl-save-definitions* 
     *current-view* 
     *color-available* 
     *background-event-ticks* 
     *pascal-full-longs*


     compiler-let


     COMPILER-POLICY
     CURRENT-COMPILER-POLICY
     CURRENT-FILE-COMPILER-POLICY
     FIND-MACTYPE
     NEW-COMPILER-POLICY
     SET-CURRENT-COMPILER-POLICY
     SET-CURRENT-FILE-COMPILER-POLICY
     STANDARD-METHOD-COMBINATION
     STREAM-DIRECTION
     *current-process*
     *all-processes*
     *active-processes*
     process-preset
     process-reset
     process-reset-and-enable
     process-abort
     process-flush
     process-kill
     process-interrupt
     process-name
     process-stack-group
     process-initial-stack-group
     process-run-function
     make-process
     process-active-p
     process-initial-form
     process-wait-function
     process-wait-argument-list
     process-whostate
     *default-quantum*
     *default-process-stackseg-size*
     process-quantum-remaining
     process-priority
     process-warm-boot-action
     process-simple-p
     process-background-p
     process-last-run-time
     process-total-run-time
     process-creation-time
     clear-process-run-time
     process-run-reasons
     process-arrest-reasons
     process-enable
     process-disable
     let-globally
     process-block
     process-block-with-timeout
     process-unblock
     process-enable-run-reason
     process-disable-run-reason
     process-enable-arrest-reason
     process-disable-arrest-reason
     process-wait
     process-wait-with-timeout
     process-poll
     process-poll-with-timeout
     *always-process-poll-p*

     make-lock
     lock-owner
     lock-name
     with-lock-grabbed
     store-conditional
     process-lock
     process-unlock
     make-process-queue
     process-enqueue
     process-enqueue-with-timeout
     process-allow-schedule
     with-process-enqueued
     process-dequeue
     process-queue-locker
     reset-process-queue
     symbol-value-in-process
     make-stack-group
     stack-group-preset
     stack-group-resume
     stack-group-return
     previous-stack-group
     symbol-value-in-stack-group
     *minimum-stack-overflow-size*

					; termination
     terminate-when-unreachable
     terminate
     drain-termination-queue
     cancel-terminate-when-unreachable
     termination-function
     *enable-automatic-termination*

     get-fpu-mode
     set-fpu-mode

					; There's more. Like...

     *listener-indent*
     *error-print-circle*
     *break-loop-when-uninterruptable*

     application-error
     application-name
     application-init-file

     cwd

     ;; Old CLtL2 stuff:

     *applyhook*
     *evalhook*
     applyhook
     augment-environment
     declaration-information
     define-declaration
     define-setf-method
     evalhook
     enclose
     function-information
     generic-flet
     generic-labels
     get-setf-method
     get-setf-method-multiple-value
     parse-macro
     variable-information
     with-added-methods

     ;; Gray Streams
     fundamental-stream
     fundamental-input-stream
     fundamental-output-stream
     fundamental-character-stream
     fundamental-character-input-stream
     fundamental-character-output-stream
     fundamental-binary-stream
     fundamental-binary-input-stream
     fundamental-binary-output-stream

     stream-read-char
     stream-unread-char
     stream-read-char-no-hang
     stream-peek-char
     stream-listen
     stream-read-line
     stream-clear-input

     stream-write-char
     stream-line-column
     stream-start-line-p
     stream-write-string
     stream-terpri
     stream-fresh-line
     stream-force-output
     stream-clear-output
     stream-advance-to-column

     stream-read-byte
     stream-write-byte

     stream-read-ivector
     stream-write-ivector
     ;;
     external
     open-shared-library
     close-shared-library
     shlib
     external-entry-point
     use-interface-dir
     unuse-interface-dir
     ;;
     run-program
     external-process
     signal-external-process
     external-process-id
     external-process-input-stream
     external-process-output-stream
     external-process-error-stream
     external-process-status
     ;;
     *altivec-available*
     altivec-available-p
     *altivec-lapmacros-maintain-vrsave-p*
     ;;
     *alternate-line-terminator*
     ;;
     set-user-environment
     set-development-environment
     ;;
     compile-ccl
     xcompile-ccl
     xload-level-0
     stream-read-list
     stream-write-list
     stream-read-vector
     stream-write-vector
     ) "CCL"
   )
  )

(unless (eq %lisp-system-fixups% T)
  (while %lisp-system-fixups%
    (let* ((fn.source (car %lisp-system-fixups%))
           (*loading-file-source-file* (cdr fn.source)))
      (funcall (car fn.source)))
    (setq %lisp-system-fixups% (cdr %lisp-system-fixups%)))
  (setq %lisp-system-fixups% T))


