;;;-*-Mode: LISP; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of OpenMCL.  
;;;
;;;   OpenMCL is licensed under the terms of the Lisp Lesser GNU Public
;;;   License , known as the LLGPL and distributed with OpenMCL as the
;;;   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
;;;   which is distributed with OpenMCL as the file "LGPL".  Where these
;;;   conflict, the preamble takes precedence.  
;;;
;;;   OpenMCL is referenced in the preamble as the "LIBRARY."
;;;
;;;   The LLGPL is also available online at
;;;   http://opensource.franz.com/preamble.html

(in-package "CCL")

(defsparclapfunction %get-kernel-global-from-offset ((offset %arg_z))
  (check-nargs 1)
  (unbox-fixnum offset %imm0)
  (retl)
    (ld (%rnil %imm0) %arg_z))

(defsparclapfunction %set-kernel-global-from-offset ((offset %arg_y) (new-value %arg_z))
  (check-nargs 2)
  (unbox-fixnum offset %imm0)
  (retl)
    (st new-value (%rnil %imm0)))

(defsparclapfunction %fixnum-ref ((fixnum %arg_y) #| &optional |# (offset %arg_z))
  (check-nargs 1 2)
  (cmp %nargs '1)
  (bne @2-args)
    (nop)
  (mov offset fixnum)
  (clr offset)
  @2-args
  (unbox-fixnum offset %imm0)
  (retl)
    (ld (fixnum %imm0) %arg_z))

(defsparclapfunction %fixnum-set ((fixnum %arg_x)
				  (offset %arg_y) #| &optional |#
				  (new-value %arg_z))
  (check-nargs 2 3)
  (cmp %nargs '2)
  (bne @3-args)
    (nop)
  (mov offset fixnum)
  (clr offset)
  @3-args
  (unbox-fixnum offset %imm0)
  (st new-value (fixnum %imm0))
  (retl)
    (mov new-value %arg_z))

; Sure would be nice to have &optional in defppclapfunction arglists
(let ((bits (lfun-bits #'(lambda (x &optional y) (declare (ignore x y))))))
  (lfun-bits #'%fixnum-ref
             (dpb (ldb $lfbits-numreq bits)
                  $lfbits-numreq
                  (dpb (ldb $lfbits-numopt bits)
                       $lfbits-numopt
                       (lfun-bits #'%fixnum-ref)))))

(let ((bits (lfun-bits #'(lambda (x y &optional z) (declare (ignore x y z))))))
  (lfun-bits #'%fixnum-set
             (dpb (ldb $lfbits-numreq bits)
                  $lfbits-numreq
                  (dpb (ldb $lfbits-numopt bits)
                       $lfbits-numopt
                       (lfun-bits #'%fixnum-set)))))




(defsparclapfunction %stack-group-trampoline ((arg_z %arg_z))
  (check-nargs 1)
  (mov %nfn %arg_y)
  (set-nargs 2)
  (jump-subprim .SPfuncall)
    (ld (%nfn 2) %temp0))

(defsparclapfunction %current-frame-ptr ()
  (check-nargs 0)
  (retl)
    (mov %lsp %arg_z))

(defun %frame-backlink (p &optional (sg *current-stack-group*))
  (cond ((fake-stack-frame-p p)
         (%fake-stack-frame.next-sp p))
        ((fixnump p)
         (let ((backlink (%%frame-backlink p))
               (fake-frame (symbol-value-in-stack-group '*fake-stack-frames* sg)))
           (loop
             (when (null fake-frame) (return backlink))
             (when (eq backlink (%fake-stack-frame.sp fake-frame))
               (return fake-frame))
             (setq fake-frame (%fake-stack-frame.link fake-frame)))))
        (t (error "~s is not a valid stack frame" p))))

(defsparclapfunction %%frame-backlink ((p %arg_z))
  (check-nargs 1)
  (retl)
    (ld (p sparc::lisp-frame.backlink) %arg_z))

(defun lisp-frame-p (p stack-group)
  (or (fake-stack-frame-p p)
      (locally (declare (fixnum p))
        (let ((next-frame (%frame-backlink p stack-group)))
          (when (fake-stack-frame-p next-frame)
            (setq next-frame (%fake-stack-frame.sp next-frame)))
          (locally (declare (fixnum next-frame))
            (if (bottom-of-stack-p next-frame stack-group)
              (values nil t)
              (values t nil)))))))

(defsparclapfunction %catch-top ((stack-group %arg_z))
  (check-nargs 1)
  (ld (%nfn '*current-stack-group*) %temp0)
  (ld (%temp0 arch::symbol.vcell) %temp0)
  (cmp stack-group %temp0)
  (bne @not-current)
    (nop)

  ; stack-group = *current-stack-group*
  (ref-global %arg_z catch-top)
  (tst %arg_z)
  (be.a @ret)
    (mov %rnil %arg_z)
 @ret
  (retl)
    (nop)
 

@not-current
  (svref stack-group sg.ts-area %imm0)
  (ld (%imm0 arch::area.active) %imm0)
  (retl)
    (add %imm0 (+ 8 arch::fulltag-misc) %arg_z))

(defsparclapfunction %current-vsp ()
  (check-nargs 0)
  (retl)
    (mov %vsp %arg_z))

(defsparclapfunction %current-tsp ()
  (check-nargs 0)
  (retl)
    (mov %tsp %arg_z))

; Same as %address-of, but doesn't cons any bignums
; It also left shift fixnums just like everything else.
(defsparclapfunction %fixnum-address-of ((x %arg_z))
  (check-nargs 1)
  (retl)
    (box-fixnum x %arg_z))


(defsparclapfunction %get-freeptr ()
  (check-nargs 0)
  (retl)
    (mov %freeptr %arg_z))


(defsparclapfunction %%frame-savefn ((p %arg_z))
  (check-nargs 1)
  (retl)
    (ld (p sparc::lisp-frame.savefn) %arg_z))

(defsparclapfunction %frame-savelr ((p %arg_z))
  (check-nargs 1)
  (retl)
    (ld (p sparc::lisp-frame.savelr) %arg_z))

(defsparclapfunction %%frame-savevsp ((p %arg_z))
  (check-nargs 1)
  (retl)
    (ld (p sparc::lisp-frame.savevsp) %arg_z))

(defsparclapfunction %uvector-data-fixnum ((uv %arg_z))
  (check-nargs 1)
  (trap-unless-fulltag= uv arch::fulltag-misc)
  (retl)
    (add uv arch::misc-data-offset %arg_z))




; This'll be a callback
(defun threadentry (&rest args)
  (declare (ignore args))
  (dbg "threadentry: not ready for sparc threads yet"))

; DEFINE-CALLBACK will set this up
(defvar threadentry #'threadentry)
