;;; -*- Mode: Lisp; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of OpenMCL.  
;;;
;;;   OpenMCL is licensed under the terms of the Lisp Lesser GNU Public
;;;   License , known as the LLGPL and distributed with OpenMCL as the
;;;   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
;;;   which is distributed with OpenMCL as the file "LGPL".  Where these
;;;   conflict, the preamble takes precedence.  
;;;
;;;   OpenMCL is referenced in the preamble as the "LIBRARY."
;;;
;;;   The LLGPL is also available online at
;;;   http://opensource.franz.com/preamble.html

;(in-package "CCL")

(eval-when (:compile-toplevel :execute)
  (require "HASHENV" "ccl:xdump;hashenv"))




; This should stay in LAP so that it's fast
; Equivalent to cl:mod when both args are positive fixnums

(defsparclapfunction fast-mod ((number %arg_y) (divisor %arg_z))
  (wry %rzero %rzero)
  ;; Need to wait three cycles after writing to the Y register.
  (nop)
  (nop)
  (nop)
  (udiv number divisor %imm0)
  (umul %imm0 divisor %arg_z)
  (retl)
    (sub number %arg_z %arg_z))


(defsparclapfunction %dfloat-hash ((key %arg_z))
  (ld (key arch::double-float.value) %imm0)
  (ld (key arch::double-float.val-low) %imm1)
  (add %imm0 %imm1 %imm0)
  (retl)
   (box-fixnum %imm0 %arg_z))

(defsparclapfunction %sfloat-hash ((key %arg_z))
  (ld (key arch::single-float.value) %imm0)
  (retl)
   (box-fixnum %imm0 %arg_z))

(defsparclapfunction %macptr-hash ((key %arg_z))
  (ld (key arch::macptr.address) %imm0)
  (sll %imm0 24 %imm1)
  (add %imm1 %imm0 %imm0)
  (retl)
    (andn %imm0 arch::fixnummask %arg_z))

(defsparclapfunction %bignum-hash ((key %arg_z))
  (let ((header %imm3)
        (offset %imm2)
        (ndigits %imm1)
        (immhash %imm0)
	(temp %imm4))
    (mov 0 immhash)
    (mov arch::misc-data-offset offset)
    (getvheader key header)
    (header-size header ndigits)
    (let ((next header))
      @loop
      (deccc ndigits)
      (ld (key offset) next)
      (inc 4 offset)
      (srl immhash 19 temp)
      (sll immhash 13 immhash)
      (or temp immhash immhash)
      (bne @loop)
        (add immhash next immhash))
    (retl)
      (andn immhash arch::fixnummask %arg_z)))

(defsparclapfunction %get-fwdnum ()
  (retl)
  (ref-global %arg_z arch::fwdnum))

(defsparclapfunction %get-gc-count ()
  (retl)
  (ref-global %arg_z arch::gc-count))

; X is ephemeral if it's a cons or vector, the kernel global
; "OLDEST-EPHEMERAL" is non-zero, and X is between OLDEST-EPHEMERAL
; and the freeptr.
(defsparclapfunction ephemeral-p ((x %arg_z))
  (extract-fulltag x %imm0)
  (cmp %imm0 arch::fulltag-cons)
  (be @maybe)
    (cmp %imm0 arch::fulltag-misc)
  (bne @no)
    (ref-global %imm1 oldest-ephemeral)
  @maybe
  (tst %imm1)
    (be @no)
  (cmp x %imm1)
  (blu @no)
    (cmp x %freeptr)
  (bgu @no)
    (nop)
  (retl)
    (add %rnil arch::t-offset %arg_z)
  @no
  (retl)
    (mov %rnil %arg_z))



; Setting a key in a hash-table vector needs to 
; ensure that the vector header gets memoized as well

(defsparclapfunction %set-hash-table-vector-key ((vector %arg_x) (index %arg_y) (value %arg_z))
  (push vector %memo)
  (add index arch::misc-data-offset %imm0)
  (add vector %imm0 %loc-g)
  (push %loc-g %memo)
  (retl)
   (st %arg_z (%loc-g)))


; end of sparc-hash.lisp
