;;;-*-Mode: LISP; Package: CCL -*-
;;;
;;;   Copyright (C) 2002 Clozure Associates
;;;   This file is part of OpenMCL.  
;;;
;;;   OpenMCL is licensed under the terms of the Lisp Lesser GNU Public
;;;   License , known as the LLGPL and distributed with OpenMCL as the
;;;   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
;;;   which is distributed with OpenMCL as the file "LGPL".  Where these
;;;   conflict, the preamble takes precedence.  
;;;
;;;   OpenMCL is referenced in the preamble as the "LIBRARY."
;;;
;;;   The LLGPL is also available online at
;;;   http://opensource.franz.com/preamble.html

(in-package "CCL")			; for now.

(eval-when (:compile-toplevel :execute)
  (use-interface-dir :cocoa))

(eval-when (:compile-toplevel :load-toplevel :execute)
  (require "APPLE-OBJC"))



(eval-when (:compile-toplevel :execute)
  (setq *readtable* *objc-readtable*))
  


;;; Creating an "autorelease pool" soon after program startup is a
;;; common idiom; doing so helps the runtime system keep track of
;;; reference-counted objects.
(defun create-autorelease-pool ()
  [[(@class "NSAutoreleasePool") "alloc"] "init"])


(defun init-cocoa-application (&optional (bundle-path *default-bundle-path*))
  (let* ((pool (create-autorelease-pool))
	 (bundle (open-main-bundle bundle-path))
	 (dict [bundle "infoDictionary"])
	 (classname [dict "objectForKey:" :id (@"NSPrincipalClass")])
	 (mainnibname [dict "objectForKey:" :id (@"NSMainNibFile")]))
    (if (%null-ptr-p classname)
      (error "problems loading bundle: can't determine class name"))
    (if (%null-ptr-p mainnibname)
      (error "problems loading bundle: can't determine main nib name"))
    (let* ((appclass (external-call "_NSClassFromString"
				    :address classname
				    :address))
	   (app [ appclass "sharedApplication"]))
      [(@class "NSBundle") "loadNibNamed:owner:"
       :address mainnibname
       :address app]
      [pool "release"]
      app)))


(defun trace-dps-events (flag)
  (external-call "__DPSSetEventsTraced"
		 :unsigned-byte (if flag #$YES #$NO)
		 :void))


(def-objc-class "lispapplication" "NSApplication")

(defloadvar *distant-past* [(@class "NSDate") "distantPast"])
(defloadvar *distant-future* [(@class "NSDate") "distantFuture"])
(defparameter *cocoa-event-poll-delay* 0.05d0)

(define-objc-method  ("nextEventMatchingMask:untilDate:inMode:dequeue:"
		      "lispapplication")
    (:unsigned mask :id date :id mode :<BOOL> dequeue :id)
  (let* ((date-not-in-future
	  (<= (the double-float
		[date "timeIntervalSinceNow" :double-float])
	      0.0d0))
	 (soon [(@class "NSDate") "dateWithTimeIntervalSinceNow:"
		:double-float 0.02d0]))
    (rlet ((eventptr (* t)))
      (flet ((cocoa-event-poll ()
	       (progn
		 (%setf-macptr
		  eventptr
		  [:super "nextEventMatchingMask:untilDate:inMode:dequeue:"
			  :unsigned mask
			  :id soon
			  :id mode
			  :<BOOL> dequeue])
		 (or (not (%null-ptr-p eventptr))
		     date-not-in-future))))
	(declare (dynamic-extent #'cocoa-event-poll))
	(process-wait "Cocoa Event Poll" #'cocoa-event-poll))
      eventptr)))



(defloadvar *NSApp* nil )
(defloadvar *default-ns-application-proxy-class-name*
    "lispapplicationdelegate")

(defun enable-foreground (&optional bundle-string)
  (%stack-block ((psn 8))
    (external-call "_GetCurrentProcess" :address psn)
    (when bundle-string
      (with-cstrs ((name (car (last (pathname-directory bundle-string)))))
	(external-call "_CPSSetProcessName" :address psn :address name)))
    (external-call "_CPSEnableForegroundOperation" :address psn)))

(defun start-cocoa-application (&key
				(bundle-path *default-bundle-path*)
				(application-proxy-class-name
				 *default-ns-application-proxy-class-name*)
				(event-process t))
  (or *NSApp* (setq *NSApp* (init-cocoa-application bundle-path)))
  (enable-foreground bundle-path)
  [*NSApp* "setApplicationIconImage:"
	   :id [(@class "NSImage") "imageNamed:" :id #@"NSApplicationIcon"]]
  (when application-proxy-class-name
    (let* ((classptr (%objc-class-classptr
		      (load-objc-class-descriptor application-proxy-class-name))))
      [*NSApp* "setDelegate:" :address [[classptr "alloc"]
				  "init"] :void]))
  (flet ((run () [*NSApp* "run"]))
    (if event-process
      (process-run-function
       (list :name "Cocoa Event Loop" :stack-size (ash 1 18))
       #'run)
      (run))))
