/*
 * Copyright (c) 2016, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

#ifndef SHARE_GC_Z_ZOOP_INLINE_HPP
#define SHARE_GC_Z_ZOOP_INLINE_HPP

#include "gc/z/zAddress.inline.hpp"
#include "gc/z/zOop.hpp"
#include "oops/oopsHierarchy.hpp"

inline oop ZOop::to_oop(uintptr_t value) {
  return cast_to_oop(value);
}

inline uintptr_t ZOop::to_address(oop o) {
  return cast_from_oop<uintptr_t>(o);
}

inline bool ZOop::is_good(oop o) {
  return ZAddress::is_good(to_address(o));
}

inline bool ZOop::is_finalizable_good(oop o) {
  return ZAddress::is_finalizable_good(to_address(o));
}

inline oop ZOop::good(oop o) {
  return to_oop(ZAddress::good(to_address(o)));
}

#endif // SHARE_GC_Z_ZOOP_INLINE_HPP
