/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _REGION_WRAP_P_H_
#define _REGION_WRAP_P_H_

#include <list>

#include "GTLCore/Region.h"
#include "GTLCore/wrappers/Allocate.h"
#include "GTLCore/wrappers/ArrayWrap.h"

//---------------------- WARNING ----------------------//
// Whenever the following structure is edited,         //
// it's llvm declaration must be changed too in        //
// Wrapper::createRegionType !                         //
//---------------------- WARNING ----------------------//
struct RegionWrap {
  STRUCT_HEADER
  float x, y, width, height;
};

extern "C" {
  float region_wrap_left( RegionWrap* self );
  float region_wrap_top( RegionWrap* self );
  float region_wrap_right( RegionWrap* self );
  float region_wrap_bottom( RegionWrap* self );
  
  void region_wrap_intersect( RegionWrap* self, const RegionWrap* reg );
  void region_wrap_union( RegionWrap* self, const RegionWrap* reg );
  
  void region_wrap_outset( RegionWrap* self, float amount );
  void region_wrap_inset( RegionWrap* self, float amount );
}


inline RegionWrap* regionToRegionWrap( const GTLCore::Region& region )
{
  RegionWrap* rw = gtlAllocate<RegionWrap>( );
  rw->x = region.x();
  rw->y = region.y();
  rw->width = region.width();
  rw->height = region.height();
  return rw;
}

inline GTLCore::Region regionWrapToRegion( RegionWrap * rwrap)
{
 return GTLCore::Region( (int) rwrap->x, (int) rwrap->y, (int) rwrap->width, (int) rwrap->height );
}

inline ArrayWrap* regionListToArrayWrap( const std::list<GTLCore::Region> & regions)
{
  ArrayWrap* array = gtlAllocateArray<RegionWrap*>( regions.size() );
  RegionWrap** wrapData = reinterpret_cast<RegionWrap**>(array->data);
  for( std::list<GTLCore::Region>::const_iterator it = regions.begin(); it != regions.end(); ++it, ++wrapData)
  {
    *wrapData = regionToRegionWrap( *it );
  }
  return array;
}

#endif
