/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _PIXEL_WRAP_P_H_
#define _PIXEL_WRAP_P_H_

#include "GTLCore/wrappers/StructWrap.h"

//---------------------- WARNING ----------------------//
// Whenever the following structure is edited,         //
// it's llvm declaration must be changed too in        //
// Wrapper::createPixelType !                          //
//---------------------- WARNING ----------------------//
struct PixelWrap {
  STRUCT_HEADER
  void* data;
  void* coord;
  enum PixelIndexes {
    INDEX_DATA = 0,
    INDEX_COORD = 1
  };
  enum PixelPoses {
    POS_DATA = STRUCT_FIRST_ELEMENT + INDEX_DATA,
    POS_COORD = STRUCT_FIRST_ELEMENT + INDEX_COORD
  };
};

#endif
