/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENSHIVA_PIXEL_VISITOR_H_
#define _OPENSHIVA_PIXEL_VISITOR_H_

class PixelVisitorFactory;

#include "GTLCore/Visitor_p.h"

namespace OpenShiva {
  /**
   * @internal
   * This is a visitor specific to the pixels type of OpenShiva, it will return the
   * vector.
   *
   * @ingroup OpenShiva
   */
  class PixelVisitor : public GTLCore::Visitor {
      friend class ::PixelVisitorFactory;
      PixelVisitor();
    public:
      static const Visitor* instance();
      virtual ~PixelVisitor();
      virtual const GTLCore::Type* pointerToIndexType( const GTLCore::Type* _type ) const;
      virtual llvm::Value* pointerToIndex( GTLCore::GenerationContext& _generationContext, llvm::BasicBlock* _currentBlock, llvm::Value* _pointer, const GTLCore::Type* _type, llvm::Value* _index) const;
      virtual GTLCore::ExpressionResult get(GTLCore::GenerationContext& _generationContext, llvm::BasicBlock* currentBlock, llvm::Value* pointer, const GTLCore::Type* _pointerType) const;
      virtual llvm::BasicBlock* set(GTLCore::GenerationContext& _generationContext, llvm::BasicBlock* _currentBlock, llvm::Value* _pointer, const GTLCore::Type* _pointerType, llvm::Value* _value, const GTLCore::Type* _valueType, bool _allocatedInMemory) const;
      virtual llvm::BasicBlock* initialise(GTLCore::GenerationContext& _generationContext, llvm::BasicBlock* _currentBlock, llvm::Value* _pointer, const GTLCore::Type* _pointerType, const std::list< llvm::Value*>& _sizes, bool _allocatedInMemory) const;
      virtual llvm::BasicBlock* cleanUp( GTLCore::GenerationContext& _generationContext, llvm::BasicBlock* _currentBlock, llvm::Value* _pointer, const GTLCore::Type* _pointerType, llvm::Value* _donttouch, bool _allocatedInMemory, bool _ignoreCount, bool _deletePointer ) const;
      virtual llvm::BasicBlock* mark( GTLCore::GenerationContext& _generationContext, llvm::BasicBlock* _currentBlock, llvm::Value* _pointer, const GTLCore::Type* _pointerType, llvm::Value* increment ) const;
      virtual llvm::Constant* createStaticVariable( llvm::Module* _module, const GTLCore::Type* type, const std::list< int>& _sizes ) const;
  };
  
}

#endif
