/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "Metadata.h"

#include "GTLCore/Macros_p.h"
#include "GTLCore/Value.h"
#include "GTLCore/Metadata/Group.h"
#include "GTLCore/Metadata/ParameterEntry.h"
#include "GTLCore/Metadata/ValueEntry.h"

#include "Debug.h"
#include "Version.h"

using namespace OpenShiva;
using namespace GTLCore::Metadata;

struct Metadata::Private {
  int version;
  const Group* infoList;
  const Group* parametersList;
};

inline std::list<const Entry*> createList( const Entry* _version, const Group* _infoList, const Group* _parametersList )
{
  std::list<const Entry*> list;
  if( _version )
  {
    list.push_back( _version );
  }
  if( _infoList )
  {
    list.push_back( _infoList );
  }
  if( _parametersList )
  {
    list.push_back( _parametersList );
  }
  return list;
}

Metadata::Metadata( const Entry* _version, const Group* _infoList, const Group* _parametersList ) : Group( "Kernel", createList( _version, _infoList, _parametersList ) ), d(new Private)
{
  d->version = LanguageVersion();
  if( _version )
  {
    const ValueEntry* te = _version->asValueEntry();
    SHIVA_ASSERT( te );
    d->version = te->value().asInt32();
  }
  d->infoList = _infoList;
  d->parametersList = _parametersList;
}

Metadata::~Metadata()
{
  delete d;
}

int Metadata::version() const
{
  return d->version;
}
const Group* Metadata::infos() const
{
  return d->infoList;
}

const Group* Metadata::parameters() const
{
  return d->parametersList;
}

const GTLCore::Metadata::ParameterEntry* recursiveFoundParameter(const GTLCore::String& _name, const Group* _group)
{
  foreach(const Entry* entry, _group->entries())
  {
    if(entry->asParameterEntry())
    {
      if(entry->name() == _name)
      {
        return entry->asParameterEntry();
      }
    } else if(entry->asGroup())
    {
      const GTLCore::Metadata::ParameterEntry* pe = recursiveFoundParameter(_name, entry->asGroup());
      if(pe) return pe;
    }
  }
  return 0;
}

const GTLCore::Metadata::ParameterEntry* Metadata::parameter(const GTLCore::String& _name) const
{
  if(not d->parametersList) return 0;
  return recursiveFoundParameter( _name, d->parametersList );
}
