/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "GTLCore/wrappers/Allocate.h"
#include "GTLCore/wrappers/StructWrap.h"

/**
 * Internal mapping of a GTL array
 * @ingroup GTLCore
 * @internal
 */
struct ArrayWrap {
  STRUCT_HEADER
  int size;
  void* data;
  enum ArrayIndexes {
    POS_SIZE = STRUCT_FIRST_ELEMENT,
    POS_DATA = STRUCT_FIRST_ELEMENT + 1,
  };
};

template<class _T_>
inline ArrayWrap* gtlAllocateArray( int _size )
{
  ArrayWrap* arrayWrap = gtlAllocate<ArrayWrap>( );
  arrayWrap->size = _size;
  arrayWrap->data = gtlAllocate<_T_>( _size );
  return arrayWrap;
}

inline void gtlFreeArray( ArrayWrap* aw )
{
  gtlFree( aw->data );
  gtlFree( aw );
}

template< typename _T_>
inline void gtlFreeAllArray( ArrayWrap* aw )
{
  _T_* elts = reinterpret_cast<_T_*>(aw->data);
  for( int i = 0; i < aw->size; ++i)
  {
    gtlFree( elts[i] );
  }
  gtlFree( aw->data );
  gtlFree( aw );
}
