/*
 *  Copyright (c) 2007-2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "ScopedName.h"

#include "String.h"

using namespace GTLCore;

struct ScopedName::Private {
  String nameSpace;
  String name;
};

ScopedName::ScopedName() : d(new Private)
{
}
ScopedName::ScopedName( const String& _nameSpace, const String& _name) : d(new Private)
{
   d->nameSpace = _nameSpace;
   d->name = _name;
}

ScopedName::ScopedName( const ScopedName& rhs) : d(new Private(*rhs.d))
{
}

ScopedName::~ScopedName()
{
  delete d;
}

ScopedName& ScopedName::operator=(const ScopedName& rhs)
{
  *d = *rhs.d;
  return *this;
}

String ScopedName::toString() const {
  if(d->nameSpace != "")
    return d->nameSpace + "::" + d->name;
  else
    return d->name;
}
bool ScopedName::empty() const {
  return d->name == "";
}
bool ScopedName::operator<( const ScopedName& sn ) const
{
  return d->nameSpace < sn.d->nameSpace or ( d->nameSpace == sn.d->nameSpace and d->name < sn.d->name);
}
bool ScopedName::operator==( const ScopedName& sn ) const
{
  return d->nameSpace == sn.d->nameSpace and d->name == sn.d->name;
}

const String& ScopedName::name() const
{
  return d->name;
}

const String& ScopedName::nameSpace() const
{
  return d->nameSpace;
}
