/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "Region.h"

#include "Utils_p.h"

using namespace GTLCore;

Region::Region() : m_x(0), m_y(0), m_width(0), m_height(0)
{
}

Region::Region( int _x, int _y, int _width, int _height )
  : m_x(_x), m_y(_y), m_width(_width), m_height(_height)
{
}
Region::~Region()
{
}

int Region::x() const
{
  return m_x;
}

int Region::y() const
{
  return m_y;
}

int Region::width() const
{
  return m_width;
}

void Region::setWidth( int _width )
{
  m_width = _width;
}

int Region::height() const
{
  return m_height;
}

int Region::left() const
{
  return m_x;
}

int Region::right() const
{
  return m_y + m_width;
}

int Region::bottom() const
{
  return m_y + m_height;
}

int Region::top() const
{
  return m_y;
}

void Region::setHeight( int _height )
{
  m_height = _height;
}

bool Region::operator!=( const Region& _region ) const
{
  return x() != _region.x() or y() != _region.y() or width() != _region.width() or height() != _region.height();
}

GTLCore::Region& Region::operator+=( const Region& _region )
{
  return (*this = this->united( _region ) );
}

GTLCore::Region Region::united( const Region& _region ) const
{
  int right = max( _region.right(), this->right() );
  int bottom = max( _region.bottom(), this->bottom() );
  int left = min( _region.left(), this->left() );
  int top = min( _region.top(), this->top() );
  
  return GTLCore::Region(  left, top, right - left, bottom - top );
}
