/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "GenerationContext_p.h"

#include "ModuleData_p.h"
#include "Debug.h"

#include "AST/Statement.h"

using namespace GTLCore;

GenerationContext::GenerationContext( GTLCore::CodeGenerator* _codeGenerator,
                    llvm::Function* _llvmFunction, Function* _function, ModuleData* _module )
        : m_codeGenerator(_codeGenerator), m_llvmFunction(_llvmFunction), m_function(_function), m_module( _module)
{
}

GTLCore::CodeGenerator* GenerationContext::codeGenerator()
{
  return m_codeGenerator;
}

llvm::Function* GenerationContext::llvmFunction()
{
  return m_llvmFunction;
}

Function* GenerationContext::function()
{
  return m_function;
}

llvm::Module* GenerationContext::llvmModule()
{
  if( not m_module ) return 0;
  GTL_ASSERT(m_module);
  return m_module->llvmModule();
}

ModuleData* GenerationContext::module()
{
  return m_module;
}

void GenerationContext::appendDelayedStatement( AST::Statement* _statement )
{
  m_delayedStatements.push_back( _statement );
}

llvm::BasicBlock* GenerationContext::flushDelayedStatement(llvm::BasicBlock* _bb)
{
  for( std::list< AST::Statement* >::iterator it = m_delayedStatements.begin();
       it != m_delayedStatements.end(); ++it)
  {
    _bb = (*it)->generateStatement( *this, _bb );
    delete *it;
  }
  m_delayedStatements.clear();
  return _bb;
}
