/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */


#include "Array.h"

#include <string.h>

#include "Debug.h"

using namespace GTLCore;

struct Array::Private {
  Private() : data(0), size(0) {}
  char * data;
  int size;
};

Array::Array() : d(new Private)
{
}

Array::Array(const Array& rhs) : d(new Private)
{
  *this = rhs;
}

Array& Array::operator=(const Array& rhs)
{
  if( rhs.d->size != d->size)
  {
    resize( rhs.d->size );
  }
  GTL_ASSERT(d->size == rhs.d->size);
  memcpy(d->data, rhs.d->data, d->size);
  return *this;
}

Array::Array(int size) : d(new Private)
{
  resize(size);
}
Array::~Array()
{
  delete[] d->data;
  delete d;
}

void Array::resize(int _size)
{
  delete[] d->data;
  d->size = _size;
  d->data = new char[d->size];
}

char * Array::rawData()
{
  return d->data;
}

const char * Array::rawData() const
{
  return d->data;
}

int Array::size() const
{
  return d->size;
}
