/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "UnaryExpression.h"

#include <GTLCore/CodeGenerator_p.h>
#include <GTLCore/Type.h>
#include <GTLCore/ExpressionResult_p.h>
#include <GTLCore/Debug.h>

using namespace GTLCore::AST;

UnaryExpression::~UnaryExpression()
{
  delete m_rhs;
}

void UnaryExpression::markAsReturnExpression()
{
  m_rhs->markAsReturnExpression();
}

GTLCore::ExpressionResult MinusUnaryExpression::generateValue( GenerationContext& _gc,  llvm::BasicBlock* bb ) const
{
  return _gc.codeGenerator()->createMinusExpression( bb, rightHandSide()->generateValue( _gc, bb), rightHandSide()->type()  );
}

GTLCore::ExpressionResult MinusMinusUnaryExpression::generateValue( GenerationContext& _gc,  llvm::BasicBlock* bb ) const
{
  GTL_ASSERT( m_rhs );
  _gc.codeGenerator()->createDecrementExpression( bb, m_rhs->pointer( _gc, bb) );
  return rightHandSide()->generateValue( _gc, bb);
}

GTLCore::ExpressionResult PlusPlusUnaryExpression::generateValue( GenerationContext& _gc,  llvm::BasicBlock* bb ) const
{
  GTL_ASSERT( m_rhs );
  _gc.codeGenerator()->createIncrementExpression( bb, m_rhs->pointer( _gc, bb) );
  return rightHandSide()->generateValue( _gc, bb);
}

const GTLCore::Type* NotUnaryExpression::type() const
{
  return Type::Boolean;
}

GTLCore::ExpressionResult NotUnaryExpression::generateValue( GenerationContext& _gc,  llvm::BasicBlock* bb ) const
{
  return _gc.codeGenerator()->createNotExpression( bb, rightHandSide()->generateValue( _gc, bb), rightHandSide()->type() );
}

GTLCore::ExpressionResult TildeUnaryExpression::generateValue( GenerationContext& _gc,  llvm::BasicBlock* bb ) const
{
  return _gc.codeGenerator()->createTildeExpression( bb, rightHandSide()->generateValue( _gc, bb), rightHandSide()->type() );
}
