/*
 *  Copyright (c) 2007 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENCTL_OPENCTL_H_
#define _OPENCTL_OPENCTL_H_

#include <GTLCore/Version.h>

#define OPENCTL_VERSION_MAJOR GTL_CORE_VERSION_MAJOR
#define OPENCTL_VERSION_MINOR GTL_CORE_VERSION_MINOR
#define OPENCTL_VERSION_REVISION GTL_CORE_VERSION_REVISION

namespace OpenCTL {
  GTLCore::String LibraryShortName();
  GTLCore::String LibraryName();
  GTLCore::String LibraryCopyright();
  GTLCore::String LibraryLicence();
  GTLCore::String LibraryVersionString();;
  int LibraryVersionMajor();
  int LibraryVersionMinor();
  int LibraryVersionRevision();
  /**
   * Give the latest version of the CTL language supported by this library.
   */
  int LanguageVersion();
}

#endif
