/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "GTLCore/String.h"

#include <iostream>
#include <cstdarg>

#undef assert

extern "C" {

void assert( bool test)
{
  if(not test)
  {
    throw GTLCore::String("Assert");
  }
}

bool isnan_f (float x)
{
  union {float f; unsigned int i;} u;
  u.f = x;
  return u.i == 0x7fffffff;
}
bool isnan_h (float x)
{
  union {float f; unsigned int i;} u;
  u.f = x;
  return u.i == 0x7fffffff;
}


void print(int nb, ...)
{
//   std::cout << nb << " : ";
  va_list argp;
  va_start(argp, nb);
  for( int i = 0; i < nb; ++i)
  {
    int type = va_arg(argp, int);
//     std::cout << type << " ";
    switch(type)
    {
      case 0:
      {
        std::cout << va_arg(argp, int) << " ";
      }
        break;
      case 1:
      {
        std::cout << va_arg(argp, double) << " ";
      }
        break;
      case 2:
      {
        if( va_arg(argp, int))
          std::cout << "true ";
        else
          std::cout << "false ";
      }
        break;
      case 3:
      {
        std::cout << va_arg(argp, char*) << " ";
        break;
      }
      default:
        std::cout << "Unknown type (" << type << ")";
    }
  }
  std::cout << std::endl;
  va_end(argp);
}

}
