/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright (C) 2004-2010 OpenCFD Ltd.
     \\/     M anipulation  |
-------------------------------------------------------------------------------
                            | Copyright (C) 2011-2012 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::triSurfaceMeshPointSet

Description
    A sampleSet from all points of a triSurfaceMesh.

    For a dictionary specification:
    \table
        Property | Description                             | Required | Default
        type     | triSurfaceMeshPointSet                  | yes      |
        axis     | x, y, z, xyz, distance                  | yes      |
        surface  | The surface name                        | yes      |
    \endtable

SourceFiles
    triSurfaceMeshPointSet.C

\*---------------------------------------------------------------------------*/

#ifndef triSurfaceMeshPointSet_H
#define triSurfaceMeshPointSet_H

#include "sampledSet.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                   Class triSurfaceMeshPointSet Declaration
\*---------------------------------------------------------------------------*/

class triSurfaceMeshPointSet
:
    public sampledSet
{
    // Private data

        //- Name of triSurfaceMesh
        const word surface_;

        //- Sampling points
        List<point> sampleCoords_;


    // Private Member Functions

        //- Samples all points in sampleCoords.
        void calcSamples
        (
            DynamicList<point>& samplingPts,
            DynamicList<label>& samplingCells,
            DynamicList<label>& samplingFaces,
            DynamicList<label>& samplingSegments,
            DynamicList<scalar>& samplingCurveDist
        ) const;

        //- Uses calcSamples to obtain samples. Copies them into *this.
        void genSamples();


public:

    //- Runtime type information
    TypeName("triSurfaceMeshPointSet");


    // Constructors

        //- Construct from dictionary
        triSurfaceMeshPointSet
        (
            const word& name,
            const polyMesh& mesh,
            const meshSearch& searchEngine,
            const dictionary& dict
        );


    //- Destructor
    virtual ~triSurfaceMeshPointSet() = default;


    // Member Functions

        //- Get reference point
        virtual point getRefPoint(const List<point>& pts) const;
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
