#
# hminfo.sql site plugin definition
#

#
# Cleanup
#
DELETE FROM s_site_plugin WHERE site_type = 'hminfo';
DELETE FROM s_site_plugin_conf WHERE site_type = 'hminfo';
DELETE FROM s_site_plugin_input_field WHERE site_type = 'hminfo';
DELETE FROM s_site_plugin_link WHERE site_type = 'hminfo';
DELETE FROM s_site_plugin_s_attribute_type_map WHERE site_type = 'hminfo';
DELETE FROM s_site_plugin_s_attribute_type_lookup_map WHERE site_type = 'hminfo';

INSERT INTO s_site_plugin (site_type, classname, order_no, title, image, description, external_url, items_per_page, more_info_url)
VALUES('hminfo', 'hminfo', 6, 'HometheaterInfo.com', 'hminfo.gif', 'HometheaterInfo.com Region 1 DVD Listing', 'http://www.hometheaterinfo.com', 20, '');

#
# Input Fields
#	
INSERT INTO s_site_plugin_input_field (site_type, field, order_no, description, prompt, field_type, default_value, refresh_mask)
VALUES('hminfo', 'upc_id', 1, '', 'UPC Number', 'text', '', '{upc_id}');

INSERT INTO s_site_plugin_input_field (site_type, field, order_no, description, prompt, field_type, default_value, refresh_mask)
VALUES('hminfo', 'title', 2, '', 'Title Search', 'text', '', '{title}');

INSERT INTO s_site_plugin_input_field (site_type, field, order_no, description, prompt, field_type, default_value, refresh_mask)
VALUES('hminfo', 'hmi_id', 3, '', 'HometheaterInfo ID', 'text', '', '{hmi_id}');

#
# Configuration
#
INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('hminfo', 'datetime_mask', 'Format DVD and Original Release Dates', '0', 'DD/MM/YYYY');

#
# site variable to s_attribute_type mapping
#
INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('hminfo', 'title', '*', '*', 'ALT_TITLE');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('hminfo', 'title', '*', '*', 'S_TITLE');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('hminfo', 'genre', '*', '*', 'MOVIEGENRE');

#
# Lookup mappings
# 
INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'hminfo', 'AGE_RATING', 'UR', 'X' );

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'hminfo', 'AGE_RATING', 'PG-13', 'PG' );

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'hminfo', 'AGE_RATING', 'R', 'MA' );

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'hminfo', 'AGE_RATING', 'NC-17', 'MA' );

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'hminfo', 'AGE_RATING', 'X', 'R' );

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'hminfo', 'AUDIO_LANG', '1.0', 'ENGLISH' );

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'hminfo', 'AUDIO_LANG', '2.0', 'ENGLISH_2.0' );

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'hminfo', 'AUDIO_LANG', '4.0', 'ENGLISH_4.0' );

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'hminfo', 'AUDIO_LANG', '5.0', 'ENGLISH_5.0' );

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'hminfo', 'AUDIO_LANG', '5.1', 'ENGLISH_5.1' );

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'hminfo', 'AUDIO_LANG', 'DTS', 'ENGLISH_DTS' );

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'hminfo', 'AUDIO_LANG', '6.1 ES', 'ENGLISH_6.1_DTS_ES' );

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'hminfo', 'AUDIO_LANG', '6.1 EX', 'ENGLISH_6.1_EX' );

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'hminfo', 'AUDIO_LANG', 'SUR', 'ENGLISH_SR' );

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'hminfo', 'MOVIEGENRE', 'SciFi', 'ScienceFiction' );

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'hminfo', 'MOVIEGENRE', 'LateNight', 'Adult' );

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'hminfo', 'MOVIEGENRE', 'Family', 'Other' );

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'hminfo', 'MOVIEGENRE', 'SpecialInterest', 'Other' );

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'hminfo', 'MOVIEGENRE', 'Foreign', 'Other' );

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'hminfo', 'MOVIEGENRE', 'TVClassics', 'Other' );

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'hminfo', 'MOVIEGENRE', 'Anime', 'Animation' );

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'hminfo', 'MOVIEGENRE', 'Opera', 'Music' );

####################################################################################################
# Item Type / Attribute Type relationships
####################################################################################################

INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'HMI_ID', 'HomeTheaterInfo ID', 'HMI ID', 'hidden', 'hidden', NULL, 'hminfo');
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'UPC_ID', 'UPC ID', 'UPC ID', 'hidden', 'hidden', NULL, NULL);

INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DVD', 'HMI_ID', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DVD', 'UPC_ID', '0', NULL, NULL);

#
# DVD Format Attribute Type - but you will have to add to any item type's you want to use it with.
#
INSERT INTO s_attribute_type ( s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type ) 
VALUES ( 'DVD_FORMAT', 'Format of DVD', 'Type','single_select(%display%)', 'display(%display%, list-link)', NULL, NULL );

#
# Attribute Type Lookup (DVD_FORMAT)
#
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DVD_FORMAT', '1', 'LBX', 'Letterbox', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DVD_FORMAT', '2', '4:3', 'Normal TV', '', ''); 
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DVD_FORMAT', '3', '16:9', 'Anamorphic', '', '');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DVD_FORMAT', '3', 'P&S', 'Pan and Scan', '', '');

#
# Create HomeTheatreInfo Table
#
CREATE TABLE site_hminfo (
	id 		INTEGER(20) UNSIGNED NOT NULL,
	dvd_title 	VARCHAR(128),
	studio		VARCHAR(30),
	released	DATE,
	status 		VARCHAR(15),
	sound 		VARCHAR(20),
	versions	VARCHAR(20),
	price		DECIMAL(12,2),
	rating		VARCHAR(5),
	year		VARCHAR(5),
	genre		VARCHAR(20),
	aspect		VARCHAR(6),
	upc		VARCHAR(15),
	dvd_releasedate DATE,
	timestamp	DATE,
	update_on	TIMESTAMP,
	PRIMARY KEY ( id )
) TYPE=MyISAM COMMENT='Home Theatre Info Lookup Table';
