<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./include/theme.php");
include_once("./include/language.php");

include_once("./functions/database.php");
include_once("./functions/auth.php");
include_once("./functions/logging.php");
include_once("./functions/datetime.php");
include_once("./functions/widgets.php");
include_once("./functions/http.php");
include_once("./functions/borrowed_item.php");
include_once("./functions/item.php");
include_once("./functions/review.php");
include_once("./functions/listutils.php");
include_once("./functions/sortutils.php");
include_once("./functions/HTML_Listing.class.inc");

/**
	This function will get the next $borrowed_item_r/$item_r record
	based on whether we are dealing with a mysql resultset or a
	php array.

	Do not call this function once it returns FALSE.
 
	We need to pass the array 'pass-by-reference' so that the
	next operations affect the original array and not a copy!
*/
function next_record($result, &$item_reservation_rs)
{
	if(is_not_empty_array($item_reservation_rs))
	{
		// Ignore beyond end of array error.
		list(,$item_reservation_r) = @each($item_reservation_rs);
		if(is_not_empty_array($item_reservation_r))
		{
			// Iterate the array for next time
			return $item_reservation_r;
		}
		else
			return FALSE;
	}
	else //ignore any error.
	{
		return @mysql_fetch_array($result, MYSQL_ASSOC);
	}
}

/**
	This does a simple sort of the reserve basket / admin_checkout arrays.  There is no
	reference to any other column in the sort order, only the primary one.

	Only supports sorting by:
		title,s_item_type,owner 
*/
function sort_item_reservation_rs(&$item_reservation_rs, $order_by, $sortorder)
{
	// 'create_function' was added in php 4.0.1.  This will allow OpenDb to
	// function adequately in php 4.0.0.  The data in the Reserve Basket will
	// ignore requests to sort in this case.
	if(function_exists('create_function'))
	{
		if($order_by == 's_item_type')
			$order_by_clause = "s_item_type $sortorder, title $sortorder, instance_no ASC, owner_id $sortorder";
		else if($order_by == 'title')
			$order_by_clause = "title $sortorder, instance_no ASC, type $sortorder, owner_id $sortorder";
		else if($order_by == 'owner')
			$order_by_clause = "owner_id $sortorder, title $sortorder, instance_no ASC, type $sortorder";
	
		usort($item_reservation_rs, create_function('$a,$b', get_usort_function($order_by_clause)));
	}		
}

if($CONFIG_VARS['site.enable']!==FALSE)
{
	session_start();
	if(is_opendb_valid_session())
	{
		if($CONFIG_VARS['borrow.enable']!==FALSE)
		{
			if (is_user_allowed_to_borrow($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']) ) // Only borrow users allowed
			{
				if($HTTP_VARS['mode'] == 'printable')
				{
					switch($HTTP_VARS['content_type'])
					{
						//case 'PDF':
						//	break;
						default:
							$listingObject =& new HTML_Listing($PHP_SELF, $HTTP_VARS, $HTTP_VARS['mode']);
					}
				}
				else
				{
					$listingObject =& new HTML_Listing($PHP_SELF, $HTTP_VARS, $HTTP_VARS['mode']);
				}
				
				$show_listings=TRUE;
				
				$listingObject->setNoRowsMessage($LANG_VARS['no_records_found']);
	
				if($HTTP_VARS['op'] == 'my_borrowed')//all titles that the person has actually borrowed from others.
				{
					$page_title = $LANG_VARS['my_borrowed_items'];
					if(is_numeric($listingObject->getItemsPerPage()))
					{
						$listingObject->setTotalItems(fetch_my_borrowed_item_cnt($HTTP_SESSION_VARS['user_id']));
						if($listingObject->getTotalItemCount()>0)
						{
							$result = fetch_my_borrowed_item_rs(
												$HTTP_SESSION_VARS['user_id'], 
												$listingObject->getCurrentOrderBy(), 
												$listingObject->getCurrentSortOrder(),
												$listingObject->getStartIndex(),
												$listingObject->getItemsPerPage());
						}
					}
					else
					{
						$result = fetch_my_borrowed_item_rs(
												$HTTP_SESSION_VARS['user_id'], 
												$listingObject->getCurrentOrderBy(), 
												$listingObject->getCurrentSortOrder());
					}
				}
				else if($HTTP_VARS['op'] == 'all_borrowed' && $CONFIG_VARS['borrow.list_all_borrowed']!==FALSE)
				{
					$page_title = $LANG_VARS['items_borrowed'];
					
					if(is_numeric($listingObject->getItemsPerPage()))
					{
						$listingObject->setTotalItems(fetch_all_borrowed_item_cnt());
						if($listingObject->getTotalItemCount()>0)
						{
							$result = fetch_all_borrowed_item_rs(
											$listingObject->getCurrentOrderBy(), 
											$listingObject->getCurrentSortOrder(),
											$listingObject->getStartIndex(),
											$listingObject->getItemsPerPage());
						}
					}
					else
					{
						$result = fetch_all_borrowed_item_rs(
											$listingObject->getCurrentOrderBy(), 
											$listingObject->getCurrentSortOrder());
					}
				}
				else if($HTTP_VARS['op'] == 'all_reserved' && $CONFIG_VARS['borrow.list_all_reserved']!==FALSE)
				{
					$page_title = $LANG_VARS['items_reserved'];
					if(is_numeric($listingObject->getItemsPerPage()))
					{
						$listingObject->setTotalItems(fetch_all_reserved_item_cnt());
						if($listingObject->getTotalItemCount()>0)
						{
							$result = fetch_all_reserved_item_rs(
											$listingObject->getCurrentOrderBy(), 
											$listingObject->getCurrentSortOrder(),
											$listingObject->getStartIndex(),
											$listingObject->getItemsPerPage());
						}
					}
					else
					{
						$result = fetch_all_reserved_item_rs(
											$listingObject->getCurrentOrderBy(), 
											$listingObject->getCurrentSortOrder());
					}
				}
				else if($HTTP_VARS['op'] == 'my_reserved')//all titles that the person has reserved from others.
				{
					$page_title = $LANG_VARS['my_reserved_items'];
					
					if(is_numeric($listingObject->getItemsPerPage()))
					{
						$listingObject->setTotalItems(fetch_my_reserved_item_cnt($HTTP_SESSION_VARS['user_id']));
						if($listingObject->getTotalItemCount()>0)
						{
							$listingObject->setCheckBoxColumnAndInitList('sequence_number', TRUE);
							$result = fetch_my_reserved_item_rs(
											$HTTP_SESSION_VARS['user_id'], 
											$listingObject->getCurrentOrderBy(), 
											$listingObject->getCurrentSortOrder(),
											$listingObject->getStartIndex(),
											$listingObject->getItemsPerPage());
						}
					}
					else
					{
						$result = fetch_my_reserved_item_rs(
											$HTTP_SESSION_VARS['user_id'], 
											$listingObject->getCurrentOrderBy(), 
											$listingObject->getCurrentSortOrder());
					}
				}
				else if($HTTP_VARS['op'] == 'owner_borrowed')//all titles the owner currently has lent out to others.
				{
					$page_title = $LANG_VARS['item_check_in'];
					
					if(is_numeric($listingObject->getItemsPerPage()))
					{
						$listingObject->setTotalItems(fetch_owner_borrowed_item_cnt($HTTP_SESSION_VARS['user_id']));
						if($listingObject->getTotalItemCount()>0)
						{
							$listingObject->setCheckBoxColumnAndInitList('sequence_number', TRUE);
							$result = fetch_owner_borrowed_item_rs(
											$HTTP_SESSION_VARS['user_id'], 
											$listingObject->getCurrentOrderBy(), 
											$listingObject->getCurrentSortOrder(),
											$listingObject->getStartIndex(),
											$listingObject->getItemsPerPage());
						}
					}
					else
					{
						$result = fetch_owner_borrowed_item_rs(
											$HTTP_SESSION_VARS['user_id'], 
											$listingObject->getCurrentOrderBy(), 
											$listingObject->getCurrentSortOrder());
					}
				}
				else if($HTTP_VARS['op'] == 'owner_reserved')//all titles the owner currently has reservations for.
				{
					$page_title = $LANG_VARS['item_check_out'];
					
					if(is_numeric($listingObject->getItemsPerPage()))
					{
						$listingObject->setTotalItems(fetch_owner_reserved_item_cnt($HTTP_SESSION_VARS['user_id']));
						if($listingObject->getTotalItemCount()>0)
						{
							$listingObject->setCheckBoxColumnAndInitList('sequence_number', TRUE);
							$result = fetch_owner_reserved_item_rs(
											$HTTP_SESSION_VARS['user_id'], 
											$listingObject->getCurrentOrderBy(), 
											$listingObject->getCurrentSortOrder(),
											$listingObject->getStartIndex(),
											$listingObject->getItemsPerPage());
						}
					}
					else
					{
						$result = fetch_owner_reserved_item_rs(
											$HTTP_SESSION_VARS['user_id'], 
											$listingObject->getCurrentOrderBy());
					}
				}
				else if($HTTP_VARS['op'] == 'my_item_history')
				{
					$show_listings=FALSE;
				
					$item_r = fetch_item_instance_r($HTTP_VARS['item_id'], $HTTP_VARS['instance_no']);
					if(is_not_empty_array($item_r))
					{
						$footer_links_r[] = array(url=>"item_display.php?item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_item']);
						if($HTTP_VARS['listing_link'] === 'y' && is_not_empty_array($HTTP_SESSION_VARS['listing_url_vars']))
						{
							$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
						}
						
						// Cannot view item history, unless you are admin, or own the item.
						if(is_user_admin($HTTP_SESSION_VARS['user_id'],$HTTP_SESSION_VARS['user_type']) || is_user_owner_of_item($item_r['item_id'], $item_r['instance_no'], $HTTP_SESSION_VARS['user_id']))
						{
							$show_listings=TRUE;
						
							$page_title = replace_lang_var('display_title', expand_item_title_mask($item_r, $CONFIG_VARS['item_display.title_display_mask']), $LANG_VARS['history_for_title']);
							$page_image = get_item_image($item_r['s_item_type'], $item_r['item_id']);						
							
							if(is_numeric($listingObject->getItemsPerPage()))
							{
								$listingObject->setTotalItems(fetch_item_instance_history_cnt($item_r['item_id'], $item_r['instance_no']));
								if($listingObject->getTotalItemCount()>0)
								{
									$result = fetch_item_instance_history_rs(
												$item_r['item_id'], 
												$item_r['instance_no'], 
												$listingObject->getCurrentOrderBy(), 
												$listingObject->getCurrentSortOrder(),
												$listingObject->getStartIndex(),
												$listingObject->getItemsPerPage());
								}
							}
							else
							{
								$result = fetch_item_instance_history_rs(
												$item_r['item_id'], 
												$item_r['instance_no'], 
												$listingObject->getCurrentOrderBy(), 
												$listingObject->getCurrentSortOrder());
							}
						}
						else
						{
							echo(_theme_header($LANG_VARS['not_authorized_to_page']));
							echo(_theme_error($LANG_VARS['not_authorized_to_page']));
							if($HTTP_VARS['mode'] != 'printable')
							{
								echo(format_footer_links($footer_links_r));
							}
							echo(_theme_footer());
						}
					}
					else
					{
						echo _theme_header($LANG_VARS['item_not_found']);
						echo _theme_error($LANG_VARS['item_not_found']);
						echo(_theme_footer());
					}
				}
				else if($HTTP_VARS['op'] == 'my_history')
				{
					if(is_user_valid($HTTP_VARS['uid']) && $HTTP_VARS['uid']!==$HTTP_SESSION_VARS['user_id'] && is_user_admin($HTTP_SESSION_VARS['user_id'],$HTTP_SESSION_VARS['user_type']))
					{
						$page_title = replace_lang_vars(array('fullname'=>fetch_user_name($HTTP_VARS['uid']),'user_id'=>$HTTP_VARS['uid']), $LANG_VARS['borrower_history_for_fullname']);
						
						if(is_numeric($listingObject->getItemsPerPage()))
						{
							$listingObject->setTotalItems(fetch_my_history_item_cnt($HTTP_VARS['uid']));
							if($listingObject->getTotalItemCount()>0)
							{
								$result = fetch_my_history_item_rs(
												$HTTP_VARS['uid'], 
												$listingObject->getCurrentOrderBy(), 
												$listingObject->getCurrentSortOrder(),
												$listingObject->getStartIndex(),
												$listingObject->getItemsPerPage());
							}
						}
						else
						{
							$result = fetch_my_history_item_rs(
												$HTTP_VARS['uid'], 
												$listingObject->getCurrentOrderBy(), 
												$listingObject->getCurrentSortOrder());
						}
					}
					else
					{
						$page_title = $LANG_VARS['my_history'];
						
						if(is_numeric($listingObject->getItemsPerPage()))
						{
							$listingObject->setTotalItems(fetch_my_history_item_cnt($HTTP_SESSION_VARS['user_id']));
							if($listingObject->getTotalItemCount()>0)
							{
								$result = fetch_my_history_item_rs(
												$HTTP_SESSION_VARS['user_id'], 
												$listingObject->getCurrentOrderBy(), 
												$listingObject->getCurrentSortOrder(),
												$listingObject->getStartIndex(),
												$listingObject->getItemsPerPage());
							}
						}
						else
						{
							$result = fetch_my_history_item_rs(
												$HTTP_SESSION_VARS['user_id'], 
												$listingObject->getCurrentOrderBy(), 
												$listingObject->getCurrentSortOrder());
						}
					}	
				}
				else if($CONFIG_VARS['borrow.reserve_basket']!==FALSE && 
							($HTTP_VARS['op'] == 'my_reserve_basket' || 
							$HTTP_VARS['op'] == 'update_my_reserve_basket' || 
							$HTTP_VARS['op'] == 'delete_from_my_reserve_basket'))
				{
					$page_title = str_replace(' ', '&nbsp;', $LANG_VARS['item_reserve_list']);
					
					if($HTTP_VARS['mode'] != 'printable')
					{
						$listingObject->setCheckBoxColumnAndInitList('item_id_instance_no', TRUE);
	
						if($HTTP_VARS['op'] == 'update_my_reserve_basket' || $HTTP_VARS['op'] == 'delete_from_my_reserve_basket')
						{
							// We might be reserving a single item only - item_display.php would initiate this operation
							if(is_empty_array($HTTP_VARS['item_id_instance_no']) && is_numeric($HTTP_VARS['item_id']) && is_numeric($HTTP_VARS['instance_no']))
							{
								// Set it up so it looks as if an item was previously checked, but has now been unchecked! - called from item_display.php
								if($HTTP_VARS['op'] == 'delete_from_my_reserve_basket')
								{
									if( is_array($HTTP_SESSION_VARS['reserve_basket_listing']) && ($key = array_search2($HTTP_VARS['item_id']."_".$HTTP_VARS['instance_no'], $HTTP_SESSION_VARS['reserve_basket_listing']))!==FALSE )
									{
										// Remove element
										array_splice($HTTP_SESSION_VARS['reserve_basket_listing'], $key, 1);
									}
								}
								else // else add item to session array. 
								{
									if( !is_array($HTTP_SESSION_VARS['reserve_basket_listing']) || !in_array($HTTP_VARS['item_id']."_".$HTTP_VARS['instance_no'], $HTTP_SESSION_VARS['reserve_basket_listing']) )
									{
										// Add element
										$HTTP_SESSION_VARS['reserve_basket_listing'][] = $HTTP_VARS['item_id']."_".$HTTP_VARS['instance_no'];
									}
								}
							}
							else if($HTTP_VARS['op'] == 'update_my_reserve_basket' && (is_not_empty_array($HTTP_VARS['item_id_instance_no']) || strlen(trim($HTTP_VARS['checked_item_id_instance_no_list']))>0) ) // initiated from listings.php page!
							{
								$HTTP_SESSION_VARS['reserve_basket_listing'] = 
														process_array(
																$HTTP_SESSION_VARS['reserve_basket_listing'], 
																$listingObject->getCheckedList());
								$listingObject->resetCheckedList();
							}
							else // Internal to borrow.php only!
							{
								if($HTTP_VARS['op'] == 'delete_from_my_reserve_basket')
								{
									$HTTP_SESSION_VARS['reserve_basket_listing'] = 
															minus_array_values(
																	$HTTP_SESSION_VARS['reserve_basket_listing'], 
																	$listingObject->getCheckedList());
									$listingObject->resetCheckedList();
								}
							}
							
							if(is_register_globals_enabled())
							{
								session_register('reserve_basket_listing');
								$reserve_basket_listing = $HTTP_SESSION_VARS['reserve_basket_listing'];
							}
						
						}
					}
					
					// Set it explicitly here.
					$HTTP_VARS['op'] = 'my_reserve_basket';
					
					if(is_numeric($listingObject->getItemsPerPage()))
					{
						// Get actual total
						$listingObject->setTotalItems(count($HTTP_SESSION_VARS['reserve_basket_listing']));
					}
											
					//##################################################################
					// Sort Reserve Basket array according to arguments.
					// This may be a little inefficient, recreating the $item_r arrays
					// for each of the $item_id_and_instance_no strings each time,
					// but for now it will do!
					//##################################################################
	
					// First of all, get all the reservations converted to $item_r records, so we can sort them!
					if(is_array($HTTP_SESSION_VARS['reserve_basket_listing']))
					{
						while(list(,$item_id_and_instance_no) = each($HTTP_SESSION_VARS['reserve_basket_listing']))
						{
							if(strlen($item_id_and_instance_no)>0)
							{
								$item_id_and_instance_no_r = get_item_id_and_instance_no($item_id_and_instance_no);
								if(is_not_empty_array($item_id_and_instance_no_r))
									$item_reservation_rs[] = fetch_item_instance_r($item_id_and_instance_no_r['item_id'], $item_id_and_instance_no_r['instance_no']);
							}
						}
					}
					
					if(is_not_empty_array($item_reservation_rs))
					{
						sort_item_reservation_rs(
								$item_reservation_rs, 
								$listingObject->getCurrentOrderBy(), 
								$listingObject->getCurrentSortOrder());
	
						// Now get the bit we actually want for this page.
						if(is_numeric($listingObject->getItemsPerPage()))
						{
							$item_reservation_rs = array_slice(
											$item_reservation_rs, 
											$listingObject->getStartIndex(), 
											$listingObject->getItemsPerPage());
						}
						
						// Ensure we are at the start of the array.
						if(is_array($item_reservation_rs))
							reset($item_reservation_rs);
					}
	
					// Include a Back to Listing link
					// If a single item was specified and it exists, provide a back to item link here.
					if($HTTP_VARS['item_link'] === 'y' && is_exists_item_instance($HTTP_VARS['item_id'],$HTTP_VARS['instance_no']))
					{
						$footer_links_r[] = array(url=>"item_display.php?item_id=".$HTTP_VARS['item_id']."&instance_no=".$HTTP_VARS['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_item']);
					}
					if($HTTP_VARS['listing_link'] === 'y' && is_not_empty_array($HTTP_SESSION_VARS['listing_url_vars']))
					{
						$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
					}
				}
				else if($HTTP_VARS['op'] == 'admin_quick_check_out')
				{
					$admin_quick_check_out_error = NULL;
					
					if(is_user_admin($HTTP_SESSION_VARS['user_id'],$HTTP_SESSION_VARS['user_type']))
					{
						if(strlen($HTTP_VARS['borrower_id'])==0 || 
									!is_user_valid($HTTP_VARS['borrower_id']) || 
									!is_user_active($HTTP_VARS['borrower_id']) || 
									!is_user_allowed_to_borrow($HTTP_VARS['borrower_id']))
						{
							// display owner_id input field.
							echo _theme_header($LANG_VARS['item_quick_check_out']);
							echo("<h2>".$LANG_VARS['item_quick_check_out']."</h2>");
						
							// need to query for owner_id
							if(strlen($HTTP_VARS['borrower_id'])>0)
							{
								if(!is_user_valid($HTTP_VARS['borrower_id']) || !is_user_active($HTTP_VARS['borrower_id']))
								{
									echo(format_error_block(replace_lang_var('user_id', $HTTP_VARS['borrower_id'], $LANG_VARS['invalid_borrower_user'])));
								}
								else // !is_user_allowed_to_borrow($HTTP_VARS['borrower_id']))
								{
									// display error because invalid user chosen.
									echo(format_error_block(replace_lang_var('user_id', $HTTP_VARS['borrower_id'], $LANG_VARS['user_must_be_borrower'])));
								}
							}
							
							echo("\n<table cellspacing=1 border=0>");
							echo("\n<form action=\"$PHP_SELF\" method=\"get\">");
							echo("\n<input type=\"hidden\" name=\"op\" value=\"admin_quick_check_out\">");
							
							if($CONFIG_VARS['borrow.admin_quick_checkout_borrower_lov']!==TRUE)
							{
								echo(get_input_field('borrower_id',
										NULL, // s_attribute_type
										$LANG_VARS['borrower'], 
										"filtered(20,20,a-zA-Z0-9_.)", //input type.
										"Y", //compulsory!
										NULL,//value
										TRUE));
							}
							else
							{
								$results = fetch_user_rs(get_borrower_user_types_r(), "fullname", "ASC", FALSE, $HTTP_SESSION_VARS['user_id']);
								if($results)
								{
									echo(
										format_field($LANG_VARS['borrower'], 
													NULL, 
													custom_select('borrower_id', $results, '%fullname% (%user_id%)', 1, NULL, 'user_id')
											)
										);
								}
								else
								{
									echo(
										format_field(
											$LANG_VARS['borrower'],
											NULL,
											$LANG_VARS['no_records_found'])
										);
								}

							}

							echo("<tr><td colspan=2 align=left><input type=submit value=\"".$LANG_VARS['continue']."\"></td></tr>");
							echo("</form>");
							echo("</table>");
						
							$show_listings=FALSE;
							
							echo(_theme_footer());
						}
						else
						{
							$page_title = replace_lang_vars(array('user_id'=>$HTTP_VARS['borrower_id'], 'fullname'=>fetch_user_name($HTTP_VARS['borrower_id'])), $LANG_VARS['item_quick_check_out_for_fullname']);
							
							// TODO: Support alternate item ID attribute instead of 'item.instance'
							if(preg_match("/([0-9]+)\.([0-9]+)/", trim($HTTP_VARS['item_instance']), $matches) || 
										preg_match("/([0-9]+)/", trim($HTTP_VARS['item_instance']), $matches))
							{
								$item_id = $matches[1];
								$instance_no = ifempty($matches[2], '1');
								
								// make sure it has not already been chosen.
								if(!is_array($HTTP_VARS['checkout_item_instance_rs']) || 
											!in_array($item_id."_".$instance_no, $HTTP_VARS['checkout_item_instance_rs']))
								{
									if(is_exists_item_instance($item_id, $instance_no))
									{
										if(!is_item_borrowed($item_id, $instance_no))
										{
											if(!is_user_owner_of_item($item_id, $instance_no, $HTTP_VARS['borrower_id']))
											{
												$status_type_r = fetch_status_type_r(fetch_item_s_status_type($item_id, $instance_no));
												if($status_type_r['borrow_ind'] == 'Y')//Owner operation
												{
													$HTTP_VARS['checkout_item_instance_rs'][] = $item_id."_".$instance_no;
												}
												else
												{
													$admin_quick_check_out_error = replace_lang_var('s_status_type_desc', $status_type_r['description'], $LANG_VARS['s_status_type_items_cannot_be_borrowed']);
												}
											}
											else
											{
												$admin_quick_check_out_error = $LANG_VARS['user_is_owner_of_item'];
											}
										}
										else
										{
											$admin_quick_check_out_error = $LANG_VARS['item_is_already_checked_out'];
										}
									}
								}
							}
							
							if(is_numeric($listingObject->getItemsPerPage()))
							{
								// Get actual total
								$listingObject->setTotalItems(count($HTTP_VARS['checkout_item_instance_rs']));
							}
							
							if(is_array($HTTP_VARS['checkout_item_instance_rs']))
							{
								while(list(,$item_id_and_instance_no) = each($HTTP_VARS['checkout_item_instance_rs']))
								{
									if(strlen($item_id_and_instance_no)>0)
									{
										$item_id_and_instance_no_r = get_item_id_and_instance_no($item_id_and_instance_no);
										if(is_not_empty_array($item_id_and_instance_no_r))
											$item_reservation_rs[] = fetch_item_instance_r($item_id_and_instance_no_r['item_id'], $item_id_and_instance_no_r['instance_no']);
									}
								}
							}
					
							if(is_not_empty_array($item_reservation_rs))
							{
								sort_item_reservation_rs(
										$item_reservation_rs, 
										$listingObject->getCurrentOrderBy(), 
										$listingObject->getCurrentSortOrder());
	
								// Now get the bit we actually want for this page.
								if(is_numeric($listingObject->getItemsPerPage()))
								{
									$item_reservation_rs = array_slice(
													$item_reservation_rs, 
													$listingObject->getStartIndex(), 
													$listingObject->getItemsPerPage());
								}
						
								// Ensure we are at the start of the array.
								if(is_array($item_reservation_rs))
									reset($item_reservation_rs);
							}
						}
					}
					else
					{
						echo(_theme_header($LANG_VARS['not_authorized_to_page']));
						echo(_theme_error($LANG_VARS['not_authorized_to_page']));
						echo(_theme_footer());
					}
				}
				else if($HTTP_VARS['op'] == 'admin_history')
				{   
					echo(_theme_header($LANG_VARS['borrower_history']));
					echo("<h2>".$LANG_VARS['borrower_history']."</h2>");
				
					echo("\n<table cellspacing=1 border=0>");
					echo("\n<form action=\"$PHP_SELF\" method=\"get\">");
					echo("\n<input type=\"hidden\" name=\"op\" value=\"my_history\">");
	
					$results = fetch_user_rs(get_borrower_user_types_r(), "fullname", "ASC");
					echo(format_field($LANG_VARS['borrower'], NULL, custom_select('uid', $results, '%fullname% (%user_id%)', 1, NULL, 'user_id')));
					echo("<tr><td colspan=2 align=left><br><input type=submit value=\"".$LANG_VARS['continue']."\"></td></tr>");
				
					echo("</form>");
					echo("</table>");
					
					echo(_theme_footer());
					
					$show_listings=FALSE;
				}
				else
				{
					echo(_theme_header($LANG_VARS['operation_not_available']));
					echo(_theme_error($LANG_VARS['operation_not_available']));
					echo(_theme_footer());
	
					$show_listings=FALSE;	
				}
	
				if($show_listings)
				{
					if($HTTP_VARS['mode'] == 'printable')
					{
						if(ifempty($HTTP_VARS['content_type'],'HTML') == 'HTML')
						{
							echo(_theme_header($page_title));
						}
					}
					else
					{
						echo(_theme_header($page_title));
						echo('<h2>'.$page_title.' '.$page_image.'</h2>');
	
						if($CONFIG_VARS['listings.allow_override_show_item_image']!==FALSE && $HTTP_VARS['op'] != 'my_item_history')
						{
							$listingObject->addToggleControl(
								$LANG_VARS['show_item_image'], 
								'show_item_image', 
								ifempty($HTTP_VARS['show_item_image'], $CONFIG_VARS['listings.show_item_image']==TRUE?'Y':'N'));
						}
					}
					
					if($HTTP_VARS['mode'] != 'printable' && $HTTP_VARS['op'] == 'admin_quick_check_out')
					{
						if(strlen($admin_quick_check_out_error)>0)
						{
							echo(format_error_block($admin_quick_check_out_error));
						}
					
						// include the input field and other processing here.
						echo("\n<table cellspacing=1 border=0>");
						echo("\n<form action=\"$PHP_SELF\" method=\"post\">");
						echo("\n<input type=\"hidden\" name=\"op\" value=\"admin_quick_check_out\">");
						echo("\n<input type=\"hidden\" name=\"page_no\" value=\"\">");//dummy
						echo("\n<input type=\"hidden\" name=\"internal_link\" value=\"\">");//dummy
						echo("\n<input type=\"hidden\" name=\"borrower_id\" value=\"".$HTTP_VARS['borrower_id']."\">");
						echo(format_field($LANG_VARS['item_id'], NULL, "<input type=\"text\" name=\"item_instance\" value=\"\">"));
						echo("<tr><td><input type=submit value=\"".$LANG_VARS['add_item']."\"></td>");
						
						if(is_not_empty_array($HTTP_VARS['checkout_item_instance_rs']))
						{
							echo("<td><input type=button onclick=\"doOperation(this.form, 'item_borrow.php', 'quick_check_out')\" value=\"".$LANG_VARS['check_out_item(s)']."\"></td></tr>");
							echo(get_url_fields(NULL, array('checkout_item_instance_rs'=>$HTTP_VARS['checkout_item_instance_rs'])));
						}
						echo("</form>");
						echo("</table>");
					}
					
					$listingObject->startListing($page_title);
					
					if($HTTP_VARS['op'] != 'my_item_history')
					{
						$listingObject->addHeaderColumn($LANG_VARS['type'], 's_item_type');
						$listingObject->addHeaderColumn($LANG_VARS['title'], 'title');
					}
				
					if($HTTP_VARS['op'] == 'admin_quick_check_out' || $HTTP_VARS['op'] == 'my_reserve_basket' || $HTTP_VARS['op'] == 'my_borrowed' || $HTTP_VARS['op'] == 'my_reserved' || $HTTP_VARS['op'] == 'my_history' || $HTTP_VARS['op'] == 'all_borrowed' || $HTTP_VARS['op'] == 'all_reserved')
					{
						$listingObject->addHeaderColumn($LANG_VARS['owner'], 'owner');
					}
					
					if($HTTP_VARS['op'] == 'owner_reserved' || $HTTP_VARS['op'] == 'owner_borrowed' || $HTTP_VARS['op'] == 'my_item_history' || ($CONFIG_VARS['borrow.include_borrower_column']!==FALSE && ($HTTP_VARS['op'] == 'all_borrowed' || $HTTP_VARS['op'] == 'all_reserved')))
					{
						$listingObject->addHeaderColumn($LANG_VARS['borrower'], 'borrower');
					}
					
					if($HTTP_VARS['op'] == 'owner_reserved' || $HTTP_VARS['op'] == 'my_reserved' || $HTTP_VARS['op'] == 'all_reserved' || $HTTP_VARS['op'] == 'my_item_history')
					{
						$listingObject->addHeaderColumn($LANG_VARS['borrow_status']);
					}
			
					if($HTTP_VARS['op'] == 'my_history')
					{
						$listingObject->addHeaderColumn($LANG_VARS['borrow_date'], 'borrow_date');
						$listingObject->addHeaderColumn($LANG_VARS['return_date'], 'return_date');
						$listingObject->addHeaderColumn($LANG_VARS['total_duration']);
					}
					else if($HTTP_VARS['op'] == 'my_item_history')
					{
						$listingObject->addHeaderColumn($LANG_VARS['borrow_date']);
						$listingObject->addHeaderColumn($LANG_VARS['return_date']." /\n".$LANG_VARS['due_date']);
						$listingObject->addHeaderColumn($LANG_VARS['total_duration']." /\n".$LANG_VARS['borrow_duration']);
					}
					else if($HTTP_VARS['op'] == 'owner_reserved' || $HTTP_VARS['op'] == 'my_reserved' || $HTTP_VARS['op'] == 'all_reserved')
					{
						$listingObject->addHeaderColumn($LANG_VARS['reserve_date'], 'reserve_date');
					}
				
					if($CONFIG_VARS['borrow.duration_support'])
					{
						if($HTTP_VARS['op'] == 'my_history' || $HTTP_VARS['op'] == 'my_item_history')
							$listingObject->addHeaderColumn($LANG_VARS['overdue_duration']);
						else if($HTTP_VARS['op'] == 'my_borrowed' || $HTTP_VARS['op'] == 'all_borrowed' || $HTTP_VARS['op'] == 'owner_borrowed')
							$listingObject->addHeaderColumn($LANG_VARS['due_date'], 'due_date');
						else // reserved!
							$listingObject->addHeaderColumn($LANG_VARS['borrow_duration']);
					}
	
					// If mysql resultset or static $item_reservation_rs array defined, we
					// can continue.
					if( ($result || is_not_empty_array($item_reservation_rs)) )
					{
						while( ($borrowed_item_r = next_record($result, $item_reservation_rs)) !== FALSE)
						{
							// In the case of 'my_reserve_basket' operation, a record may have been
							// erroneously entered into the basket list.  If so the next_record(...)
							// call will return NULL.  This allows the generation to continue (test for FALSE!)
							// but this 'if', will avoid displaying the record if invalid.
							if($borrowed_item_r == NULL)
							{
								// Do next loop of while now!
								continue;
							}
							
							$listingObject->startRow();
							
							$status_type_r = fetch_status_type_r($borrowed_item_r['s_status_type']);
	
							// Checkbox!
							if($listingObject->isCheckBoxColumn())
							{
								if($HTTP_VARS['op'] == 'my_reserve_basket' || $HTTP_VARS['op'] == 'my_reserved' || $HTTP_VARS['op'] == 'owner_reserved' || $HTTP_VARS['op'] == 'owner_borrowed')
								{
									if($HTTP_VARS['op'] == 'my_reserve_basket')
									{
										$listingObject->addColumn($borrowed_item_r['item_id']."_".$borrowed_item_r['instance_no']);
									}
									else
									{
										// Owner checkout.
										if($HTTP_VARS['op'] != 'owner_reserved' || (($status_type_r['borrow_ind'] == 'Y' || $status_type_r['borrow_ind'] == 'N') && !is_item_borrowed($borrowed_item_r['item_id'],$borrowed_item_r['instance_no'])))
										{
											$listingObject->addColumn($borrowed_item_r['sequence_number']);
										}
										else
										{
											$listingObject->addColumn();
										}
									}
								}
							}
							
							if($HTTP_VARS['op'] != 'my_item_history')
							{
								// Type
								$listingObject->addItemTypeImageColumn(
										$borrowed_item_r['s_item_type']);
								
								if($HTTP_VARS['op'] == 'my_borrowed' || $HTTP_VARS['op'] == 'my_history')
								{
									$listingObject->addTitleColumn(
											$borrowed_item_r,
											TRUE, // is_item_reviewed
											FALSE); // do not display previously borrowed or returned information.
								}
								else
								{
									$listingObject->addTitleColumn(
											$borrowed_item_r);
								}
							}
						
							// Owner/Borrower
							if($HTTP_VARS['op'] == 'admin_quick_check_out' || $HTTP_VARS['op'] == 'my_reserve_basket' || $HTTP_VARS['op'] == 'my_borrowed' || $HTTP_VARS['op'] == 'my_reserved' || $HTTP_VARS['op'] == 'my_history' || $HTTP_VARS['op'] == 'all_borrowed' || $HTTP_VARS['op'] == 'all_reserved')
							{
								$listingObject->addUserNameColumn(
											$borrowed_item_r['owner_id']);
							}
							
							if($HTTP_VARS['op'] == 'owner_reserved' || $HTTP_VARS['op'] == 'owner_borrowed' || $HTTP_VARS['op'] == 'my_item_history' || ($CONFIG_VARS['borrow.include_borrower_column']!==FALSE && ($HTTP_VARS['op'] == 'all_borrowed' || $HTTP_VARS['op'] == 'all_reserved')))
							{
								$listingObject->addUserNameColumn(
											$borrowed_item_r['borrower_id']);
							}
							
							// Checked Out status!
							if($HTTP_VARS['op'] == 'owner_reserved' || $HTTP_VARS['op'] == 'my_reserved' || $HTTP_VARS['op'] == 'all_reserved')
							{
								if(is_item_borrowed($borrowed_item_r['item_id'],$borrowed_item_r['instance_no']))
								{
									$listingObject->addThemeImageColumn(
											'borrowed.gif', 
											$LANG_VARS['borrowed'], 
											NULL, //title
											'borrowed_item');
								}
								else if($status_type_r['borrow_ind'] == 'Y' || $status_type_r['borrow_ind'] == 'N') // Reserved - If the items are here they have to have been reserved!
								{
									$listingObject->addThemeImageColumn(
											'reserved.gif', 
											$LANG_VARS['reserved'], 
											NULL, //title
											'borrowed_item');
								}
								else
								{
									$listingObject->addThemeImageColumn(
											$status_type_r['img'], 
											$status_type_r['description'], 
											NULL, //title
											'borrowed_item');
								}
							}
							else if($HTTP_VARS['op'] == 'my_item_history')
							{
								if($borrowed_item_r['status'] == 'X')
								{
									$listingObject->addColumn($LANG_VARS['cancelled']);
								}
								else if($borrowed_item_r['status'] == 'R')
								{
									$listingObject->addColumn($LANG_VARS['reserved']);
								}
								else if($borrowed_item_r['status'] == 'C')
								{
									$listingObject->addColumn($LANG_VARS['checked_in']);
								}
								else if($borrowed_item_r['status'] == 'B')
								{
									$listingObject->addColumn($LANG_VARS['checked_out']);
								}
							}
							
							// Due Date / Borrow Duration / (Returned & Total Days & Overdue Days)
							if($HTTP_VARS['op'] == 'my_history' || $HTTP_VARS['op'] == 'my_item_history')
							{
								// borrow date
								if($borrowed_item_r['status'] != 'X')
								{
									if(strlen($borrowed_item_r['borrow_date'])>0)
										$listingObject->addColumn(get_localised_timestamp($CONFIG_VARS['borrow.date_mask'], $borrowed_item_r['borrow_date']));
									else
										$listingObject->addColumn($LANG_VARS['undefined']);
								}
								else
								{
									$listingObject->addColumn($LANG_VARS['not_applicable']);
								}
										
								// Returned / Due Date
								if($borrowed_item_r['status'] == 'C' && strlen($borrowed_item_r['return_date'])>0)
								{
									$listingObject->addColumn(get_localised_timestamp($CONFIG_VARS['borrow.date_mask'],$borrowed_item_r['return_date']));
								}
								else if($borrowed_item_r['status'] == 'X')
								{
									if($HTTP_VARS['op'] == 'my_item_history')
										$listingObject->addColumn($LANG_VARS['not_applicable']);
									else
										$listingObject->addColumn($LANG_VARS['reservation_cancelled']);
								}
								else if($borrowed_item_r['status'] == 'B')
								{
									if($CONFIG_VARS['borrow.duration_support'] && strlen($borrowed_item_r['due_date'])>0)
										$listingObject->addColumn(get_localised_timestamp($CONFIG_VARS['borrow.date_mask'], $borrowed_item_r['due_date']));
									else
										$listingObject->addColumn($LANG_VARS['undefined']);
								}
								else if($borrowed_item_r['status'] == 'R')
								{
									$listingObject->addColumn($LANG_VARS['not_applicable']);
								}
								else
								{
									$listingObject->addColumn();
								}
								
								// Total Duration / Borrow Duration
								if($borrowed_item_r['status'] == 'C' && is_numeric($borrowed_item_r['total_duration']))
								{
									$listingObject->addColumn($borrowed_item_r['total_duration']);
								}
								else if($borrowed_item_r['status'] == 'X')
								{
									$listingObject->addColumn($LANG_VARS['not_applicable']);
								}
								else if($borrowed_item_r['status'] == 'B' && is_numeric($borrowed_item_r['calc_total_duration']))
								{
									$listingObject->addColumn($borrowed_item_r['calc_total_duration']);
								}
								else if($borrowed_item_r['status'] == 'R' && is_numeric($borrowed_item_r['ii_borrow_duration']) && $borrowed_item_r['ii_borrow_duration']>0)
								{
									$duration_attr_type_r = fetch_sfieldtype_item_attribute_type_r($borrowed_item_r['s_item_type'], 'DURATION', TRUE);
									$listingObject->addDisplayColumn(
											$duration_attr_type_r['s_attribute_type'],
											NULL,
											$duration_attr_type_r['display_type'],
											$borrowed_item_r['ii_borrow_duration']);
								}
								else
								{
									$listingObject->addColumn($LANG_VARS['unknown']);
								}
							}
				
							if($HTTP_VARS['op'] == 'owner_reserved' || $HTTP_VARS['op'] == 'my_reserved' || $HTTP_VARS['op'] == 'all_reserved')
							{
								$listingObject->addColumn(get_localised_timestamp($CONFIG_VARS['borrow.datetime_mask'], $borrowed_item_r['reserve_date']));
							}
					
							if ($CONFIG_VARS['borrow.duration_support'])
							{
								if($HTTP_VARS['op'] == 'my_history' || $HTTP_VARS['op'] == 'my_item_history')
								{
									// Overdue Days
									if($borrowed_item_r['status'] == 'X')
										$listingObject->addColumn($LANG_VARS['not_applicable']);
									else if($borrowed_item_r['status'] == 'C' || $borrowed_item_r['status'] == 'B')
									{
										if(is_numeric($borrowed_item_r['borrow_duration']) && $borrowed_item_r['borrow_duration']>0 && is_numeric($borrowed_item_r['total_duration']))
										{
											if($borrowed_item_r['total_duration'] > $borrowed_item_r['borrow_duration'])
												$listingObject->addColumn($borrowed_item_r['total_duration'] - $borrowed_item_r['borrow_duration']);
											else
												$listingObject->addColumn('0');
										}
										else if(is_numeric($borrowed_item_r['borrow_duration']) && $borrowed_item_r['borrow_duration']>0 && is_numeric($borrowed_item_r['calc_total_duration']))
										{
											if($borrowed_item_r['calc_total_duration'] > $borrowed_item_r['borrow_duration'])
												$listingObject->addColumn($borrowed_item_r['calc_total_duration'] - $borrowed_item_r['borrow_duration']);
											else
												$listingObject->addColumn('0');
										}
										else
										{
											$listingObject->addColumn($LANG_VARS['unknown']);
										}
									}
									else // reserved - item_history
									{
										$listingObject->addColumn($LANG_VARS['not_applicable']);
									}
								}
								else if($HTTP_VARS['op'] == 'my_borrowed' || $HTTP_VARS['op'] == 'all_borrowed' || $HTTP_VARS['op'] == 'owner_borrowed')
								{
									if(strlen($borrowed_item_r['due_date'])>0)
										$listingObject->addColumn(get_localised_timestamp($CONFIG_VARS['borrow.date_mask'], $borrowed_item_r['due_date']));
									else
										$listingObject->addColumn($LANG_VARS['undefined']);
								}
								else // Reserved
								{
									if(is_numeric($borrowed_item_r['borrow_duration']) && $borrowed_item_r['borrow_duration']>0)
									{
										$duration_attr_type_r = fetch_sfieldtype_item_attribute_type_r($borrowed_item_r['s_item_type'], 'DURATION', TRUE);
										$listingObject->addDisplayColumn(
												$duration_attr_type_r['s_attribute_type'],
												NULL,
												$duration_attr_type_r['display_type'],
												$borrowed_item_r['borrow_duration']);
									}
									else
									{
										$listingObject->addColumn($LANG_VARS['undefined']);
									}
								}
							}
							$listingObject->endRow();
						}// End of while
		
						// Free result if mysql resultset
						if(isset($result) && !is_array($result))
							@mysql_free_result($result);
	
						// ----------------------------------------------------------
						if($HTTP_VARS['mode'] != 'printable')
						{
							if($HTTP_VARS['op'] == 'my_reserve_basket')
							{
								if($listingObject->getCheckBoxCount() > 0 || $listingObject->getCheckedListCount() > 0)
								{
									$listingObject->addListOpAction(
													$LANG_VARS['delete_from_reserve_list'], 
													'', 
													'delete_from_my_reserve_basket',
													$listingObject->getCheckedListCount() == 0);//Do isChecked javascript, if no items chosen from other pages
													
									$listingObject->addListOpAction(
													$LANG_VARS['reserve_item(s)'], 
													'item_borrow.php', 
													'reserve',
													$listingObject->getCheckedListCount() == 0);//Do isChecked javascript, if no items chosen from other pages
								}
								
								$listingObject->addListOpAction(
													$LANG_VARS['reserve_all_item(s)'],
													'item_borrow.php',
													'reserve_all',
													FALSE); // no need for a isChecked test.
							}
							else if($HTTP_VARS['op'] == 'my_reserved')
							{
								if($listingObject->getCheckBoxCount() > 0 || $listingObject->getCheckedListCount() > 0)
								{
									$listingObject->addListOpAction(
													$LANG_VARS['cancel_reservation(s)'], 
													'item_borrow.php', 
													'cancel_reserve',
													$listingObject->getCheckedListCount() == 0);//Do isChecked javascript, if no items chosen from other pages
								}
							}
							else if($HTTP_VARS['op'] == 'owner_borrowed')
							{
								if($listingObject->getCheckBoxCount() > 0 || $listingObject->getCheckedListCount() > 0)
								{
									$listingObject->addListOpAction(
													$LANG_VARS['check_in_item(s)'], 
													'item_borrow.php', 
													'check_in',
													$listingObject->getCheckedListCount() == 0);//Do isChecked javascript, if no items chosen from other pages
									
									if($CONFIG_VARS['email.use_php_mail']!==FALSE)
									{
										$listingObject->addListOpAction(
													$LANG_VARS['send_reminder(s)'],
													'item_borrow.php',
													'reminder',
													$listingObject->getCheckedListCount() == 0); //Do isChecked javascript, if no items chosen from other pages
									}
									
									if($CONFIG_VARS['borrow.duration_support']!==FALSE)
									{
										$listingObject->addListOpAction(
													$LANG_VARS['borrow_duration_extension(s)'],
													'item_borrow.php',
													'extension',
													$listingObject->getCheckedListCount() == 0);//Do isChecked javascript, if no items chosen from other pages
									}
								}
							}
							else if($HTTP_VARS['op'] == 'owner_reserved')
							{
								if($listingObject->getCheckBoxCount() > 0 || $listingObject->getCheckedListCount() > 0)
								{
									$listingObject->addListOpAction(
													$LANG_VARS['check_out_item(s)'],
													'item_borrow.php',
													'check_out',
													$listingObject->getCheckedListCount() == 0);//Do isChecked javascript, if no items chosen from other pages
													
									$listingObject->addListOpAction(
													$LANG_VARS['cancel_reservation(s)'],
													'item_borrow.php',
													'cancel_reserve',
													$listingObject->getCheckedListCount() == 0);//Do isChecked javascript, if no items chosen from other pages
								}
							}
						}
					}//if( ($result || is_not_empty_array($item_reservation_rs)) && $listingObject->getTotalItemCount()>0)
					
					// This is a read only page, so no help required.
					if($HTTP_VARS['mode'] != 'printable')
					{
						if($HTTP_VARS['op'] != 'my_history' && $HTTP_VARS['op'] != 'my_item_history' && $HTTP_VARS['op'] != 'admin_history')
						{
							while (list(,$help) = @each($LANG_VARS['borrow_help']))
							{
								$listingObject->addHelpEntry($help);
							}
						}
						
						if($HTTP_VARS['op'] == 'my_item_history')
						{
							while (list(,$help) = @each($LANG_VARS['borrow_item_history_help']))
							{
								$listingObject->addHelpEntry($help);
							}
						}
						else if($HTTP_VARS['op'] == 'my_reserve_basket')
						{
							while (list(,$help) = @each($LANG_VARS['reserve_basket_help']))
							{
								$listingObject->addHelpEntry($help);
							}
						}
					}
					
					$listingObject->endListing();
					unset($listingObject);
					
					if($HTTP_VARS['mode'] != 'printable')
					{
						echo(format_footer_links($footer_links_r));
					}
					
					if($HTTP_VARS['mode'] != 'printable' || ifempty($HTTP_VARS['content_type'],'HTML') == 'HTML')
					{
						echo(_theme_footer());
					}
					
				}//end if($show_listings)		
			}//no guests allowed!
			else
			{
				echo(_theme_header($LANG_VARS['not_authorized_to_page']));
				echo(_theme_error($LANG_VARS['not_authorized_to_page']));
				echo(_theme_footer());
			}
		}//borrow functionality disabled.
		else
		{
			echo(_theme_header($LANG_VARS['borrow_not_supported']));
			echo(_theme_error($LANG_VARS['borrow_not_supported']));
			echo(_theme_footer());
		}
	}
	else
	{
		// invalid login, so login instead.
		include("./login.php");
	}
}//if($CONFIG_VARS['site.enable']!==FALSE)
else
{
	echo _theme_header($LANG_VARS['site_is_disabled'], FALSE);
	echo _theme_error($LANG_VARS['site_is_disabled']);
	echo _theme_footer();
}

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>
