<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once("./functions/item_attribute.php");

/**
* Checks to see if the s_attribute_type is linked to any s_item_type's via a
* s_item_attribute_type table record.  The delete will not be allowed if any
* such record is found.
* 
* @param $s_item_type		If specified will restrict to specific s_item_type
* @param $s_attribute_type	If specified will restrict to specific s_item_attribute_type
* @param $order_no			If specified will restrict to specific $s_attribute_type AND $order_no
*/
function is_exists_item_attribute_type($s_item_type, $s_attribute_type, $order_no=NULL)
{
	$query = "SELECT 'x' FROM s_item_attribute_type ";
	
	if(strlen($s_attribute_type)>0)
	{
		$where .= " s_attribute_type = '".$s_attribute_type."'";
		if(is_numeric($order_no))
			$where .= " AND order_no = '$order_no'";	
	}
				
	// Support check for any instances of the s_attribute_type in the s_item_attribute_type table,
	// or a specific s_item_type instance if $s_item_type specified.	
	if(strlen($s_item_type)>0)
	{
		if(strlen($s_attribute_type)>0)
			$where .= " AND ";
		$where .= "s_item_type = '$s_item_type'";
	}
	
	if(strlen($where)>0)
		$query .= " WHERE $where ";
		
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		mysql_free_result($result);
		return TRUE;
	}

	//else
	return FALSE;
}

function is_exists_addr_attribute_type_rltshp($s_address_type, $s_attribute_type, $order_no=NULL)
{
	$query = "SELECT 'x' FROM s_addr_attribute_type_rltshp ";
	
	if(strlen($s_attribute_type)>0)
	{
		$where .= " s_attribute_type = '".$s_attribute_type."'";
		if(is_numeric($order_no))
			$where .= " AND order_no = '$order_no'";	
	}
				
	// Support check for any instances of the s_attribute_type in the s_addr_attribute_type_rltshp table,
	// or a specific s_address_type instance if $s_address_type specified.	
	if(strlen($s_address_type)>0)
	{
		if(strlen($s_attribute_type)>0)
			$where .= " AND ";
		$where .= "s_address_type = '$s_address_type'";
	}
	
	if(strlen($where)>0)
		$query .= " WHERE $where ";

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		mysql_free_result($result);
		return TRUE;
	}

	//else
	return FALSE;
}

/*
* Fetch a list of all s_attribute_type's which do not start with the restricted
* 'S_ prefix.
*/
function fetch_user_attribute_type_rs($orderby = "s_attribute_type", $order = "asc")
{
	global $ADMIN_TYPE;
	
	$query = "SELECT s_attribute_type, description, input_type FROM s_attribute_type ".
			"WHERE s_attribute_type NOT LIKE 'S\_%'";
	
	if($ADMIN_TYPE == 's_address_attribute_type' || $ADMIN_TYPE == 's_address_attribute_type_lookup')
	{
		$query .= " AND s_field_type = 'ADDRESS'";
	}
	else
	{
		$query .= " AND (s_field_type IS NULL OR s_field_type <> 'ADDRESS')";
	}
	
	$query .= " ORDER BY $orderby $order";
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
		return $result;
	else
		return FALSE;
}

/*
* Fetch a list of ALL s_attribute_type's
*/
function fetch_attribute_type_rs($orderby = "s_attribute_type", $order = "asc")
{
	global $ADMIN_TYPE;
	
	$query = "SELECT s_attribute_type, description, input_type FROM s_attribute_type ";
	
	if($ADMIN_TYPE == 's_address_attribute_type' || $ADMIN_TYPE == 's_address_attribute_type_lookup')
	{
		$query .= "WHERE s_field_type = 'ADDRESS'";
	}
	else
	{
		$query .= "WHERE (s_field_type IS NULL OR s_field_type <> 'ADDRESS')";
	}
	
	$query .= "ORDER BY $orderby $order";
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
		return $result;
	else
		return FALSE;
}

/**
	This one selects FULL records from the table.
*/
function fetch_s_attribute_type_r($s_attribute_type)
{
	$query = "SELECT s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type FROM s_attribute_type WHERE s_attribute_type = '$s_attribute_type'";

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		return $found;
	}
	
	//else
	return FALSE;
}

/**
*/
function is_reserved_s_attribute_type($s_attribute_type)
{
	if(strtoupper(substr(trim($s_attribute_type),0,2)) == "S_")
		return TRUE;
	else
		return FALSE;
}

function fetch_attribute_type_s_field_type($s_attribute_type)
{
	$query = "SELECT s_field_type FROM s_attribute_type WHERE s_attribute_type = '$s_attribute_type'";

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		return $found['s_field_type'];
	}
	
	//else
	return FALSE;
}

function insert_s_attribute_type($s_attribute_type, $description, $prompt, $input_type, $display_type, $s_field_type, $site_type)
{
	global $HTTP_SESSION_VARS;
	
	$description = addslashes(trim(strip_tags($description)));
	$prompt = addslashes(trim(strip_tags($prompt)));
	$input_type = addslashes(trim($input_type));
	$display_type = addslashes(trim($display_type));
	$s_field_type = strtoupper(trim($s_field_type));
	$site_type = strtolower(trim($site_type));

	$query = "INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) "
			."VALUES ('$s_attribute_type', '$description', '$prompt', '$input_type', '$display_type', '$s_field_type', '$site_type')";
	$update = run_opendb_query($query);
	
	// We should not treat updates that were not actually updated because value did not change as failures.
	$rows_affected = mysql_affected_rows();
	if($update && $rows_affected !== -1)
	{
		if($rows_affected>0)
			opendb_log("Inserted s_attribute_type (s_attribute_type=$s_attribute_type, update_who=".$HTTP_SESSION_VARS['user_id'].")");
		return TRUE;
	}
	else
	{
		opendb_log("Failed to insert s_attribute_type (s_attribute_type=$s_attribute_type, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
		return FALSE;
	}
	
	//else
	return FALSE;

}

/*
*/
function update_s_attribute_type($s_attribute_type, $description, $prompt, $input_type, $display_type, $s_field_type, $site_type)
{
	global $HTTP_SESSION_VARS;
	
	$query = "UPDATE s_attribute_type "
			."SET description = '".addslashes(trim(strip_tags($description)))."'"
			.", prompt = '".addslashes(trim(strip_tags($prompt)))."'"
			.($input_type!==FALSE?", input_type = '".addslashes(trim($input_type))."'":"")
			.($display_type!==FALSE?", display_type = '".addslashes(trim($display_type))."'":"")
			.($s_field_type!==FALSE?", s_field_type = '".strtoupper(trim($s_field_type))."'":"")
			.($site_type!==FALSE?", site_type = '".strtolower(trim($site_type))."'":"")
			." WHERE s_attribute_type = '$s_attribute_type'";

	$update = run_opendb_query($query);

	// We should not treat updates that were not actually updated because value did not change as failures.
	$rows_affected = mysql_affected_rows();
	if($update && $rows_affected !== -1)
	{
		if($rows_affected>0)
			opendb_log("Updated s_attribute_type (s_attribute_type=$s_attribute_type, update_who=".$HTTP_SESSION_VARS['user_id'].")");
		return TRUE;
	}
	else
	{
		opendb_log("Failed to update s_attribute_type (s_attribute_type=$s_attribute_type, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
		return FALSE;
	}
	
	//else
	return FALSE;
}

function delete_s_attribute_type($s_attribute_type)
{
	global $HTTP_SESSION_VARS;
	
	$query = "DELETE FROM s_attribute_type "
			."WHERE s_attribute_type = '$s_attribute_type'";

	$delete = run_opendb_query($query);
	
	// We should not treat updates that were not actually updated because value did not change as failures.
	$rows_affected = mysql_affected_rows();
	if($delete && $rows_affected !== -1)
	{
		if($rows_affected>0)
			opendb_log("Deleted s_attribute_type (s_attribute_type=$s_attribute_type, update_who=".$HTTP_SESSION_VARS['user_id'].")");
		return TRUE;
	}
	else
	{
		opendb_log("Failed to delete s_attribute_type (s_attribute_type=$s_attribute_type, update_who=".$HTTP_SESSION_VARS['user_id']."). [".mysql_error()."]");
		return FALSE;
	}
	
	//else
	return FALSE;
}
?>