#
# Patch for 0.62 - 0.80
#
# The patch/install/opendb.sql script was not updated with these changes
# as part of 0.62, so this patch is provided for those who installed
# a fresh copy of OpenDb 0.62.
#

#
# Lookup values should be no larger than 50 characters - the Lookups tool enforces this.
#
ALTER TABLE s_attribute_type_lookup CHANGE value value varchar(50) NOT NULL;

#
# Add new transfer ownership column
#
ALTER TABLE s_status_type ADD change_owner_ind varchar(1) NOT NULL default 'N' AFTER delete_ind;

# Update External type, to prevent check-out of External items
UPDATE s_status_type SET borrow_ind = 'B' WHERE s_status_type = 'X';

# Update to have correct description
UPDATE s_status_type SET description = 'Available' WHERE s_status_type = 'A';
UPDATE s_status_type SET description = 'Inactive' WHERE s_status_type = 'N';

#
# Need to increase size of language and theme columns in database
# as there are already themes which have exceeded the previous
# 10 character limit.
#
ALTER TABLE user CHANGE language language varchar(20);
ALTER TABLE user CHANGE theme theme varchar(20);

#
# 
#
ALTER TABLE user ADD active_ind varchar(1) NOT NULL default 'Y' AFTER lastvisit;

#
# No longer using the pwd length of zero to indicate the user is inactive
#
UPDATE user SET active_ind = 'N' WHERE LENGTH(IFNULL(pwd,'')) = 0;

#
# Remove support for empty type
#
UPDATE user SET type = 'N' WHERE LENGTH(IFNULL(type,'')) = 0;

#
# Assistance for admin section more than anything - prevents S_RATING
# being linked to s_item_type's
#
UPDATE s_attribute_type
SET s_field_type = 'RATING'
WHERE s_attribute_type = 'S_RATING';

#
# For some reason the description has disappeared from this attribute type
#
UPDATE s_attribute_type
SET description = 'Borrow Duration'
WHERE s_attribute_type = 'S_DURATION';

#
# Insert IMDBRATING for all standard item types.  The standard installation process has been updated
# to include this attribute, thus we include in patch too.
#
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'IMDBRATING','IMDB User Rating', 'IMDB Rating', 'hidden', 'star_rating(10, %starrating%&nbsp;%value%/%maxrange%)', NULL, 'imdb');

INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DVD', 'IMDBRATING', '5', '', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VHS', 'IMDBRATING', '5', '', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'LD', 'IMDBRATING', '5', '', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VCD', 'IMDBRATING', '5', '', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'IMDBRATING', '5', '', NULL);

