/*
             Common Public License Version 0.5

             THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF
             THIS COMMON PUBLIC LICENSE ("AGREEMENT"). ANY USE,
             REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
             RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.

             1. DEFINITIONS

             "Contribution" means: 
                   a) in the case of the initial Contributor, the
                   initial code and documentation distributed under
                   this Agreement, and 

                   b) in the case of each subsequent Contributor:
                   i) changes to the Program, and
                   ii) additions to the Program;

                   where such changes and/or additions to the Program
                   originate from and are distributed by that
                   particular Contributor. A Contribution 'originates'
                   from a Contributor if it was added to the Program
                   by such Contributor itself or anyone acting on such
                   Contributor's behalf. Contributions do not include
                   additions to the Program which: (i) are separate
                   modules of software distributed in conjunction with
                   the Program under their own license agreement, and
                   (ii) are not derivative works of the Program.


             "Contributor" means any person or entity that distributes
             the Program.

             "Licensed Patents " mean patent claims licensable by a
             Contributor which are necessarily infringed by the use or
             sale of its Contribution alone or when combined with the
             Program. 

             "Program" means the Contributions distributed in
             accordance with this Agreement.

             "Recipient" means anyone who receives the Program under
             this Agreement, including all Contributors.

             2. GRANT OF RIGHTS

                   a) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free copyright
                   license to reproduce, prepare derivative works of,
                   publicly display, publicly perform, distribute and
                   sublicense the Contribution of such Contributor, if
                   any, and such derivative works, in source code and
                   object code form.

                   b) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free patent
                   license under Licensed Patents to make, use, sell,
                   offer to sell, import and otherwise transfer the
                   Contribution of such Contributor, if any, in source
                   code and object code form. This patent license
                   shall apply to the combination of the Contribution
                   and the Program if, at the time the Contribution is
                   added by the Contributor, such addition of the
                   Contribution causes such combination to be covered
                   by the Licensed Patents. The patent license shall
                   not apply to any other combinations which include
                   the Contribution. No hardware per se is licensed
                   hereunder.

                   c) Recipient understands that although each
                   Contributor grants the licenses to its
                   Contributions set forth herein, no assurances are
                   provided by any Contributor that the Program does
                   not infringe the patent or other intellectual
                   property rights of any other entity. Each
                   Contributor disclaims any liability to Recipient
                   for claims brought by any other entity based on
                   infringement of intellectual property rights or
                   otherwise. As a condition to exercising the rights
                   and licenses granted hereunder, each Recipient
                   hereby assumes sole responsibility to secure any
                   other intellectual property rights needed, if any.

                   For example, if a third party patent license is
                   required to allow Recipient to distribute the
                   Program, it is Recipient's responsibility to
                   acquire that license before distributing the
                   Program.

                   d) Each Contributor represents that to its
                   knowledge it has sufficient copyright rights in its
                   Contribution, if any, to grant the copyright
                   license set forth in this Agreement.

             3. REQUIREMENTS

             A Contributor may choose to distribute the Program in
             object code form under its own license agreement, provided
             that:
                   a) it complies with the terms and conditions of
                   this Agreement; and

                   b) its license agreement:
                   i) effectively disclaims on behalf of all
                   Contributors all warranties and conditions, express
                   and implied, including warranties or conditions of
                   title and non-infringement, and implied warranties
                   or conditions of merchantability and fitness for a
                   particular purpose;

                   ii) effectively excludes on behalf of all
                   Contributors all liability for damages, including
                   direct, indirect, special, incidental and
                   consequential damages, such as lost profits;

                   iii) states that any provisions which differ from
                   this Agreement are offered by that Contributor
                   alone and not by any other party; and

                   iv) states that source code for the Program is
                   available from such Contributor, and informs
                   licensees how to obtain it in a reasonable manner
                   on or through a medium customarily used for
                   software exchange.

             When the Program is made available in source code form:
                   a) it must be made available under this Agreement;
                   and
                   b) a copy of this Agreement must be included with
                   each copy of the Program. 

             Contributors may not remove or alter any copyright notices
             contained within the Program.

             Each Contributor must identify itself as the originator of
             its Contribution, if any, in a manner that reasonably
             allows subsequent Recipients to identify the originator of
             the Contribution. 


             4. COMMERCIAL DISTRIBUTION

             Commercial distributors of software may accept certain
             responsibilities with respect to end users, business
             partners and the like. While this license is intended to
             facilitate the commercial use of the Program, the
             Contributor who includes the Program in a commercial
             product offering should do so in a manner which does not
             create potential liability for other Contributors.
             Therefore, if a Contributor includes the Program in a
             commercial product offering, such Contributor ("Commercial
             Contributor") hereby agrees to defend and indemnify every
             other Contributor ("Indemnified Contributor") against any
             losses, damages and costs (collectively "Losses") arising
             from claims, lawsuits and other legal actions brought by a
             third party against the Indemnified Contributor to the
             extent caused by the acts or omissions of such Commercial
             Contributor in connection with its distribution of the
             Program in a commercial product offering. The obligations
             in this section do not apply to any claims or Losses
             relating to any actual or alleged intellectual property
             infringement. In order to qualify, an Indemnified
             Contributor must: a) promptly notify the Commercial
             Contributor in writing of such claim, and b) allow the
             Commercial Contributor to control, and cooperate with the
             Commercial Contributor in, the defense and any related
             settlement negotiations. The Indemnified Contributor may
             participate in any such claim at its own expense.


             For example, a Contributor might include the Program in a
             commercial product offering, Product X. That Contributor
             is then a Commercial Contributor. If that Commercial
             Contributor then makes performance claims, or offers
             warranties related to Product X, those performance claims
             and warranties are such Commercial Contributor's
             responsibility alone. Under this section, the Commercial
             Contributor would have to defend claims against the other
             Contributors related to those performance claims and
             warranties, and if a court requires any other Contributor
             to pay any damages as a result, the Commercial Contributor
             must pay those damages.


             5. NO WARRANTY

             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE
             PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT
             WARRANTIES OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR
             IMPLIED INCLUDING, WITHOUT LIMITATION, ANY WARRANTIES OR
             CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR
             FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is solely
             responsible for determining the appropriateness of using
             and distributing the Program and assumes all risks
             associated with its exercise of rights under this
             Agreement, including but not limited to the risks and
             costs of program errors, compliance with applicable laws,
             damage to or loss of data, programs or equipment, and
             unavailability or interruption of operations. 

             6. DISCLAIMER OF LIABILITY
             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER
             RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY
             FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
             OR CONSEQUENTIAL DAMAGES (INCLUDING WITHOUT LIMITATION
             LOST PROFITS), HOWEVER CAUSED AND ON ANY THEORY OF
             LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
             (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
             OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE
             OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
             POSSIBILITY OF SUCH DAMAGES.

             7. GENERAL

             If any provision of this Agreement is invalid or
             unenforceable under applicable law, it shall not affect
             the validity or enforceability of the remainder of the
             terms of this Agreement, and without further action by the
             parties hereto, such provision shall be reformed to the
             minimum extent necessary to make such provision valid and
             enforceable.


             If Recipient institutes patent litigation against a
             Contributor with respect to a patent applicable to
             software (including a cross-claim or counterclaim in a
             lawsuit), then any patent licenses granted by that
             Contributor to such Recipient under this Agreement shall
             terminate as of the date such litigation is filed. In
             addition, If Recipient institutes patent litigation
             against any entity (including a cross-claim or
             counterclaim in a lawsuit) alleging that the Program
             itself (excluding combinations of the Program with other
             software or hardware) infringes such Recipient's
             patent(s), then such Recipient's rights granted under
             Section 2(b) shall terminate as of the date such
             litigation is filed.

             All Recipient's rights under this Agreement shall
             terminate if it fails to comply with any of the material
             terms or conditions of this Agreement and does not cure
             such failure in a reasonable period of time after becoming
             aware of such noncompliance. If all Recipient's rights
             under this Agreement terminate, Recipient agrees to cease
             use and distribution of the Program as soon as reasonably
             practicable. However, Recipient's obligations under this
             Agreement and any licenses granted by Recipient relating
             to the Program shall continue and survive. 

             Everyone is permitted to copy and distribute copies of
             this Agreement, but in order to avoid inconsistency the
             Agreement is copyrighted and may only be modified in the
             following manner. The Agreement Steward reserves the right
             to publish new versions (including revisions) of this
             Agreement from time to time. No one other than the
             Agreement Steward has the right to modify this Agreement.

             IBM is the initial Agreement Steward. IBM may assign the
             responsibility to serve as the Agreement Steward to a
             suitable separate entity. Each new version of the
             Agreement will be given a distinguishing version number.
             The Program (including Contributions) may always be
             distributed subject to the version of the Agreement under
             which it was received. In addition, after a new version of
             the Agreement is published, Contributor may elect to
             distribute the Program (including its Contributions) under
             the new version. Except as expressly stated in Sections
             2(a) and 2(b) above, Recipient receives no rights or
             licenses to the intellectual property of any Contributor
             under this Agreement, whether expressly, by implication,
             estoppel or otherwise. All rights in the Program not
             expressly granted under this Agreement are reserved.


             This Agreement is governed by the laws of the State of New
             York and the intellectual property laws of the United
             States of America. No party to this Agreement will bring a
             legal action under this Agreement more than one year after
             the cause of action arose. Each party waives its rights to
             a jury trial in any resulting litigation. 



*/

/* (C) COPYRIGHT International Business Machines Corp. 2001          */


#include <unistd.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <errno.h>
#include <stdio.h>
#include <dlfcn.h>
#include <termios.h>
#include <pkcs11types.h>
#include <locale.h>
#include <nl_types.h>
#include <memory.h>
#include <string.h>
#include <strings.h>
#include "slotmgr.h"
#include "pkcsconf_msg.h"

#define MSG_SET MS_PKCSINIT
nl_catd catd;
#define PKCSINIT_MSG(n,s) catgets(catd,MSG_SET,n,s)

#define LEEDS_DEFAULT_PIN "87654321"
#define PIN_SIZE 80
#define BACK_SPACE 8
#define DELETE     127
#define LINE_FEED  10

#define CFG_SO_PIN         0x0001
#define CFG_USER_PIN       0x0002
#define CFG_SLOT           0x0004
#define CFG_PKCS_INFO      0x0008
#define CFG_TOKEN_INFO     0x0010
#define CFG_SLOT_INFO      0x0020
#define CFG_MECHANISM_INFO 0x0040
#define CFG_INITIALIZE     0x0080
#define CFG_INIT_USER      0x0100
#define CFG_SET_USER       0x0200
#define CFG_SET_SO         0x0400
#define CFG_NEW_PIN        0x0800
#define CFG_SHARED_MEM     0x1000
#define CFG_LIST_SLOT      0x2000

CK_RV init(void);
void  usage(char *);
int   echo(int);
void  get_pin(CK_CHAR **);
CK_RV cleanup(void);
CK_RV display_pkcs11_info(void);
CK_RV get_slot_list(int, CK_CHAR_PTR);
CK_RV display_slot_info(void);
CK_RV display_token_info(void);
CK_RV display_mechanism_info(void);
void  display_shared_memory(void);
void *attach_shared_memory(void);
void  detach_shared_memory(char *);
CK_RV validate_slot(CK_CHAR_PTR);
CK_RV init_token(CK_CHAR_PTR);
CK_RV init_user_pin(CK_CHAR_PTR, CK_CHAR_PTR);
CK_RV list_slot(void);
CK_RV set_user_pin(CK_USER_TYPE, CK_CHAR_PTR, CK_CHAR_PTR);

void * dllPtr;
CK_FUNCTION_LIST_PTR  FunctionPtr = NULL;
CK_SLOT_ID_PTR        SlotList = NULL;
CK_ULONG              SlotCount = 0;
Slot_Mgr_Shr_t *      shmp = NULL;
int in_slot;

int
main(int argc, char *argv[]){
   CK_RV rc = CKR_OK;          // Return Code
   CK_FLAGS flags = 0;         // Bit mask for what options were passed in
   CK_CHAR_PTR sopin = NULL,   // The Security Office PIN
               pin = NULL,     // The User PIN
               newpin = NULL,  // To store PIN changes
               newpin2 = NULL, // To store validation of PIN change
               slot = NULL;    // The PKCS slot number

   int c,                      // To store passed in options
       errflag = 0;            // Error Flag

   /* Open the Message Catalog */
   setlocale(LC_ALL, "");
   catd = catopen(MF_PKCSCONF,0);

   /* Parse the command line parameters */
   while ((c = getopt (argc, argv, "itsmMIc:S:U:upPn:l")) != (-1)){
      switch (c){
         case 'c':  /* a specific card (slot) is specified */
            flags |= CFG_SLOT;
            slot = (CK_CHAR_PTR) malloc(strlen(optarg));
            memcpy(slot, optarg, strlen(optarg));
            break;
         case 'S':  /* the SO pin */
            flags |= CFG_SO_PIN;
            sopin = (CK_CHAR_PTR) malloc(strlen(optarg));
            memcpy(sopin, optarg, strlen(optarg));
            break;
         case 'U':  /* the user pin */
            flags |= CFG_USER_PIN;
            pin = (CK_CHAR_PTR) malloc(strlen(optarg));
            memcpy(pin, optarg, strlen(optarg));
            break;
         case 'n':  /* the new pin */
            flags |= CFG_NEW_PIN;
            newpin = (CK_CHAR_PTR) malloc(strlen(optarg));
            memcpy(newpin, optarg, strlen(optarg));
            break;
         case 'i':  /* display PKCS11 info */
            flags |= CFG_PKCS_INFO;
            break;
         case 't':  /* display token info */
            flags |= CFG_TOKEN_INFO;
            break;
         case 's':  /* display slot info */
            flags |= CFG_SLOT_INFO;
            break;
         case 'm':  /* display mechanism info */
            flags |= CFG_MECHANISM_INFO;
            break;
#if SHM
         case 'M':  /* display shared memory */
            flags |= CFG_SHARED_MEM;
            break;
#endif
         case 'I':  /* initialize the token */
            flags |= CFG_INITIALIZE;
            break;
         case 'u':  /* initialize the user PIN */
            flags |= CFG_INIT_USER;
            break;
         case 'p':  /* set the user PIN */
            flags |= CFG_SET_USER;
            break;
         case 'P':  /* set the SO PIN */
            flags |= CFG_SET_SO;
            break;
         case 'l':  /* display slot description */
            flags |= CFG_LIST_SLOT;
            break;
         default:   /* if something else was passed in it is an error */
            errflag++;
            break;
      }
   }
   if (errflag != 0)  /* If there was an error print the usage statement */
       usage(argv[0]);

   /* Eliminate the ability to specify -I -p -u -P without a slot number */
   if ( (flags & (CFG_INITIALIZE | CFG_INIT_USER | CFG_SET_USER | CFG_SET_SO))
            && !(flags & CFG_SLOT)){
      usage(argv[0]);
   }
   /* Load the PKCS11 library and start the slotmanager if it is not running */
   if ( init() != CKR_OK )
	exit(-1);

#if SHM
   /* If a slot number was passed in validate the slot number */
   if (flags & CFG_SLOT)
      validate_slot(slot);
#else
   if (flags & CFG_SLOT) {
     in_slot = atol((char *)slot);
   }
#endif

   /* Get the slot list and indicate if a slot number was passed in or not */
   if (get_slot_list(flags & CFG_SLOT, slot))
      goto done;

   /* If the user tries to set the user and SO pin at the same time print an
    * error massage and exit indicating the function failed */
   if ((flags & CFG_SET_USER) && (flags & CFG_SET_SO)) {
      printf(PKCSINIT_MSG(EXCLUSION,
               "Setting the SO and user PINs are mutually exclusive.\n"));
      fflush(stdout);
      return CKR_FUNCTION_FAILED;
   }

   /* If the user wants to display PKCS11 info call the function to do so */
   if (flags & CFG_PKCS_INFO)
      display_pkcs11_info();

   /* If the user wants to display token info call the function to do so */
   if (flags & CFG_TOKEN_INFO)
      display_token_info();

   /* If the user wants to display slot info call the function to do so */
   if (flags & CFG_SLOT_INFO)
      display_slot_info();

   /* If the user wants to display slot info call the function to do so */
   if (flags & CFG_LIST_SLOT)
      list_slot();

   /* If the user wants to display mechanism info call the function to do so */
   if (flags & CFG_MECHANISM_INFO)
      display_mechanism_info();

#if SHM
   /* If the user wants to display shared memory info call the function to do so */
   if (flags & CFG_SHARED_MEM)
      display_shared_memory();
#endif

   /* If the user wants to initialize the card check to see if they passed in
    * the SO pin, if not ask for the PIN */
   if (flags & CFG_INITIALIZE){
      if (~flags & CFG_SO_PIN){
         printf(PKCSINIT_MSG(SOPIN, "Enter the SO PIN: "));
         fflush(stdout);
         get_pin(&(sopin));
      }
      rc = init_token(sopin);
   }

   /* If the user wants to initialize the User PIN, check to see if they have
    * passed in the SO PIN, if not ask for it.  Then check to see if they passed
    * the New User PIN on the command line if not ask for the PIN and verify it */
   if (flags & CFG_INIT_USER){
      if (~flags & CFG_SO_PIN) {
         printf(PKCSINIT_MSG(SOPIN, "Enter the SO PIN: "));
         fflush(stdout);
         get_pin(&sopin);
      }
      if (~flags & CFG_NEW_PIN) {
         printf(PKCSINIT_MSG(NEWUSER, "Enter the new user PIN: "));
         fflush(stdout);
         get_pin(&newpin);
         printf(PKCSINIT_MSG(VNEWUSER, "Re-enter the new user PIN: "));
         fflush(stdout);
         get_pin(&newpin2);
         if (! memcmp(newpin, newpin2, strlen((char *)newpin)) == 0) {
            printf(PKCSINIT_MSG(PINMISMATCH, "New PINs do not match.\n"));
            fflush(stdout);
            exit(CKR_PIN_INVALID);
         }
      }
      rc = init_user_pin(newpin, sopin);
   }

   /* If the user wants to set the SO PIN, check to see if they have passed the
    * current SO PIN and the New PIN in.  If not prompt and validate them. */
   if (flags & CFG_SET_SO){
      if (~flags & CFG_SO_PIN) {
         printf(PKCSINIT_MSG(SOPIN, "Enter the SO PIN: "));
         fflush(stdout);
         get_pin(&sopin);
      }
      if (~flags & CFG_NEW_PIN) {
         printf(PKCSINIT_MSG(NEWSO, "Enter the new SO PIN: "));
         fflush(stdout);
         get_pin(&newpin);
         printf(PKCSINIT_MSG(VNEWSO, "Re-enter the new SO PIN: "));
         fflush(stdout);
         get_pin(&newpin2);
         if (! memcmp(newpin, newpin2, strlen((char *)newpin)) == 0) {
            printf(PKCSINIT_MSG(PINMISMATCH, "New PINs do not match.\n"));
            fflush(stdout);
            exit(CKR_PIN_INVALID);
         }
      }
      rc = set_user_pin(CKU_SO, sopin, newpin);
   }

   /* If the user wants to set the User PIN, check to see if they have passed the
    * current User PIN and the New PIN in.  If not prompt and validate them. */
   if (flags & CFG_SET_USER){
      if (~flags & CFG_USER_PIN) {
         printf(PKCSINIT_MSG(USERPIN, "Enter user PIN: "));
         fflush(stdout);
         get_pin(&pin);
      }
      if (~flags & CFG_NEW_PIN) {
         printf(PKCSINIT_MSG(NEWUSER, "Enter the new user PIN: "));
         fflush(stdout);
         get_pin(&newpin);
         printf(PKCSINIT_MSG(VNEWUSER, "Re-enter the new user PIN: "));
         fflush(stdout);
         get_pin(&newpin2);
         if (! memcmp(newpin, newpin2, strlen((char *)newpin)) == 0) {
            printf(PKCSINIT_MSG(PINMISMATCH, "New PINs do not match.\n"));
            fflush(stdout);
            exit(CKR_PIN_INVALID);
         }
      }
      rc = set_user_pin(CKU_USER, pin, newpin);
   }

   /* We are done, detach from shared memory, and free the memory we may have
    * allocated.  In the case of PIN's we bzero them to ensure that they are not
    * left around in system memory*/

done:
#if SHM
     detach_shared_memory((char *)shmp);
     free (slot);
#endif

   if (sopin) {
     bzero (sopin, strlen((char *)sopin));
     free (sopin);
   }

   if (pin) {
      bzero (pin, strlen((char *)pin));
      free (pin);
   }

   if (newpin) {
      bzero (newpin, strlen((char *)newpin));
      free (newpin);
   }

   return rc;

}

void
get_pin(CK_CHAR ** pin){
   int  size = PIN_SIZE, count = 0;
   char buff[PIN_SIZE] = { 0 }, c = 0;

   /* Turn off echoing to the terminal when getting the password */
   echo(FALSE);

   /* Get each character and print out a '*' for each input */
   for (count = 0; (c != LINE_FEED) && (count < PIN_SIZE); count++){
      buff[count] = getc(stdin);
      c = buff[count];
      if ((c != LINE_FEED) && (c != BACK_SPACE))
         printf("*");
      if (c == BACK_SPACE) {
         printf("%c%c%c", BACK_SPACE, ' ', BACK_SPACE);
         count-=2;
      }
      fflush(stdout);
   }

   echo(TRUE);

   /* After we get the password go to the next line */
   printf("\n");
   fflush(stdout);

   /* Allocate 80 bytes for the user PIN.  This is large enough for the tokens
    * supported in AIX 5.0 and 5.1 */
   *pin = (unsigned char *)malloc(PIN_SIZE);

   /* Strip the carage return from the user input (it is not part of the PIN)
    * and put the PIN in the return buffer */
   buff[count-1] =  '\0'; //NULL; 
   strncpy((char *)*pin, buff, strlen((char *)buff)+1); // keep the trailing null for the strlen
}

int
echo(int bool){
   struct termios term;

   /* flush standard out to make sure everything that needs to be displayed has
    * been displayed */
   fflush(stdout);

   /* get the current terminal attributes */
   if (tcgetattr(STDIN_FILENO, &term) != 0)
      return -1;

   /* Since we are calling this function we must want to read in a char at a
    * time.  Therefore set the cc structure before setting the terminal attrs */
   term.c_cc[VMIN] = 1;
   term.c_cc[VTIME] = 0;

   /* If we are turning off the display of input characters AND with the inverse
    * of the ECHO mask, if we are turning on the display OR with the ECHO mask. 
    * We also set if we are reading in canonical or noncanonical mode.  */
   if (bool)
      term.c_lflag |= (ECHO | ICANON);
   else
      term.c_lflag &= ~(ECHO | ICANON);

   /* Set the attributes, and flush the streams so that any input already
    * displayed on the terminal is invalid */
   if (tcsetattr(STDIN_FILENO, TCSAFLUSH, &term) != 0)
      return -1;

   return 0;
}

#if SHM
void
display_shared_memory(void){
   int lcv;  // Loop control variable

   /* display message headers */
   printf(PKCSINIT_MSG(SHMEM, "Shared Memory Data\n"));
   printf(PKCSINIT_MSG(SLOTNUMS, "\tNumber of Slots: %d\n"), shmp->num_slots);

   /* go through all the slots and display the shared memeory information */
   for (lcv = 0; lcv < shmp->num_slots; lcv++) {
      printf("\n");
      printf(PKCSINIT_MSG(SLOTNUM, "\tSlot Number: %d\n"),
               shmp->slot_info[lcv].slot_number);
      printf(PKCSINIT_MSG(PRESENT, "\tPresent: %d\n"), shmp->slot_info[lcv].present);
      printf(PKCSINIT_MSG(DLLLOC, "\tDLL Location: %s\n"),
            shmp->slot_info[lcv].dll_location);
      printf(PKCSINIT_MSG(INITFCN, "\tInit Function: %s\n"),
            shmp->slot_info[lcv].slot_init_fcn);
      printf(PKCSINIT_MSG(COORELATE, "\tCoorelator: %s\n"),
            shmp->slot_info[lcv].correlator);
      printf(PKCSINIT_MSG(GLOBAL, "\tGlobal Sessions: 0x%X\n"),
            shmp->slot_info[lcv].global_sessions);
   }
}
#endif

CK_RV
display_pkcs11_info(void){

   CK_RV rc;
   CK_INFO CryptokiInfo;

   /* Get the PKCS11 infomation structure and if fails print message */
   rc = FunctionPtr->C_GetInfo(&CryptokiInfo);
   if (rc != CKR_OK) {
      printf(PKCSINIT_MSG(INFOERROR, "Error getting PKCS#11 info: 0x%X\n"), rc);
      return rc;
   }

   /* display the header and information */
   printf(PKCSINIT_MSG(PKCSINFO, "PKCS#11 Info\n"));
   printf(PKCSINIT_MSG((int)VERSION, "\tVersion %d.%d \n"), CryptokiInfo.cryptokiVersion.major,
         CryptokiInfo.cryptokiVersion.minor);
   printf(PKCSINIT_MSG(MANUFACT, "\tManufacturer: %32s \n"), CryptokiInfo.manufacturerID);
   printf(PKCSINIT_MSG(FLAGS, "\tFlags: 0x%X  \n"), CryptokiInfo.flags);
   printf(PKCSINIT_MSG(LIBDESCRIPT, "\tLibrary Description: %32s \n"),
         CryptokiInfo.libraryDescription);
   printf(PKCSINIT_MSG(LIBVERSION, "\tLibrary Version %d.%d \n"),
         CryptokiInfo.libraryVersion.major,
         CryptokiInfo.libraryVersion.minor);

   return rc;
}

CK_RV
get_slot_list(int cond, CK_CHAR_PTR slot){
   int                   lcv;                  // Loop control variable
   CK_RV                 rc;                   // Return Code
   CK_SLOT_ID_PTR        TempSlotList = NULL;  // Temporary Slot List

   /* Find out how many tokens are present in slots */
   rc = FunctionPtr->C_GetSlotList(TRUE, NULL_PTR, &SlotCount);
   if (rc != CKR_OK) {
      printf(PKCSINIT_MSG(SLOTERROR, "Error getting number of slots: 0x%X\n"), rc);
      return rc;
   }

   if (SlotCount == 0) {
      printf("C_GetSlotCount returned 0 slots. Check that your tokens"
		" are installed correctly.\n");
      return -ENODEV;
   }

   /* Allocate enough space for the slots information */
   SlotList = (CK_SLOT_ID_PTR) malloc(SlotCount * sizeof(CK_SLOT_ID));

   rc = FunctionPtr->C_GetSlotList(TRUE, SlotList, &SlotCount);
   if (rc != CKR_OK) {
      printf(PKCSINIT_MSG(LISTERROR, "Error getting slot list: 0x%X\n"), rc);
      return rc;
   }

   /* If the conditional variable cond is true then slot should
    * contain a char string representing a slot number to examine.
    * The validate_slot function has already been run, therefore we now that
    * the slot exsists in the system. */
   if (cond) {

      /* NOTE: This function changes slot list to not be the PKCS11 slot list,
       * but instead the list of slots which we are going to be working with.
       * This allows us to do the same operation on multiple slots; however, the
       * configuration routines currently expect only one slot to be passed in
       * with the -c flag.  Therefore, the slot list will contain only the slot
       * passed in with the -c flag. */

      TempSlotList = (CK_SLOT_ID_PTR) malloc(sizeof(CK_SLOT_ID));

      /* The validate_slot function set the variable in_slot to tell
       * us the array position of the passed in card.  We can therefore
       * use this position and assume it is valid. */
      *TempSlotList = SlotList[in_slot];

      free (SlotList);
      SlotList = (CK_SLOT_ID_PTR) malloc(sizeof(CK_SLOT_ID));

      *SlotList = *TempSlotList;
      SlotCount = 1;

      free (TempSlotList);
   }

   return CKR_OK;
}

CK_RV
display_mechanism_info(void){
   CK_RV          rc;                  // Return Code
   CK_MECHANISM_TYPE_PTR MechanismList = NULL;  // Head to Mechanism list
   CK_MECHANISM_INFO MechanismInfo;    // Structure to hold Mechanism Info
   CK_ULONG       MechanismCount = 0;  // Number of supported mechanisms
   unsigned int   lcv, lcv2;           // Loop Control Variables

   for (lcv = 0; lcv < SlotCount; lcv++){
      /* For each slot find out how many mechanisms are supported */
      rc = FunctionPtr->C_GetMechanismList(SlotList[lcv], NULL_PTR,
            &MechanismCount);
      if (rc != CKR_OK) {
         printf(PKCSINIT_MSG(MECHERROR, "Error getting number of mechanisms: 0x%X\n"),
              rc);
         return rc;
      }

      /* Allocate enough memory to store all the supported mechanisms */
      MechanismList = (CK_MECHANISM_TYPE_PTR) malloc(MechanismCount *
            sizeof(CK_MECHANISM_TYPE));

      /* This time get the mechanism list */
      rc = FunctionPtr->C_GetMechanismList(SlotList[lcv], MechanismList,
            &MechanismCount);
      if (rc != CKR_OK) {
         printf(PKCSINIT_MSG(LISTERROR2, "Error getting mechanisms list: 0x%X\n"), rc);
         return rc;
      }

      /* For each Mechanism in the List */
      for (lcv2 = 0; lcv2 < MechanismCount; lcv2++){

         /* Get the Mechanism Info and display it */
         rc = FunctionPtr->C_GetMechanismInfo(SlotList[lcv],
               MechanismList[lcv2], &MechanismInfo);
         if (rc != CKR_OK) {
            printf(PKCSINIT_MSG(INFOERROR2, "Error getting mechanisms info: 0x%X\n"), rc);
            return rc;
         }
         printf(PKCSINIT_MSG(MECH, "Mechanism #%d\n"), lcv2);
         printf(PKCSINIT_MSG(MECHLABEL, "\tMechanism: 0x%X\n"), MechanismList[lcv2]);
         printf(PKCSINIT_MSG(KEYSIZE, "\tKey Size: %d-%d\n"), MechanismInfo.ulMinKeySize,
               MechanismInfo.ulMaxKeySize);
         printf(PKCSINIT_MSG(FLAGS, "\tFlags: 0x%X\n"), MechanismInfo.flags);
      }

      /* Free the memory we allocated for the mechanism list */
      free (MechanismList);
   }
   return CKR_OK;
}

CK_RV
display_slot_info(void){
   CK_RV          rc;        // Return Code
   CK_SLOT_INFO   SlotInfo;  // Structure to hold slot information
   unsigned int   lcv;       // Loop control Variable

   for (lcv = 0; lcv < SlotCount; lcv++){
      /* Get the info for the slot we are examining and store in SlotInfo*/
      rc = FunctionPtr->C_GetSlotInfo(SlotList[lcv], &SlotInfo);
      if (rc != CKR_OK) {
         printf(PKCSINIT_MSG(SLOTERROR2, "Error getting slot info: 0x%X\n"), rc);
         return rc;
      }

      /* Display the slot information */
      printf(PKCSINIT_MSG(SLOTINFO, "Slot #%d Info\n"), SlotList[lcv]);
      printf(PKCSINIT_MSG(SLOTDESC, "\tDescription: %.64s\n"), SlotInfo.slotDescription);
      printf(PKCSINIT_MSG(MANUFACT, "\tManufacturer: %.32s\n"), SlotInfo.manufacturerID);
      printf(PKCSINIT_MSG(FLAGS, "\tFlags: 0x%X ("), SlotInfo.flags);

      if (SlotInfo.flags & CKF_TOKEN_PRESENT)
	      printf(PKCSINIT_MSG(FLAGS, "TOKEN_PRESENT|"));
      if (SlotInfo.flags & CKF_REMOVABLE_DEVICE)
	      printf(PKCSINIT_MSG(FLAGS, "REMOVABLE_DEVICE|"));
      if (SlotInfo.flags & CKF_HW_SLOT)
	      printf(PKCSINIT_MSG(FLAGS, "HW_SLOT|"));
      printf(")\n");

      printf(PKCSINIT_MSG(HWVERSION, "\tHardware Version: %d.%d\n"),
            SlotInfo.hardwareVersion.major,
            SlotInfo.hardwareVersion.minor);
      printf(PKCSINIT_MSG(FWVERSION, "\tFirmware Version: %d.%d\n"),
            SlotInfo.firmwareVersion.major,
            SlotInfo.firmwareVersion.minor);
   }
   return CKR_OK;
}

CK_RV
list_slot(void){
   CK_RV          rc;        // Return code
   CK_SLOT_INFO   SlotInfo;  // Structure to hold slot information
   unsigned int   lcv;       // Loop control variable

   for (lcv = 0; lcv < SlotCount; lcv++){
      /* Get the info for the slot we are examining and store in SlotInfo*/
      rc = FunctionPtr->C_GetSlotInfo(SlotList[lcv], &SlotInfo);
      if (rc != CKR_OK) {
         printf(PKCSINIT_MSG(SLOTERROR2, "Error getting slot info: 0x%X\n"), rc);
         return rc;
      }

      /* Display the slot description */
      printf("%ld:", SlotList[lcv]);
      printf(PKCSINIT_MSG(SLOTDESC, "\tDescription: %.64s\n"), SlotInfo.slotDescription);
   }
   return CKR_OK;
}

CK_RV
display_token_info(void){
   CK_RV          rc;         // Return Code
   CK_TOKEN_INFO  TokenInfo;  // Variable to hold Token Information
   unsigned int   lcv;        // Loop control variable

   for (lcv = 0; lcv < SlotCount; lcv++){
      /* Get the Token info for each slot in the system */
      rc = FunctionPtr->C_GetTokenInfo(SlotList[lcv], &TokenInfo);
      if (rc != CKR_OK) {
         printf(PKCSINIT_MSG(TOKERROR, "Error getting token info: 0x%X\n"), rc);
         return rc;
      }

      /* Display the token information */
      printf(PKCSINIT_MSG(TOKINFO, "Token #%d Info:\n"), SlotList[lcv]);
      printf(PKCSINIT_MSG(TOKLABEL, "\tLabel: %.32s\n"), TokenInfo.label);
      printf(PKCSINIT_MSG(MANUFACT, "\tManufacturer: %.32s\n"), TokenInfo.manufacturerID);
      printf(PKCSINIT_MSG(MODEL, "\tModel: %.16s\n"), TokenInfo.model);
      printf(PKCSINIT_MSG(SERIAL, "\tSerial Number: %.16s\n"), TokenInfo.serialNumber);
      printf(PKCSINIT_MSG(FLAGS, "\tFlags: 0x%X ("), TokenInfo.flags);

      /* print more informative flag message */
      if (TokenInfo.flags & CKF_RNG)
	      printf(PKCSINIT_MSG(FLAGS, "RNG|"));
      if (TokenInfo.flags & CKF_WRITE_PROTECTED)
	      printf(PKCSINIT_MSG(FLAGS, "WRITE_PROTECTED|"));
      if (TokenInfo.flags & CKF_LOGIN_REQUIRED)
	      printf(PKCSINIT_MSG(FLAGS, "LOGIN_REQUIRED|"));
      if (TokenInfo.flags & CKF_USER_PIN_INITIALIZED)
	      printf(PKCSINIT_MSG(FLAGS, "USER_PIN_INITIALIZED|"));
      if (TokenInfo.flags & CKF_RESTORE_KEY_NOT_NEEDED)
	      printf(PKCSINIT_MSG(FLAGS, "RESTORE_KEY_NOT_NEEDED|"));
      if (TokenInfo.flags & CKF_CLOCK_ON_TOKEN)
	      printf(PKCSINIT_MSG(FLAGS, "CLOCK_ON_TOKEN|"));
      if (TokenInfo.flags & CKF_PROTECTED_AUTHENTICATION_PATH)
	      printf(PKCSINIT_MSG(FLAGS, "PROTECTED_AUTHENTICATION_PATH|"));
      if (TokenInfo.flags & CKF_DUAL_CRYPTO_OPERATIONS)
	      printf(PKCSINIT_MSG(FLAGS, "DUAL_CRYPTO_OPERATIONS|"));
      if (TokenInfo.flags & CKF_TOKEN_INITIALIZED)
	      printf(PKCSINIT_MSG(FLAGS, "TOKEN_INITIALIZED|"));
      if (TokenInfo.flags & CKF_SECONDARY_AUTHENTICATION)
	      printf(PKCSINIT_MSG(FLAGS, "SECONDARY_AUTHENTICATION|"));
      if (TokenInfo.flags & CKF_USER_PIN_COUNT_LOW)
	      printf(PKCSINIT_MSG(FLAGS, "USER_PIN_COUNT_LOW|"));
      if (TokenInfo.flags & CKF_USER_PIN_FINAL_TRY)
	      printf(PKCSINIT_MSG(FLAGS, "USER_PIN_FINAL_TRY|"));
      if (TokenInfo.flags & CKF_USER_PIN_LOCKED)
	      printf(PKCSINIT_MSG(FLAGS, "USER_PIN_LOCKED|"));
      if (TokenInfo.flags & CKF_USER_PIN_TO_BE_CHANGED)
	      printf(PKCSINIT_MSG(FLAGS, "USER_PIN_TO_BE_CHANGED|"));
      if (TokenInfo.flags & CKF_SO_PIN_COUNT_LOW)
	      printf(PKCSINIT_MSG(FLAGS, "SO_PIN_COUNT_LOW|"));
      if (TokenInfo.flags & CKF_SO_PIN_FINAL_TRY)
	      printf(PKCSINIT_MSG(FLAGS, "SO_PIN_FINAL_TRY|"));
      if (TokenInfo.flags & CKF_SO_PIN_LOCKED)
	      printf(PKCSINIT_MSG(FLAGS, "SO_PIN_LOCKED|"));
      if (TokenInfo.flags & CKF_SO_PIN_TO_BE_CHANGED)
	      printf(PKCSINIT_MSG(FLAGS, "SO_PIN_TO_BE_CHANGED|"));
      printf(")\n");

      printf(PKCSINIT_MSG(SESSIONS, "\tSessions: %d/%d\n"), TokenInfo.ulSessionCount,
            TokenInfo.ulMaxSessionCount);
      printf(PKCSINIT_MSG(RWSESSIONS, "\tR/W Sessions: %d/%d\n"),
            TokenInfo.ulRwSessionCount, TokenInfo.ulMaxRwSessionCount);
      printf(PKCSINIT_MSG(PINLEN, "\tPIN Length: %d-%d\n"), TokenInfo.ulMinPinLen,
            TokenInfo.ulMaxPinLen);
      printf(PKCSINIT_MSG(PUBMEM, "\tPublic Memory: 0x%X/0x%X\n"),
            TokenInfo.ulFreePublicMemory, TokenInfo.ulTotalPublicMemory);
      printf(PKCSINIT_MSG(PRIVMEM, "\tPrivate Memory: 0x%X/0x%X\n"),
            TokenInfo.ulFreePrivateMemory, TokenInfo.ulTotalPrivateMemory);
      printf(PKCSINIT_MSG(HWVERSION, "\tHardware Version: %d.%d\n"), TokenInfo.hardwareVersion.major,
            TokenInfo.hardwareVersion.minor);
      printf(PKCSINIT_MSG(FWVERSION, "\tFirmware Version: %d.%d\n"),
            TokenInfo.firmwareVersion.major,
            TokenInfo.firmwareVersion.minor);
      printf(PKCSINIT_MSG(TIME, "\tTime: %.16s\n"), TokenInfo.utcTime);
   }
   return CKR_OK;
}

CK_RV
init_token(CK_CHAR_PTR pin){
   /* Note this function reinitializes a token to the state it was
    * in just after the initial install of the microcode (clu files).
    * It does the following actions (if SO pin is correct):
    *   (1) Purges all Token Objects
    *   (2) Resets SO PIN back ot the default
    *   (3) Purges the USER PIN
    *   (4) Sets the Token Label
    */

   CK_RV rc;                     // Return Code
   CK_ULONG    pinlen;           // Length of the PIN
   CK_CHAR     label[32],        // What we want to set the Label of the card to
               enteredlabel[33]; // Max size of 32 + carriage return;

   unsigned int lcv;             // Loop Control Varable

   /* Find out the size of the entered PIN */
   pinlen = strlen((char *)pin);

   /* Get the token label from the user, NOTE it states to give a unique label
    * but it is never verified as unique.  This is becuase Netscape requires a
    * unique token label; however the PKCS11 spec does not.  */
   printf(PKCSINIT_MSG(GETLABEL, "Enter a unique token label: "));
   fflush(stdout);
   fgets((char *)enteredlabel, sizeof(enteredlabel), stdin);

   /* First clear the label array.  We must have 32 characters for PADDING then
    * we start all labels with 'IBM 4758 - ' therefore we use some of the label
    * information for our own use.  This is primarily done for support reasons,
    * we are able to look at the labels and determine what is in the system */
   memset(label, ' ', 32);
   strncpy((char *)label, (char *)enteredlabel, strlen((char *)enteredlabel) - 1);   // Strip the \n

   /* It is possible to initialize all tokens although this would not give us a
    * unique token label would it?  Normally this would be called with only one
    * token in the slot list.  Slot list is not the slot list of the system only
    * a list of slots we are working with */
   for (lcv = 0; lcv < SlotCount; lcv++){
      rc = FunctionPtr->C_InitToken(SlotList[lcv], pin,
            pinlen, label);
      if (rc != CKR_OK) {
         if (rc == CKR_PIN_INCORRECT) {
            printf(PKCSINIT_MSG(INCORRECTPIN, "Incorrect PIN Entered.\n"));
            fflush(stdout);
         }
         else {
            printf(PKCSINIT_MSG(INITERROR, "Error initializing token: 0x%X\n"), rc);
            fflush(stdout);
         }
         return rc;
      }
   }

   return CKR_OK;
}

CK_RV
init_user_pin(CK_CHAR_PTR pin, CK_CHAR_PTR sopin){
   CK_RV rc;                           // Return Value
   CK_FLAGS    flags = 0;              // Mask that we will use when opening the session 
   CK_SESSION_HANDLE session_handle;   // The session handle we get
   CK_ULONG pinlen, sopinlen;          // Length of the user and SO PINs

   /* get the length of the PINs */
   pinlen = strlen((char *)pin);
   sopinlen = strlen((char *)sopin);

   /* set the mask we will use for Open Session */
   flags |= CKF_SERIAL_SESSION;
   flags |= CKF_RW_SESSION;

   /* We need to open a read/write session to the adapter to initialize the user
    * PIN.  Attempt to do so */
   rc = FunctionPtr->C_OpenSession(SlotList[0], flags, NULL, NULL,
         &session_handle);
   if (rc != CKR_OK){
      printf(PKCSINIT_MSG(OPENERROR, "Error opening session: 0x%X\n"), rc);
      fflush(stdout);
      return rc;
   }

   /* After the session is open, we must login as the SO to initialize the PIN */
   rc = FunctionPtr->C_Login(session_handle, CKU_SO, sopin, sopinlen);
   if (rc != CKR_OK){
      if (rc == CKR_PIN_INCORRECT) {
         printf(PKCSINIT_MSG(INCORRECTPIN, "Incorrect PIN Entered.\n"));
         fflush(stdout);
      }
      else {
         printf(PKCSINIT_MSG(LOGINERROR, "Error logging in: 0x%X\n"), rc);
         fflush(stdout);
      }
      return rc;
   }

   /* Call the function to Init the PIN */
   rc = FunctionPtr->C_InitPIN(session_handle, pin, pinlen);
   if (rc != CKR_OK){
      printf(PKCSINIT_MSG(SETPIN, "Error setting PIN: 0x%X\n"), rc);
      fflush(stdout);
   }

   /* Logout so that others can use the PIN */
   rc = FunctionPtr->C_Logout(session_handle);
   if (rc != CKR_OK){
      printf(PKCSINIT_MSG(LOGOUTERROR, "Error logging out: 0x%X\n"), rc);
      fflush(stdout);
   }

   /* Close the session */
   rc = FunctionPtr->C_CloseSession(session_handle);
   if (rc != CKR_OK){
      printf(PKCSINIT_MSG(CLOSEERROR, "Error closing session: 0x%X\n"), rc);
      fflush(stdout);
      return rc;
   }
   return CKR_OK;
}

CK_RV
set_user_pin(CK_USER_TYPE user, CK_CHAR_PTR oldpin, CK_CHAR_PTR newpin){
   CK_RV rc;                           // Return Value
   CK_FLAGS flags = 0;                 // Mash ot open the session with
   CK_SESSION_HANDLE session_handle;   // The handle of the session we will open
   CK_ULONG oldpinlen, newpinlen;      // The size of the new and ole PINS

   /* NOTE:  This function is used for both the settinf of the SO and USER pins,
    *        the CK_USER_TYPE specifes which we are changing. */

   /* Get the size of the PINs */
   oldpinlen = strlen((char *)oldpin);
   newpinlen = strlen((char *)newpin);

   /* set the flags we will open the session with */
   flags |= CKF_SERIAL_SESSION;
   flags |= CKF_RW_SESSION;

   /* Open the Session */
   rc = FunctionPtr->C_OpenSession(SlotList[0], flags, NULL, NULL,
         &session_handle);
   if (rc != CKR_OK){
      printf(PKCSINIT_MSG(OPENERROR, "Error opening session: 0x%X\n"), rc);
      fflush(stdout);
      return rc;
   }

   /* Login to the session we just created as the pkcs11 passed in USER type */
   rc = FunctionPtr->C_Login(session_handle, user, oldpin, oldpinlen);
   if (rc != CKR_OK){
      if (rc == CKR_PIN_INCORRECT) {
         printf(PKCSINIT_MSG(INCORRECTPIN, "Incorrect PIN Entered.\n"));
         fflush(stdout);
      }
      else {
         printf(PKCSINIT_MSG(LOGINERROR, "Error logging in: 0x%X\n"), rc);
         fflush(stdout);
      }
      return rc;
   }

   /* set the new PIN */
   rc = FunctionPtr->C_SetPIN(session_handle, oldpin, oldpinlen,
         newpin, newpinlen);
   if (rc != CKR_OK){
      printf(PKCSINIT_MSG(SETPIN, "Error setting PIN: 0x%X\n"), rc);
      fflush(stdout);
   }

   /* and of course clean up after ourselves */
   rc = FunctionPtr->C_CloseSession(session_handle);
   if (rc != CKR_OK){
      printf(PKCSINIT_MSG(CLOSEERROR, "Error closing session: 0x%X\n"), rc);
      fflush(stdout);
      return rc;
   }

   return CKR_OK;
}

CK_RV
init(void){
   CK_RV rc = CKR_OK;    // Return Code
   void (*symPtr)();     // Pointer for the Dll

   /* Open the PKCS11 API shared library, and inform the user is there is an
    * error */
   /* The host machine should have the right library in the
    * LD_LIBRARY_PATH */
/*   if (sizeof(CK_ULONG) == 4) 
      dllPtr = dlopen("/usr/lib/pkcs11/PKCS11_API.so", RTLD_NOW);
   else
   dllPtr = dlopen("/usr/lib/pkcs11/PKCS11_API.so64", RTLD_NOW); */
   dllPtr = dlopen("libopencryptoki.so", RTLD_NOW);
   if (!dllPtr) {
      printf(PKCSINIT_MSG(LOADERROR, "Error loading PKCS#11 library: 0x%X\n"), rc);
      printf(PKCSINIT_MSG(LOADERROR, "dlopen error: %s\n"), dlerror());
      fflush(stdout);
      return -1;
   }

   /* Get the list of the PKCS11 functions this token support */
   symPtr = (void (*)())dlsym(dllPtr, "C_GetFunctionList");
   if (!symPtr) {
      rc = errno;
      printf(PKCSINIT_MSG(FUNCTERROR, "Error getting function list: 0x%X\n"), rc);
      fflush(stdout);
      return rc;
   }

   symPtr(&FunctionPtr);

#if SHM
   /* Since this program uses PKCS11 function calls we need to make sure that
    * the slot daemon is running.  If the shared memory is created, then we
    * know slot manager is running.  Therefore, if we fail to attach to the
    * memory, we assume that slots is not running and attempt to start it.
    * After 1/2 second we try again and if it fails we fail. */
   if ((shmp = attach_shared_memory()) == NULL) {
       system("/usr/sbin/pkcsslotd");
       usleep(500);
       if ((shmp = attach_shared_memory()) == NULL) {
            printf(PKCSINIT_MSG(SLOTMGRERROR,
                    "Error communicating with slot manager: 0x%x\n"), errno);
            fflush(stdout);
            cleanup();
       }
   }
#endif

   /* If we get here we know the slot manager is running and we can use PKCS11
    * calls, so we will execute the PKCS11 Initilize command. */
   rc = FunctionPtr->C_Initialize(NULL);
   if (rc != CKR_OK) {
      printf(PKCSINIT_MSG(LIBERROR, "Error initializing the PKCS11 library: 0x%X\n"), rc);
      fflush(stdout);
      cleanup();
   }

   return CKR_OK;
}

CK_RV
cleanup(void){
   CK_RV rc;  // Return Code

   /* To clean up we will free the slot list we create, call the Finalize
    * routine for PKCS11 and close the dynamically linked library */
   free (SlotList);
   rc = FunctionPtr->C_Finalize(NULL);
   if (dllPtr)
      dlclose(dllPtr);

   exit (rc);
}

void
usage(char *progname){

   /* If we get here the user needs help, so give it to them */
   printf(PKCSINIT_MSG(USAGE,
           "usage:\t%s [-itsmMIupP] [-c slotnumber -U userPIN -S SOPin -n newpin]\n"),
           progname);
   printf(PKCSINIT_MSG(USAGE1, "\t-i display PKCS11 info\n"));
   printf(PKCSINIT_MSG(USAGE2, "\t-t display token info\n"));
   printf(PKCSINIT_MSG(USAGE3, "\t-s display slot info\n"));
   printf(PKCSINIT_MSG(USAGE4, "\t-m display mechanism list\n"));
   printf(PKCSINIT_MSG(USAGE6, "\t-I initialize token \n"));
   printf(PKCSINIT_MSG(USAGE7, "\t-u initialize user PIN\n"));
   printf(PKCSINIT_MSG(USAGE8, "\t-p set the user PIN\n"));
   printf(PKCSINIT_MSG(USAGE9, "\t-P set the SO PIN\n"));

   exit(-1);
}

#if SHM
void *
attach_shared_memory() {

   key_t  tok;
   int    shmid;
   char   *shmp;
   struct stat statbuf;

   // Really should fstat the tok_path

   if (stat(TOK_PATH,&statbuf) < 0 ){
      // The Stat token origin file does not work... Kick it out
      return NULL;
   }

   tok = ftok(TOK_PATH,'b');

   // Get the shared memory id.
   shmid = shmget(tok,sizeof(Slot_Mgr_Shr_t),
               S_IROTH|S_IWOTH|S_IWUSR|S_IWGRP|S_IRGRP|S_IRUSR|S_IWUSR);
   if ( shmid < 0 ) {
      return NULL;
   }


   /* Attach to shared memroy */
   shmp = (void *)shmat(shmid,NULL,0);
   if ( !shmp ) {
      return NULL;
   }

   return shmp;
}

void
detach_shared_memory (char *shmp) {

   /* We could call the shmdt (shared memory detatch) directly but this is more
    * readable */
   shmdt(shmp);
}

CK_RV
validate_slot(CK_CHAR_PTR slot) {
   int lcv;                // Loop control variable
   long slot_num;          // integer value for the slot (long should be large enough)
   CK_BOOL valid = FALSE;  // Conditional variable

   /* Make sure the slot passed in is not NULL */
   if (! slot)
      return CKR_ATTRIBUTE_VALUE_INVALID;
   slot_num = atol(slot);

   for(lcv = 0; lcv < shmp->num_slots; lcv++) {
      /* Compare what is in shared memory to the slot passed in */
      if (shmp->slot_info[lcv].slot_number == slot_num) {
         valid = TRUE;   // indicate the slot is valid
         in_slot = lcv;  // set the slot value to be array position
         break;          // no need to check the rest
      }
   }

   if (valid)
      return CKR_OK;
   else {
      /* This should really read Slot, but since translation has been done this
       * will need to wait until 5.1 to be translated correctly */
      printf(PKCSINIT_MSG(INVALIDCARD, "Invalid Card: %s\n"), slot);
      fflush(stdout);
      return CKR_ATTRIBUTE_VALUE_INVALID;
   }
}
#endif
