/*
             Common Public License Version 0.5

             THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF
             THIS COMMON PUBLIC LICENSE ("AGREEMENT"). ANY USE,
             REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
             RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.

             1. DEFINITIONS

             "Contribution" means: 
                   a) in the case of the initial Contributor, the
                   initial code and documentation distributed under
                   this Agreement, and 

                   b) in the case of each subsequent Contributor:
                   i) changes to the Program, and
                   ii) additions to the Program;

                   where such changes and/or additions to the Program
                   originate from and are distributed by that
                   particular Contributor. A Contribution 'originates'
                   from a Contributor if it was added to the Program
                   by such Contributor itself or anyone acting on such
                   Contributor's behalf. Contributions do not include
                   additions to the Program which: (i) are separate
                   modules of software distributed in conjunction with
                   the Program under their own license agreement, and
                   (ii) are not derivative works of the Program.


             "Contributor" means any person or entity that distributes
             the Program.

             "Licensed Patents " mean patent claims licensable by a
             Contributor which are necessarily infringed by the use or
             sale of its Contribution alone or when combined with the
             Program. 

             "Program" means the Contributions distributed in
             accordance with this Agreement.

             "Recipient" means anyone who receives the Program under
             this Agreement, including all Contributors.

             2. GRANT OF RIGHTS

                   a) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free copyright
                   license to reproduce, prepare derivative works of,
                   publicly display, publicly perform, distribute and
                   sublicense the Contribution of such Contributor, if
                   any, and such derivative works, in source code and
                   object code form.

                   b) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free patent
                   license under Licensed Patents to make, use, sell,
                   offer to sell, import and otherwise transfer the
                   Contribution of such Contributor, if any, in source
                   code and object code form. This patent license
                   shall apply to the combination of the Contribution
                   and the Program if, at the time the Contribution is
                   added by the Contributor, such addition of the
                   Contribution causes such combination to be covered
                   by the Licensed Patents. The patent license shall
                   not apply to any other combinations which include
                   the Contribution. No hardware per se is licensed
                   hereunder.

                   c) Recipient understands that although each
                   Contributor grants the licenses to its
                   Contributions set forth herein, no assurances are
                   provided by any Contributor that the Program does
                   not infringe the patent or other intellectual
                   property rights of any other entity. Each
                   Contributor disclaims any liability to Recipient
                   for claims brought by any other entity based on
                   infringement of intellectual property rights or
                   otherwise. As a condition to exercising the rights
                   and licenses granted hereunder, each Recipient
                   hereby assumes sole responsibility to secure any
                   other intellectual property rights needed, if any.

                   For example, if a third party patent license is
                   required to allow Recipient to distribute the
                   Program, it is Recipient's responsibility to
                   acquire that license before distributing the
                   Program.

                   d) Each Contributor represents that to its
                   knowledge it has sufficient copyright rights in its
                   Contribution, if any, to grant the copyright
                   license set forth in this Agreement.

             3. REQUIREMENTS

             A Contributor may choose to distribute the Program in
             object code form under its own license agreement, provided
             that:
                   a) it complies with the terms and conditions of
                   this Agreement; and

                   b) its license agreement:
                   i) effectively disclaims on behalf of all
                   Contributors all warranties and conditions, express
                   and implied, including warranties or conditions of
                   title and non-infringement, and implied warranties
                   or conditions of merchantability and fitness for a
                   particular purpose;

                   ii) effectively excludes on behalf of all
                   Contributors all liability for damages, including
                   direct, indirect, special, incidental and
                   consequential damages, such as lost profits;

                   iii) states that any provisions which differ from
                   this Agreement are offered by that Contributor
                   alone and not by any other party; and

                   iv) states that source code for the Program is
                   available from such Contributor, and informs
                   licensees how to obtain it in a reasonable manner
                   on or through a medium customarily used for
                   software exchange.

             When the Program is made available in source code form:
                   a) it must be made available under this Agreement;
                   and
                   b) a copy of this Agreement must be included with
                   each copy of the Program. 

             Contributors may not remove or alter any copyright notices
             contained within the Program.

             Each Contributor must identify itself as the originator of
             its Contribution, if any, in a manner that reasonably
             allows subsequent Recipients to identify the originator of
             the Contribution. 


             4. COMMERCIAL DISTRIBUTION

             Commercial distributors of software may accept certain
             responsibilities with respect to end users, business
             partners and the like. While this license is intended to
             facilitate the commercial use of the Program, the
             Contributor who includes the Program in a commercial
             product offering should do so in a manner which does not
             create potential liability for other Contributors.
             Therefore, if a Contributor includes the Program in a
             commercial product offering, such Contributor ("Commercial
             Contributor") hereby agrees to defend and indemnify every
             other Contributor ("Indemnified Contributor") against any
             losses, damages and costs (collectively "Losses") arising
             from claims, lawsuits and other legal actions brought by a
             third party against the Indemnified Contributor to the
             extent caused by the acts or omissions of such Commercial
             Contributor in connection with its distribution of the
             Program in a commercial product offering. The obligations
             in this section do not apply to any claims or Losses
             relating to any actual or alleged intellectual property
             infringement. In order to qualify, an Indemnified
             Contributor must: a) promptly notify the Commercial
             Contributor in writing of such claim, and b) allow the
             Commercial Contributor to control, and cooperate with the
             Commercial Contributor in, the defense and any related
             settlement negotiations. The Indemnified Contributor may
             participate in any such claim at its own expense.


             For example, a Contributor might include the Program in a
             commercial product offering, Product X. That Contributor
             is then a Commercial Contributor. If that Commercial
             Contributor then makes performance claims, or offers
             warranties related to Product X, those performance claims
             and warranties are such Commercial Contributor's
             responsibility alone. Under this section, the Commercial
             Contributor would have to defend claims against the other
             Contributors related to those performance claims and
             warranties, and if a court requires any other Contributor
             to pay any damages as a result, the Commercial Contributor
             must pay those damages.


             5. NO WARRANTY

             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE
             PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT
             WARRANTIES OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR
             IMPLIED INCLUDING, WITHOUT LIMITATION, ANY WARRANTIES OR
             CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR
             FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is solely
             responsible for determining the appropriateness of using
             and distributing the Program and assumes all risks
             associated with its exercise of rights under this
             Agreement, including but not limited to the risks and
             costs of program errors, compliance with applicable laws,
             damage to or loss of data, programs or equipment, and
             unavailability or interruption of operations. 

             6. DISCLAIMER OF LIABILITY
             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER
             RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY
             FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
             OR CONSEQUENTIAL DAMAGES (INCLUDING WITHOUT LIMITATION
             LOST PROFITS), HOWEVER CAUSED AND ON ANY THEORY OF
             LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
             (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
             OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE
             OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
             POSSIBILITY OF SUCH DAMAGES.

             7. GENERAL

             If any provision of this Agreement is invalid or
             unenforceable under applicable law, it shall not affect
             the validity or enforceability of the remainder of the
             terms of this Agreement, and without further action by the
             parties hereto, such provision shall be reformed to the
             minimum extent necessary to make such provision valid and
             enforceable.


             If Recipient institutes patent litigation against a
             Contributor with respect to a patent applicable to
             software (including a cross-claim or counterclaim in a
             lawsuit), then any patent licenses granted by that
             Contributor to such Recipient under this Agreement shall
             terminate as of the date such litigation is filed. In
             addition, If Recipient institutes patent litigation
             against any entity (including a cross-claim or
             counterclaim in a lawsuit) alleging that the Program
             itself (excluding combinations of the Program with other
             software or hardware) infringes such Recipient's
             patent(s), then such Recipient's rights granted under
             Section 2(b) shall terminate as of the date such
             litigation is filed.

             All Recipient's rights under this Agreement shall
             terminate if it fails to comply with any of the material
             terms or conditions of this Agreement and does not cure
             such failure in a reasonable period of time after becoming
             aware of such noncompliance. If all Recipient's rights
             under this Agreement terminate, Recipient agrees to cease
             use and distribution of the Program as soon as reasonably
             practicable. However, Recipient's obligations under this
             Agreement and any licenses granted by Recipient relating
             to the Program shall continue and survive. 

             Everyone is permitted to copy and distribute copies of
             this Agreement, but in order to avoid inconsistency the
             Agreement is copyrighted and may only be modified in the
             following manner. The Agreement Steward reserves the right
             to publish new versions (including revisions) of this
             Agreement from time to time. No one other than the
             Agreement Steward has the right to modify this Agreement.

             IBM is the initial Agreement Steward. IBM may assign the
             responsibility to serve as the Agreement Steward to a
             suitable separate entity. Each new version of the
             Agreement will be given a distinguishing version number.
             The Program (including Contributions) may always be
             distributed subject to the version of the Agreement under
             which it was received. In addition, after a new version of
             the Agreement is published, Contributor may elect to
             distribute the Program (including its Contributions) under
             the new version. Except as expressly stated in Sections
             2(a) and 2(b) above, Recipient receives no rights or
             licenses to the intellectual property of any Contributor
             under this Agreement, whether expressly, by implication,
             estoppel or otherwise. All rights in the Program not
             expressly granted under this Agreement are reserved.


             This Agreement is governed by the laws of the State of New
             York and the intellectual property laws of the United
             States of America. No party to this Agreement will bring a
             legal action under this Agreement more than one year after
             the cause of action arose. Each party waives its rights to
             a jury trial in any resulting litigation. 



*/

/* (C) COPYRIGHT International Business Machines Corp. 2001,2002          */


#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <pthread.h>
#include <sys/stat.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <errno.h>
#include <pwd.h>


#include "pkcs11types.h"
#include "defs.h"
#include "host_defs.h"
#include "h_extern.h"
#include "tok_spec_struct.h"
#include "pkcs32.h"

#if (SPINXPL)
#include <sys/file.h>
#endif



// Function:  dlist_add_as_first()
//
// Adds the specified node to the start of the list
//
// Returns:  pointer to the start of the list
//
DL_NODE *
dlist_add_as_first( DL_NODE *list, void *data )
{
   DL_NODE *node = NULL;

   if (!data)
      return list;

   node = (DL_NODE *)malloc(sizeof(DL_NODE));
   if (!node)
      return NULL;

   node->data = data;
   node->prev = NULL;
   node->next = list;
   if ( list)
      list->prev = node;

   return node;
}


// Function:  dlist_add_as_last()
//
// Adds the specified node to the end of the list
//
// Returns:  pointer to the start of the list
//
DL_NODE *
dlist_add_as_last( DL_NODE *list, void *data )
{
   DL_NODE *node = NULL;

   if (!data)
      return list;

   node = (DL_NODE *)malloc(sizeof(DL_NODE));
   if (!node)
      return NULL;

   node->data = data;
   node->next = NULL;

   if (!list)
   {
      node->prev = NULL;
      return node;
   }
   else
   {
      DL_NODE *temp = dlist_get_last( list );
      temp->next = node;
      node->prev = temp;

      return list;
   }
}


// Function:  dlist_find()
//
DL_NODE *
dlist_find( DL_NODE *list, void *data )
{
   DL_NODE *node = list;

   while (node && node->data != data)
      node = node->next;

   return node;
}


// Function:  dlist_get_first()
//
// Returns the last node in the list or NULL if list is empty
//
DL_NODE *
dlist_get_first( DL_NODE *list )
{
   DL_NODE *temp = list;

   if (!list)
      return NULL;

   while (temp->prev != NULL)
      temp = temp->prev;

   return temp;
}


// Function:  dlist_get_last()
//
// Returns the last node in the list or NULL if list is empty
//
DL_NODE *
dlist_get_last( DL_NODE *list )
{
   DL_NODE *temp = list;

   if (!list)
      return NULL;

   while (temp->next != NULL)
      temp = temp->next;

   return temp;
}


//
//
CK_ULONG
dlist_length( DL_NODE *list )
{
   DL_NODE  *temp = list;
   CK_ULONG  len  = 0;

   while (temp)
   {
      len++;
      temp = temp->next;
   }

   return len;
}


//
//
DL_NODE *
dlist_next( DL_NODE *node )
{
   if (!node)
      return NULL;

   return node->next;
}


//
//
DL_NODE *
dlist_prev( DL_NODE *node )
{
   if (!node)
      return NULL;

   return node->prev;
}


//
//
void
dlist_purge( DL_NODE *list )
{
   DL_NODE *node;

   if (!list)
      return;

   do
   {
      node = list->next;
      free( list );
      list = node;
   } while ( list );
}


// Function:  dlist_remove_node()
//
// Attempts to remove the specified node from the list.  The caller is
// responsible for freeing the data associated with the node prior to
// calling this routine
//
DL_NODE *
dlist_remove_node( DL_NODE *list, DL_NODE *node )
{
   DL_NODE *temp  = list;

   if (!list || !node)
      return NULL;

   // special case:  removing head of the list
   //
   if (list == node)
   {
      temp = list->next;
      if (temp)
         temp->prev = NULL;

      free( list );
      return temp;
   }

   // we have no guarantee that the node is in the list
   // so search through the list to find it
   //
   while ((temp != NULL) && (temp->next != node))
      temp = temp->next;

   if (temp != NULL)
   {
      DL_NODE *next = node->next;

      temp->next = next;
      if (next)
         next->prev = temp;

      free( node );
   }

   return list;
}


// NOTE about Mutexes and cross process locking....
//
// The code uses 2 types of locks... internal locks to prevent threads within the same
// process space from stomping on each other  (pthread_mutex's suffice for 
// this).... and Cross Process Locks....
// On AIX we use it's variation of Posix semaphores for this.... Idealy on other
// platforms either POSIXSEMaphores or PTHREADXPL (pthreads xprocess lock) would
// be used.  On Linux unfortunatly  neither of these are available so we need to
// use the old standby of  SYSV semaphores (YECH.... GAG....)....  The only
// pieces which have been tested are the AIX and SYSV portions although 
// we expect that the others work correctly.
//
// we use alot more mutexes in the redesign than we did in the original
// design.  so instead of just the single global "pkcs_mutex" we have to
// deal with a number of mutexes.  so we'll make the mutex routines a
// bit more generic.
//

CK_RV
_CreateMutex( MUTEX *mutex )
{
   CK_RV  rc;

      // on AIX we make this a no-op since we assume that
      // the mutex was created in the initialization
      pthread_mutex_init( mutex, NULL );
      return CKR_OK;
}

CK_RV
_CreateMsem( sem_t *msem )
{
   if (!sem_init( msem,0, 1)) // parm 2 non-0 means pshared  1 is unlocked 0 is locked
   //if (!sem_init( msem,1, 1)) // parm 2 non-0 means pshared  1 is unlocked 0 is locked
      return CKR_OK;
   else{
      st_err_log(4, __FILE__, __LINE__, __FUNCTION__);
      return CKR_FUNCTION_FAILED;
   }
}

CK_RV
_DestroyMutex( MUTEX *mutex )
{
   CK_RV  rc;

     // no-op in AIX
     pthread_mutex_destroy((pthread_mutex_t *)mutex);
     return CKR_OK;

}

CK_RV
_DestroyMsem( sem_t *msem )
{
   if (!sem_destroy(msem))
      return CKR_OK;
   else{
      st_err_log(4, __FILE__, __LINE__, __FUNCTION__);
      return CKR_FUNCTION_FAILED;
   }
}


CK_RV
_LockMutex( MUTEX *mutex )
{
      pthread_mutex_lock( mutex);
      return CKR_OK;

}

CK_RV
_LockMsem( sem_t *msem )
{
   if (!msem){
      st_err_log(4, __FILE__, __LINE__, __FUNCTION__);
      return CKR_FUNCTION_FAILED;
   }
   if(!sem_wait(msem)) // block until the semaphore is free
      return CKR_OK;
   else{
      st_err_log(4, __FILE__, __LINE__, __FUNCTION__);
      return CKR_FUNCTION_FAILED;
   }
}

CK_RV
_UnlockMutex( MUTEX *mutex )
{
   pthread_mutex_unlock(mutex);
   return CKR_OK;

}

CK_RV
_UnlockMsem( sem_t *msem )
{
   if (!msem){
      st_err_log(4, __FILE__, __LINE__, __FUNCTION__);
      return CKR_FUNCTION_FAILED;
   }
   if (!sem_post(msem))
      return CKR_OK;
   else{
      st_err_log(4, __FILE__, __LINE__, __FUNCTION__);
      return CKR_FUNCTION_FAILED;
   }
}

#if SYSVSEM
#include <sys/sem.h>
// These structures are needed to effect a lock
// using SYS V semaphores...
static struct sembuf xlock_lock[2]={
         0,0,0,
         0,1,SEM_UNDO
};

static struct sembuf xlock_unlock[1] = {
         0,-1,(IPC_NOWAIT | SEM_UNDO)
};

static pthread_mutex_t  semmtx = PTHREAD_MUTEX_INITIALIZER;

#endif


int spinxplfd=-1;
int spin_created=0;

extern void set_perm(int);

CK_RV
CreateXProcLock(void *xproc)
{

#if (SPINXPL)
    // open the file that we will do the locking on...
  spinxplfd = open("/tmp/.pkcs11spinloc",O_CREAT|O_APPEND|O_RDWR,
        S_IRWXU|S_IRWXG|S_IRWXO);
   if (spinxplfd) {
	   	
	set_perm(spinxplfd);
	fchmod(spinxplfd,S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH | S_IWOTH);
	spin_created=1;
   } else {
	   perror("XPROC CREATE file :");
   }
    return CKR_OK;
#elif  SYSVSEM
   int  semid;
   int *psem;
   key_t  tok;

   tok  = ftok( pk_dir, 'c' );
  
//printf("creating semaphore %x \n",tok);

   psem = (int *)xproc;
if ( *psem < 0 ) {
   if ( (semid = semget(tok,1,IPC_CREAT | 0666)) < 0 ){
      if (errno == EEXIST) {
	  if ( (semid = semget(tok,0,0)) < 0) {
		pthread_mutex_unlock(&semmtx);
                st_err_log(4, __FILE__, __LINE__, __FUNCTION__); 
	        return CKR_FUNCTION_FAILED;
	  }
      } else {
	      pthread_mutex_unlock(&semmtx);
              st_err_log(4, __FILE__, __LINE__, __FUNCTION__); 
	      return CKR_FUNCTION_FAILED;
      }
   }
}
   psem = (int *)xproc;
   *psem = semid;
//pthread_mutex_unlock(&semmtx);
   return CKR_OK;

   // we know that semaphores are created unlocked
#elif POSIXSEM 
	return _CreateMsem((sem_t *)xproc);
#elif PTHREADXPL
	pthread_mutex_attr_t  mtxattr;

 	pthread_mutexattr_init(&mtxattr);
	pthread_mutexattr_setpshared(&mtxattr,PTHREAD_PROCESS_SHARED);
	pthread_mutex_init((pthread_mutex_t *)xproc,&mtxattr);

#elif  NOXPROCLOCK
   return CKR_OK;
#else
#error "Define XPROC LOCKS"
  
#endif
}
CK_RV
DestroyXProcLock(void *xproc)
{
#if SPINXPL
	return CKR_OK;
#elif SYSVSEM
   int semid,*psem;

//printf("Destroying semaphore %x \n",xproc);

pthread_mutex_lock(&semmtx);
   psem = (int *)xproc;
   semid = *psem;

   semctl(semid,1,IPC_RMID,0);
pthread_mutex_unlock(&semmtx);

   return CKR_OK;
#elif POSIXSEM 
	return _DestroyMsem((sem_t *)xproc);
#elif  PTHREADXPL
	return pthread_mutex_destroy((pthread_mutex_t *)xproc);
#elif  NOXPROCLOCK
   return CKR_OK;
#else
#error "Define XPROC LOCKS"
#endif
}

CK_RV
XProcLock(void *xproc)
{
#if SPINXPL
	if (!spin_created) {
	  spinxplfd = open("/tmp/.pkcs11spinloc",O_CREAT|O_APPEND|O_RDWR,
		S_IRWXU|S_IRWXG|S_IRWXO);
	  fchmod(spinxplfd,S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH | S_IWOTH);
	  spin_created=1;
	}
	if (spinxplfd){
		flock(spinxplfd,LOCK_EX);
	}
	return CKR_OK;
#elif SYSVSEM
   int semid,*psem;
   pthread_mutex_lock(&semmtx);
   return CKR_OK;

   pthread_mutex_lock(&semmtx);
   psem = (int *)xproc;
   semid = *psem;
   semop(semid,&xlock_lock[0],2);
   pthread_mutex_unlock(&semmtx);
   return CKR_OK;

#elif POSIXSEM 
	return _LockMsem((sem_t *)xproc);
#elif PTHREADXPL
	return _LockMutex((MUTEX *)xproc);
#elif  NOXPROCLOCK
   return CKR_OK;
#else
#error "Define XPROC LOCKS"

#endif
}
CK_RV
XProcUnLock(void *xproc)
{
#if SPINXPL
	if (!spin_created) {
	  spinxplfd = open("/tmp/.pkcs11spinloc",O_CREAT|O_APPEND|O_RDWR,
		S_IRWXU|S_IRWXG|S_IRWXO);
	  fchmod(spinxplfd,S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH | S_IWOTH);
	  spin_created=1;
	}
	if (spinxplfd) {
		flock(spinxplfd,LOCK_UN);
	}
	return CKR_OK;
#elif SYSVSEM
   int semid,*psem;
   pthread_mutex_unlock(&semmtx);
   return CKR_OK;

   pthread_mutex_lock(&semmtx);
   psem = (int *)xproc;
   semid = *psem;
   semop(semid,&xlock_unlock[0],1);
   pthread_mutex_unlock(&semmtx);
   return CKR_OK;
#elif POSIXSEM 
	return _UnlockMsem((sem_t *)xproc);
#elif PTHREADXPL
	return _UnlockMutex((MUTEX *)xproc);
#elif  NOXPROCLOCK
   return CKR_OK;
#else
#error "Define XPROC LOCKS"
#endif
}


//
//

// is_attribute_defined()
//
// determine whether the specified attribute is defined by Cryptoki
//
CK_BBOOL
is_attribute_defined( CK_ATTRIBUTE_TYPE type )
{
   if (type >= CKA_VENDOR_DEFINED)
      return TRUE;

   switch (type)
   {
      case  CKA_CLASS:
      case  CKA_TOKEN:
      case  CKA_PRIVATE:
      case  CKA_LABEL:
      case  CKA_APPLICATION:
      case  CKA_VALUE:
      case  CKA_CERTIFICATE_TYPE:
      case  CKA_ISSUER:
      case  CKA_SERIAL_NUMBER:
      case  CKA_KEY_TYPE:
      case  CKA_SUBJECT:
      case  CKA_ID:
      case  CKA_SENSITIVE:
      case  CKA_ENCRYPT:
      case  CKA_DECRYPT:
      case  CKA_WRAP:
      case  CKA_UNWRAP:
      case  CKA_SIGN:
      case  CKA_SIGN_RECOVER:
      case  CKA_VERIFY:
      case  CKA_VERIFY_RECOVER:
      case  CKA_DERIVE:
      case  CKA_START_DATE:
      case  CKA_END_DATE:
      case  CKA_MODULUS:
      case  CKA_MODULUS_BITS:
      case  CKA_PUBLIC_EXPONENT:
      case  CKA_PRIVATE_EXPONENT:
      case  CKA_PRIME_1:
      case  CKA_PRIME_2:
      case  CKA_EXPONENT_1:
      case  CKA_EXPONENT_2:
      case  CKA_COEFFICIENT:
      case  CKA_PRIME:
      case  CKA_SUBPRIME:
      case  CKA_BASE:
      case  CKA_VALUE_BITS:
      case  CKA_VALUE_LEN:
      case  CKA_EXTRACTABLE:
      case  CKA_LOCAL:
      case  CKA_NEVER_EXTRACTABLE:
      case  CKA_ALWAYS_SENSITIVE:
      case  CKA_MODIFIABLE:
      case  CKA_ECDSA_PARAMS:
      case  CKA_EC_POINT:
      case  CKA_HW_FEATURE_TYPE:
      case  CKA_HAS_RESET:
      case  CKA_RESET_ON_INIT:
      case  CKA_KEY_GEN_MECHANISM:
      case  CKA_PRIME_BITS:
      case  CKA_SUBPRIME_BITS:
      case  CKA_OBJECT_ID:
      case  CKA_AC_ISSUER:
      case  CKA_OWNER:
      case  CKA_ATTR_TYPES:
      case  CKA_TRUSTED:
         return TRUE;
   }

   return FALSE;
}


extern CK_CHAR manuf[];
extern CK_CHAR model[];
extern CK_CHAR descr[];
extern CK_CHAR label[];


//
//
void
init_slotInfo( void )
{
   memset( &slot_info.slotDescription, ' ', sizeof(slot_info.slotDescription) );
   memset( &slot_info.manufacturerID,  ' ', sizeof(slot_info.manufacturerID)  );

   memcpy( &slot_info.slotDescription, descr, strlen((char *)descr) );
   memcpy( &slot_info.manufacturerID,  manuf, strlen((char *)manuf) );

   slot_info.hardwareVersion.major = 1;
   slot_info.hardwareVersion.minor = 0;
   slot_info.firmwareVersion.major = 1;
   slot_info.firmwareVersion.minor = 0;
   slot_info.flags = CKF_TOKEN_PRESENT | CKF_HW_SLOT;
}


//
//
void
init_tokenInfo( void )
{
   CK_TOKEN_INFO_32    *token_info = NULL;
   CK_ULONG          len;

   token_info = &nv_token_data->token_info;

   memset( token_info->manufacturerID, ' ', sizeof(token_info->manufacturerID) );
   memset( token_info->model,          ' ', sizeof(token_info->model) );
   memset( token_info->serialNumber,   ' ', sizeof(token_info->serialNumber) );

   memcpy( token_info->label,          nv_token_data->token_info.label, 32 );

   memcpy( token_info->manufacturerID, manuf, strlen((char *)manuf) );
   memcpy( token_info->model,          model, strlen((char *)model) );

   // use the 41-xxxxx serial number from the coprocessor
   //
   memcpy( token_info->serialNumber,  "123" , 3 );

   // I don't see any API support for changing the clock so
   // we will use the system clock for the token's clock.
   //

   token_info->flags = CKF_RNG |
                       CKF_LOGIN_REQUIRED |
                       CKF_CLOCK_ON_TOKEN |
		       CKF_SO_PIN_TO_BE_CHANGED; // XXX New in v2.11 - KEY

   if (memcmp(nv_token_data->user_pin_sha, "00000000000000000000", SHA1_HASH_SIZE) != 0)
      token_info->flags |= CKF_USER_PIN_INITIALIZED;
   else
      token_info->flags |= CKF_USER_PIN_TO_BE_CHANGED; // XXX New in v2.11 - KEY

   // For the release, we made these 
   // values as CK_UNAVAILABLE_INFORMATION
   //
   token_info->ulMaxSessionCount    = (CK_ULONG_32)CK_UNAVAILABLE_INFORMATION;
   token_info->ulSessionCount       = (CK_ULONG_32)CK_UNAVAILABLE_INFORMATION;
   token_info->ulMaxRwSessionCount  = (CK_ULONG_32)CK_UNAVAILABLE_INFORMATION;
   token_info->ulRwSessionCount     = (CK_ULONG_32)CK_UNAVAILABLE_INFORMATION;
   token_info->ulMaxPinLen          = MAX_PIN_LEN;
   token_info->ulMinPinLen          = MIN_PIN_LEN;
   token_info->ulTotalPublicMemory  = (CK_ULONG_32)CK_UNAVAILABLE_INFORMATION;
   token_info->ulFreePublicMemory   = (CK_ULONG_32)CK_UNAVAILABLE_INFORMATION;
   token_info->ulTotalPrivateMemory = (CK_ULONG_32)CK_UNAVAILABLE_INFORMATION;
   token_info->ulFreePrivateMemory  = (CK_ULONG_32)CK_UNAVAILABLE_INFORMATION;

   token_info->hardwareVersion.major = 1;
   token_info->hardwareVersion.minor = 0;
   token_info->firmwareVersion.major = 1;
   token_info->firmwareVersion.minor = 0;

   memset( token_info->utcTime, ' ', sizeof(token_info->utcTime) );
}


//
//
CK_RV
init_token_data( void )
{
   CK_RV rc;

   memset( (char *)nv_token_data, 0, sizeof(nv_token_data) );

   // the normal USER pin is not set when the token is initialized
   //
   memcpy( nv_token_data->user_pin_sha, "00000000000000000000", SHA1_HASH_SIZE );
   memcpy( nv_token_data->so_pin_sha,   default_so_pin_sha,     SHA1_HASH_SIZE );

   memset( user_pin_md5, 0x0,                MD5_HASH_SIZE );
   memcpy( so_pin_md5,   default_so_pin_md5, MD5_HASH_SIZE );

   memcpy( nv_token_data->next_token_object_name, "00000000", 8 );

   // generate the master key used for signing the Operation State information
   //                          `
   memset( nv_token_data->token_info.label, ' ', sizeof(nv_token_data->token_info.label) );
   memcpy( nv_token_data->token_info.label, label, strlen((char *)label) );

   nv_token_data->tweak_vector.allow_weak_des   = TRUE;
   nv_token_data->tweak_vector.check_des_parity = FALSE;
   nv_token_data->tweak_vector.allow_key_mods   = TRUE;
   nv_token_data->tweak_vector.netscape_mods    = TRUE;

   init_tokenInfo();

   //
   // FIXME: erase the token object index file (and all token objects)
   //

   rc  = rng_generate( master_key, 3 * DES_KEY_SIZE );
   if (rc != CKR_OK){
      st_err_log(4, __FILE__, __LINE__, __FUNCTION__); 
      return CKR_FUNCTION_FAILED;
   }
   rc = save_masterkey_so();
   if (rc != CKR_OK){
      st_err_log(4, __FILE__, __LINE__, __FUNCTION__); 
      return CKR_FUNCTION_FAILED;
   }
   rc = save_token_data();
   if (rc != CKR_OK)
      st_err_log(4, __FILE__, __LINE__, __FUNCTION__); 
   return rc;
}



// Function:  compute_next_token_obj_name()
//
// Given a token object name (8 bytes in the range [0-9A-Z]) increment by one
// adjusting as necessary
//
// This gives us a namespace of 36^8 = 2,821,109,907,456 objects before wrapping around
//
CK_RV
compute_next_token_obj_name( CK_BYTE *current, CK_BYTE *next )
{
   int val[8];
   int i;

   if (!current || !next){
      st_err_log(4, __FILE__, __LINE__, __FUNCTION__); 
      return CKR_FUNCTION_FAILED;
   }
   // Convert to integral base 36
   //
   for (i = 0; i < 8; i++)
   {
      if (current[i] >= '0' && current[i] <= '9')
         val[i] = current[i] - '0';

      if (current[i] >= 'A' && current[i] <= 'Z')
         val[i] = current[i] - 'A' + 10;
   }

   val[0]++;

   i=0;

   while (val[i] > 35)
   {
      val[i] = 0;

      if (i+1 < 8) {
         val[i+1]++;
         i++;
      }
      else {
         val[0]++;
         i = 0;   // start pass 2
      }
   }

   // now, convert back to [0-9A-Z]
   //
   for (i = 0; i < 8; i++)
   {
      if (val[i] < 10)
         next[i] = '0' + val[i];
      else
         next[i] = 'A' + val[i] - 10;
   }

   return CKR_OK;
}


//
//
CK_RV
build_attribute( CK_ATTRIBUTE_TYPE  type,
                 CK_BYTE           *data,
                 CK_ULONG           data_len,
                 CK_ATTRIBUTE     **attrib )
{
   CK_ATTRIBUTE *attr = NULL;

   attr = (CK_ATTRIBUTE *)malloc( sizeof(CK_ATTRIBUTE) + data_len );
   if (!attr){
      st_err_log(0, __FILE__, __LINE__);
      return CKR_DEVICE_MEMORY;
   }
   attr->type  = type;
   attr->ulValueLen = data_len;

   if (data_len > 0) {
      attr->pValue = (CK_BYTE *)attr + sizeof(CK_ATTRIBUTE);
      memcpy( attr->pValue, data, data_len );
   }
   else
      attr->pValue = NULL;

   *attrib = attr;

   return CKR_OK;
}


//
//
CK_RV
add_pkcs_padding( CK_BYTE  * ptr,
                  CK_ULONG   block_size,
                  CK_ULONG   data_len,
                  CK_ULONG   total_len )
{
   CK_ULONG i, pad_len;
   CK_BYTE  pad_value;

   pad_len = block_size - (data_len % block_size);
   pad_value = (CK_BYTE)pad_len;

   if (data_len + pad_len > total_len){
      st_err_log(4, __FILE__, __LINE__, __FUNCTION__); 
      return CKR_FUNCTION_FAILED;
   }
   for (i = 0; i < pad_len; i++)
      ptr[i] = pad_value;

   return CKR_OK;
}


//
//
CK_RV
strip_pkcs_padding( CK_BYTE   * ptr,
                    CK_ULONG    total_len,
                    CK_ULONG  * data_len )
{
   CK_BYTE  pad_value;

   pad_value = ptr[total_len - 1];

   // thus, we have 'pad_value' bytes of 'pad_value' appended to the end
   //
   *data_len = total_len - pad_value;

   return CKR_OK;
}


//
//
CK_RV
remove_leading_zeros( CK_ATTRIBUTE *attr )
{
   CK_BYTE   *ptr = NULL;
   CK_ULONG   new_len, i;

   ptr = attr->pValue;

   for (i = 0; i < attr->ulValueLen; i++) {
      if (ptr[i] != 0x0)
         break;
   }

   new_len = attr->ulValueLen - i;

   memcpy( ptr, ptr + i, new_len );
   attr->ulValueLen = new_len;

   return CKR_OK;
}


//
//
CK_BYTE
parity_adjust( CK_BYTE b )
{
   if (parity_is_odd(b) == FALSE)
      b = (b & 0xFE) | ((~b) & 0x1);

   return b;
}


//
//
CK_RV
parity_is_odd( CK_BYTE b )
{
   b = ((b >> 4) ^ b) & 0x0f;
   b = ((b >> 2) ^ b) & 0x03;
   b = ((b >> 1) ^ b) & 0x01;

   if (b == 1)
      return TRUE;
   else
      return FALSE;
}


CK_RV
attach_shm()
{
   key_t    key;
   int      shm_id;
   struct stat statbuf;
   CK_BBOOL created = FALSE;
   void *temp = NULL;

#if !(NOSHM) && !(MMAP)
   // Change TOK_PATH2 to be the directory 
   // of the data store specified.  This way we
   // have a unique key shared memory for each 
   // token object database
   if (stat(pk_dir, &statbuf) < 0) {
      st_err_log(4, __FILE__, __LINE__, __FUNCTION__); 
      return CKR_FUNCTION_FAILED;
   }

   key = ftok( pk_dir, 'c' );

   shm_id = shmget( key, sizeof(LW_SHM_TYPE),
                    S_IRUSR | S_IWUSR |
                    S_IRGRP | S_IWGRP |
                    S_IROTH | S_IWOTH |
                    IPC_CREAT | IPC_EXCL);

   if (shm_id < 0) {

#if 0
      if ((errno != EACCES) && (errno != EEXIST)) {
         fflush(stdout); fflush(stderr);
         st_err_log(4, __FILE__, __LINE__, __FUNCTION__); 
         return CKR_FUNCTION_FAILED;
      }
#endif
// SAB XXX  it appears that in some cases linux does not set
// the errno properly on a shmget failure... so if the create
// failed we'll just try and attach....  If the basic attach
// fails, then we can error out...

      // SHM segment already exists...
      //
      shm_id = shmget( key, sizeof(LW_SHM_TYPE),
                       S_IRUSR | S_IWUSR |
                       S_IRGRP | S_IWGRP |
                       S_IROTH | S_IWOTH  );

      //if ((errno != EACCES) && (errno != EEXIST)) {
      if (shm_id < 0) {
         fflush(stdout); fflush(stderr);
         st_err_log(4, __FILE__, __LINE__, __FUNCTION__); 
         return CKR_FUNCTION_FAILED;
      }

   } else
      created = TRUE;

   global_shm = (void *)shmat( shm_id, NULL, 0 );
   if (!global_shm){
      st_err_log(4, __FILE__, __LINE__, __FUNCTION__); 
      return CKR_FUNCTION_FAILED;
   }
   if (created == TRUE) {
#if !(SYSVSEM)
// SYSV sem's are a global that is handled in the 
// Initialize routine...  all others are stored in the
// shared memory segment so we have to do
// this here after the segment is created
// to prevent a core dump
      CreateXProcLock( &global_shm->mutex );
      xproclock = (void *)&global_shm->mutex; // need to do this here
#endif
      XProcLock( xproclock );
         global_shm->num_publ_tok_obj = 0;
         global_shm->num_priv_tok_obj = 0;
         memset( &global_shm->publ_tok_objs, 0x0, 2048 * sizeof(TOK_OBJ_ENTRY) );
         memset( &global_shm->priv_tok_objs, 0x0, 2048 * sizeof(TOK_OBJ_ENTRY) );
      XProcUnLock( xproclock );
   } else {
	xproclock = (void *)&global_shm->mutex;
   }
#elif MMAP
	{
#define FILENAME   ".stmapfile"

#warning "EXPERIMENTAL"
		char		*fname = NULL;
		char		*b2 = NULL;
		int		fd = -1;
		mode_t		mode;
		CK_RV		rc;


		mode = (S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP );

		// STAT the file to see if it exists... If not, then create it
		fname = malloc(strlen(pk_dir)+strlen(FILENAME)+100);
		if (fname ) {
			sprintf(fname, "%s/%s", pk_dir, FILENAME);
		} else {
			st_err_log(4, __FILE__, __LINE__, __FUNCTION__);
			return CKR_HOST_MEMORY;
		}

		if (stat(fname, &statbuf) < 0) {
			// File does not exist Create it
			fd = open(fname,O_RDWR|O_CREAT,mode);
			if (fd < 0 ){
				LogError("open of %s failed: %s", fname, strerror(errno));
				free(fname);
				return CKR_FUNCTION_FAILED;  //Failed
			}
			b2 = malloc(sizeof(LW_SHM_TYPE));
			memset(b2,'\0',sizeof(LW_SHM_TYPE));
			write(fd,b2,sizeof(LW_SHM_TYPE));
			free(b2);
			created=TRUE;
		} else {
			fd = open(fname,O_RDWR,mode);
			if (fd < 0 ){
				LogError("open of %s failed: %s", fname, strerror(errno));
				free(fname);
				return CKR_FUNCTION_FAILED;  //Failed
			}
		}

		global_shm = (LW_SHM_TYPE *)mmap(NULL,sizeof(LW_SHM_TYPE),PROT_READ|PROT_WRITE,MAP_SHARED,fd,0);
		if (created == TRUE) {
			XProcLock( xproclock );
			global_shm->num_publ_tok_obj = 0;
			global_shm->num_priv_tok_obj = 0;
			memset( &global_shm->publ_tok_objs, 0x0, 2048 * sizeof(TOK_OBJ_ENTRY) );
			memset( &global_shm->priv_tok_objs, 0x0, 2048 * sizeof(TOK_OBJ_ENTRY) );
			XProcUnLock( xproclock );
		} else {
			xproclock = (void *)&global_shm->mutex;
		}

		rc = CKR_OK;

		free(fname);
		close(fd);
		return rc;

	}
#else
      global_shm = (void *)malloc(sizeof(LW_SHM_TYPE));

#endif

   return CKR_OK;
}


CK_RV
detach_shm()
{
#if !(NOSHM) && !(MMAP)
   shmdt( global_shm );
#elif MMAP
   // Detach from memory mapped file
   munmap((void *)global_shm,sizeof(LW_SHM_TYPE));
#else
   free(global_shm);
#endif
   return CKR_OK;
}

//#endif


CK_RV
compute_sha( CK_BYTE  * data,
             CK_ULONG   len,
             CK_BYTE  * hash )
{
   // XXX KEY
   DIGEST_CONTEXT	ctx;
   CK_ULONG     	hash_len = SHA1_HASH_SIZE;
   CK_RV		rv;

   memset( &ctx, 0x0, sizeof(ctx) );

   ckm_sha1_init( &ctx );
   if( ctx.context == NULL )
	   return CKR_HOST_MEMORY;
   
   if( (rv = ckm_sha1_update( &ctx, data,  len )) != CKR_OK)
	   return rv;
   
   return ckm_sha1_final( &ctx, hash, &hash_len );
}


CK_RV
compute_md5( CK_BYTE  * data,
             CK_ULONG   len,
             CK_BYTE  * hash )
{
   MD5_CONTEXT ctx;

   memset( &ctx, 0x0, sizeof(ctx) );

   ckm_md5_init( &ctx );
   ckm_md5_update( &ctx, data,  len );
   ckm_md5_final(  &ctx, hash, MD5_HASH_SIZE );

   return CKR_OK;
}


