// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Visual3d_ViewManager_HeaderFile
#define _Visual3d_ViewManager_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Visual3d_ViewManager_HeaderFile
#include <Handle_Visual3d_ViewManager.hxx>
#endif

#ifndef _Visual3d_SetOfView_HeaderFile
#include <Visual3d_SetOfView.hxx>
#endif
#ifndef _Handle_Visual3d_Layer_HeaderFile
#include <Handle_Visual3d_Layer.hxx>
#endif
#ifndef _Aspect_GenId_HeaderFile
#include <Aspect_GenId.hxx>
#endif
#ifndef _Handle_Graphic3d_GraphicDriver_HeaderFile
#include <Handle_Graphic3d_GraphicDriver.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Graphic3d_StructureManager_HeaderFile
#include <Graphic3d_StructureManager.hxx>
#endif
#ifndef _Handle_Aspect_GraphicDevice_HeaderFile
#include <Handle_Aspect_GraphicDevice.hxx>
#endif
#ifndef _Handle_Visual3d_HSetOfView_HeaderFile
#include <Handle_Visual3d_HSetOfView.hxx>
#endif
#ifndef _Handle_Aspect_Window_HeaderFile
#include <Handle_Aspect_Window.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Visual3d_View_HeaderFile
#include <Handle_Visual3d_View.hxx>
#endif
#ifndef _Handle_Graphic3d_Structure_HeaderFile
#include <Handle_Graphic3d_Structure.hxx>
#endif
#ifndef _Aspect_TypeOfHighlightMethod_HeaderFile
#include <Aspect_TypeOfHighlightMethod.hxx>
#endif
#ifndef _Graphic3d_CView_HeaderFile
#include <Graphic3d_CView.hxx>
#endif
#ifndef _Handle_Graphic3d_DataStructureManager_HeaderFile
#include <Handle_Graphic3d_DataStructureManager.hxx>
#endif
class Visual3d_Layer;
class Graphic3d_GraphicDriver;
class Visual3d_View;
class Aspect_GraphicDevice;
class Visual3d_HSetOfView;
class Aspect_Window;
class Graphic3d_Vertex;
class Graphic3d_Vector;
class Visual3d_PickDescriptor;
class Visual3d_ContextPick;
class Graphic3d_Structure;
class TColStd_Array2OfReal;
class Graphic3d_DataStructureManager;


//! This class allows the definition of a manager to <br>
//!	    which the views are associated. <br>
//!	    It allows them to be globally manipulated. <br>
//!	    It activates the pick. <br>
class Visual3d_ViewManager : public Graphic3d_StructureManager {

public:
 // Methods PUBLIC
 // 

//! Creates a 3D visualizer. <br>
Standard_EXPORT Visual3d_ViewManager(const Handle(Aspect_GraphicDevice)& aDevice);

//! Activates all the views of the manager <me>. <br>
Standard_EXPORT   void Activate() ;

//! Deactivates all the views of the manager <me>. <br>
Standard_EXPORT   void Deactivate() ;

//! Deletes and erases the 3D visualiser <me>. <br>
Standard_EXPORT virtual  void Destroy() ;
~Visual3d_ViewManager()
{
  Destroy();
}


//! Erases all of the structures displayed in the <br>
//!	    visualiser <me>. <br>
Standard_EXPORT   void Erase() ;

//! Redraws all the displayed structures. <br>
Standard_EXPORT   void Redraw() const;

//! Deletes and erases the 3D visualiser <me>. <br>
Standard_EXPORT   void Remove() ;

//! Updates screen in function of modifications of <br>
//!	    the structures. <br>
//!  Category: Methods to modify the class definition <br>
//!  Warning: Not necessary if the update mode is TOU_ASAP. <br>
Standard_EXPORT   void Update() const;

//! Returns the group of views activated in the visualiser <me>. <br>
Standard_EXPORT   Handle_Visual3d_HSetOfView ActivatedView() const;

//! Applies the view orientation transformation, the <br>
//!	    view mapping transformation and view clip, the <br>
//!	    display transformation to the vertex <AVertex>. <br>
//!	    Returns the pixel coordinates <AU>, <AV>. <br>
//!  Warning: Returns <AU> = <AV> = IntegerLast () if the <br>
//!	    evaluation is impossible. <br>
//!	    -- Bad Window, Numeric error... <br>
Standard_EXPORT   void ConvertCoord(const Handle(Aspect_Window)& AWindow,const Graphic3d_Vertex& AVertex,Standard_Integer& AU,Standard_Integer& AV) const;

//! Applies the inverse of the display transformation, the <br>
//!	    inverse of the view mapping transformation and view clip, <br>
//!	    the inverse of the view orientation transformation to <br>
//!	    the pixel coordinates <AU>, <AV>. <br>
//!	    Returns the world coordinates <AVertex>. <br>
//!  Warning: Returns AVertex (X, Y, Z) with X = Y = Z = RealLast () <br>
//!	    if the evaluation is impossible. <br>
//!	    -- Bad Window, Numeric error... <br>
Standard_EXPORT   Graphic3d_Vertex ConvertCoord(const Handle(Aspect_Window)& AWindow,const Standard_Integer AU,const Standard_Integer AV) const;

//! Applies the inverse of the display transformation, the <br>
//!	    inverse of the view mapping transformation and view clip, <br>
//!	    the inverse of the view orientation transformation to <br>
//!	    the pixel coordinates <AU>, <AV>. <br>
//!	    Returns the world coordinates <AVertex> and projection ray <AVector>. <br>
//!  Warning: Returns AVertex (X, Y, Z) with X = Y = Z = RealLast () and <br>
//!          AVector (VX, VY, VZ) with VX = VY = VZ = 0. <br>
//!	    if the evaluation is impossible. <br>
//!	    -- Bad Window, Numeric error... <br>
Standard_EXPORT   void ConvertCoordWithProj(const Handle(Aspect_Window)& AWindow,const Standard_Integer AU,const Standard_Integer AV,Graphic3d_Vertex& Point,Graphic3d_Vector& Proj) const;

//! Returns the group of views defined in the visualiser <me>. <br>
Standard_EXPORT   Handle_Visual3d_HSetOfView DefinedView() const;

//! Returns the theoretical maximum number of <br>
//!	    definable views in the view manager <me>. <br>
//!  Warning: It's not possible to accept an infinite <br>
//!	    number of definable views because each <br>
//!	    view must have an identification and we <br>
//!	    have different view managers. <br>
Standard_EXPORT   Standard_Integer MaxNumOfViews() const;

//! Returns : <br>
//!	    a new identification number for a new view <br>
//!	    in the visualiser. <br>
Standard_EXPORT   Standard_Integer Identification(const Handle(Visual3d_View)& AView) ;

//! Returns a graphic pick with the pick context <CTX> <br>
//!	    at the coordinates <AX>, <AY> in the window <AWindow>. <br>
Standard_EXPORT   Visual3d_PickDescriptor Pick(const Visual3d_ContextPick& CTX,const Handle(Aspect_Window)& AWindow,const Standard_Integer AX,const Standard_Integer AY) ;

//! Returns the structure with the identification number <AId>. <br>
Standard_EXPORT   Handle_Graphic3d_Structure Identification(const Standard_Integer AId) const;

//! Returns the identification number of the visualiser. <br>
Standard_EXPORT   Standard_Integer Identification() const;

//! Changes the display priority of the structure <AStructure>. <br>
Standard_EXPORT   void ChangeDisplayPriority(const Handle(Graphic3d_Structure)& AStructure,const Standard_Integer OldPriority,const Standard_Integer NewPriority) ;

//! Clears the structure <AStructure>. <br>
Standard_EXPORT   void Clear(const Handle(Graphic3d_Structure)& AStructure,const Standard_Boolean WithDestruction) ;

//! Connects the structures <AMother> and <ADaughter>. <br>
Standard_EXPORT   void Connect(const Handle(Graphic3d_Structure)& AMother,const Handle(Graphic3d_Structure)& ADaughter) ;

//! Disconnects the structures <AMother> and <ADaughter>. <br>
Standard_EXPORT   void Disconnect(const Handle(Graphic3d_Structure)& AMother,const Handle(Graphic3d_Structure)& ADaughter) ;

//! Display of the structure <AStructure>. <br>
Standard_EXPORT   void Display(const Handle(Graphic3d_Structure)& AStructure) ;

//! Erases the structure <AStructure>. <br>
Standard_EXPORT   void Erase(const Handle(Graphic3d_Structure)& AStructure) ;

//! Highlights the structure <AStructure>. <br>
Standard_EXPORT   void Highlight(const Handle(Graphic3d_Structure)& AStructure,const Aspect_TypeOfHighlightMethod AMethod) ;


Standard_EXPORT   void SetTransform(const Handle(Graphic3d_Structure)& AStructure,const TColStd_Array2OfReal& ATrsf) ;

//! Suppress the highlighting on all the structures. <br>
Standard_EXPORT   void UnHighlight() ;

//! Suppress the highlighting on the structure <AStructure>. <br>
Standard_EXPORT   void UnHighlight(const Handle(Graphic3d_Structure)& AStructure) ;

//! Returns Standard_True if the view associated to the <br>
//!	    window <AWindow> exists and is activated. <br>
//!	    <TheViewId> contains the internal identification of <br>
//!	    the associated view. <br>
Standard_EXPORT   Standard_Boolean ViewExists(const Handle(Aspect_Window)& AWindow,Graphic3d_CView& TheCView) const;

//! Returns the underlay of the viewer <me>. <br>
Standard_EXPORT  const Handle_Visual3d_Layer& UnderLayer() const;

//! Returns the underlay of the viewer <me>. <br>
Standard_EXPORT  const Handle_Visual3d_Layer& OverLayer() const;

//! Forces a new construction of the structure <AStructure> <br>
//!	    if <AStructure> is displayed and TOS_COMPUTED. <br>
Standard_EXPORT   void ReCompute(const Handle(Graphic3d_Structure)& AStructure) ;

//! Forces a new construction of the structure <AStructure> <br>
//!	    if <AStructure> is displayed in <AProjector> and TOS_COMPUTED. <br>
Standard_EXPORT   void ReCompute(const Handle(Graphic3d_Structure)& AStructure,const Handle(Graphic3d_DataStructureManager)& AProjector) ;

//! Returns Standard_True if the transparency <br>
//!	    is activated in all activated views. <br>
//!	    Default Standard_False <br>
Standard_EXPORT   Standard_Boolean Transparency() const;

//! if <AFlag> is Standard_True then the transparency <br>
//!	    is managed. <br>
//!	    Default Standard_False <br>
Standard_EXPORT   void SetTransparency(const Standard_Boolean AFlag) ;

//! Returns Standard_True if the zbuffer activity <br>
//!	    is managed automatically. <br>
//!	    Default Standard_False <br>
Standard_EXPORT   Standard_Boolean ZBufferAuto() const;

//! if <AFlag> is  Standard_True then the zbuffer activity <br>
//!	    is managed automatically. <br>
//!	    Default Standard_False <br>
Standard_EXPORT   void SetZBufferAuto(const Standard_Boolean AFlag) ;


friend class Visual3d_View;
friend class Visual3d_Layer;


 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 

//! Adds a new layer in all the views of <me>. <br>
Standard_EXPORT   void SetLayer(const Handle(Visual3d_Layer)& ALayer) ;


 // Fields PRIVATE
 //
Visual3d_SetOfView MyDefinedView;
Handle_Visual3d_Layer MyUnderLayer;
Handle_Visual3d_Layer MyOverLayer;
Aspect_GenId MyViewGenId;
Handle_Graphic3d_GraphicDriver MyGraphicDriver;
Standard_Boolean MyZBufferAuto;
Standard_Boolean MyTransparency;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
