// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Message_Msg_HeaderFile
#define _Message_Msg_HeaderFile

#ifndef _TCollection_ExtendedString_HeaderFile
#include <TCollection_ExtendedString.hxx>
#endif
#ifndef _TColStd_SequenceOfInteger_HeaderFile
#include <TColStd_SequenceOfInteger.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
#ifndef _Handle_TCollection_HExtendedString_HeaderFile
#include <Handle_TCollection_HExtendedString.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class TCollection_AsciiString;
class TCollection_HAsciiString;
class TCollection_ExtendedString;
class TCollection_HExtendedString;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class provides a tool for constructing the parametrized message <br>
//!          basing on resources loaded by Message_MsgFile tool. <br>
//! <br>
//!          A Message is created from a keyword: this keyword identifies the <br>
//!          message in a message file that should be previously loaded by call <br>
//!          to Message_MsgFile::LoadFile(). <br>
//! <br>
//!          The text of the message can contain placeholders for the parameters <br>
//!          which are to be filled by the proper values when the message <br>
//!          is prepared. Most of the format specifiers used in C can be used, <br>
//!          for instance, %s for string, %d for integer etc. In addition, <br>
//!          specifier %f is supported for double numbers (for compatibility <br>
//!          with previous versions). <br>
//! <br>
//!          User fills the parameter fields in the text of the message by <br>
//!          calling corresponding methods Arg() or operators "<<". <br>
//! <br>
//!          The resulting message, filled with all parameters, can be obtained <br>
//!          by method Get(). If some parameters were not filled, the text <br>
//!          UNKNOWN is placed instead. <br>
class Message_Msg  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Empty constructor <br>
Standard_EXPORT Message_Msg();

//! Copy constructor <br>
Standard_EXPORT Message_Msg(const Message_Msg& theMsg);

//! Create a message using a corresponding entry in Message_MsgFile <br>
Standard_EXPORT Message_Msg(const Standard_CString theKey);

//! Create a message using a corresponding entry in Message_MsgFile <br>
Standard_EXPORT Message_Msg(const TCollection_AsciiString& theKey);

//! Set a message body text -- can be used as alternative to <br>
//!           using messages from resource file <br>
Standard_EXPORT   void Set(const Standard_CString theMsg) ;

//! Set a message body text -- can be used as alternative to <br>
//!           using messages from resource file <br>
Standard_EXPORT   void Set(const TCollection_AsciiString& theMsg) ;

//! Set a value for %..s conversion <br>
Standard_EXPORT   Message_Msg& Arg(const Standard_CString theString) ;
  Message_Msg& operator <<(const Standard_CString theString) 
{
  return Arg(theString);
}

//! Set a value for %..s conversion <br>
  Message_Msg& Arg(const TCollection_AsciiString& theString) ;
  Message_Msg& operator <<(const TCollection_AsciiString& theString) 
{
  return Arg(theString);
}

//! Set a value for %..s conversion <br>
  Message_Msg& Arg(const Handle(TCollection_HAsciiString)& theString) ;
  Message_Msg& operator <<(const Handle(TCollection_HAsciiString)& theString) 
{
  return Arg(theString);
}


//! Set a value for %..s conversion <br>
Standard_EXPORT   Message_Msg& Arg(const TCollection_ExtendedString& theString) ;
  Message_Msg& operator <<(const TCollection_ExtendedString& theString) 
{
  return Arg(theString);
}

//! Set a value for %..s conversion <br>
  Message_Msg& Arg(const Handle(TCollection_HExtendedString)& theString) ;
  Message_Msg& operator <<(const Handle(TCollection_HExtendedString)& theString) 
{
  return Arg(theString);
}


//! Set a value for %..d, %..i, %..o, %..u, %..x or %..X conversion <br>
Standard_EXPORT   Message_Msg& Arg(const Standard_Integer theInt) ;
  Message_Msg& operator <<(const Standard_Integer theInt) 
{
  return Arg(theInt);
}


//! Set a value for %..f, %..e, %..E, %..g or %..G conversion <br>
Standard_EXPORT   Message_Msg& Arg(const Standard_Real theReal) ;
  Message_Msg& operator <<(const Standard_Real theReal) 
{
  return Arg(theReal);
}

//! Returns the original message text <br>
 const TCollection_ExtendedString& Original() const;
//! Returns current state of the message text with <br>
//!           parameters to the moment <br>
 const TCollection_ExtendedString& Value() const;
//! Tells if Value differs from Original <br>
  Standard_Boolean IsEdited() const;

//! Return the resulting message string with all parameters <br>
//!           filled. If some parameters were not yet filled by calls <br>
//!           to methods Arg (or <<), these parameters are filled by <br>
//!           the word UNKNOWN <br>
Standard_EXPORT  const TCollection_ExtendedString& Get() ;
operator const TCollection_ExtendedString& () { return Get(); }





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   Standard_Integer getFormat(const Standard_Integer theType,TCollection_AsciiString& theFormat) ;


Standard_EXPORT   void replaceText(const Standard_Integer theFirst,const Standard_Integer theNb,const TCollection_ExtendedString& theStr) ;


 // Fields PRIVATE
 //
TCollection_ExtendedString myOriginal;
TCollection_ExtendedString myMessageBody;
TColStd_SequenceOfInteger mySeqOfFormats;


};


#include <Message_Msg.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
