// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _MS_MetaSchema_HeaderFile
#define _MS_MetaSchema_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_MS_MetaSchema_HeaderFile
#include <Handle_MS_MetaSchema.hxx>
#endif

#ifndef _MS_MapOfType_HeaderFile
#include <MS_MapOfType.hxx>
#endif
#ifndef _MS_MapOfGlobalEntity_HeaderFile
#include <MS_MapOfGlobalEntity.hxx>
#endif
#ifndef _MS_MapOfMethod_HeaderFile
#include <MS_MapOfMethod.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_MS_Package_HeaderFile
#include <Handle_MS_Package.hxx>
#endif
#ifndef _Handle_MS_Engine_HeaderFile
#include <Handle_MS_Engine.hxx>
#endif
#ifndef _Handle_MS_Component_HeaderFile
#include <Handle_MS_Component.hxx>
#endif
#ifndef _Handle_MS_Schema_HeaderFile
#include <Handle_MS_Schema.hxx>
#endif
#ifndef _Handle_MS_Executable_HeaderFile
#include <Handle_MS_Executable.hxx>
#endif
#ifndef _Handle_MS_Interface_HeaderFile
#include <Handle_MS_Interface.hxx>
#endif
#ifndef _Handle_MS_Client_HeaderFile
#include <Handle_MS_Client.hxx>
#endif
#ifndef _Handle_MS_Type_HeaderFile
#include <Handle_MS_Type.hxx>
#endif
#ifndef _Handle_MS_Method_HeaderFile
#include <Handle_MS_Method.hxx>
#endif
#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
#ifndef _Handle_MS_HSequenceOfInstClass_HeaderFile
#include <Handle_MS_HSequenceOfInstClass.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfHAsciiString_HeaderFile
#include <Handle_TColStd_HSequenceOfHAsciiString.hxx>
#endif
#ifndef _Handle_MS_Class_HeaderFile
#include <Handle_MS_Class.hxx>
#endif
#ifndef _Handle_MS_MemberMet_HeaderFile
#include <Handle_MS_MemberMet.hxx>
#endif
#ifndef _Handle_MS_ExternMet_HeaderFile
#include <Handle_MS_ExternMet.hxx>
#endif
#ifndef _Handle_MS_Field_HeaderFile
#include <Handle_MS_Field.hxx>
#endif
#ifndef _Handle_MS_InstClass_HeaderFile
#include <Handle_MS_InstClass.hxx>
#endif
class MS_Package;
class MS_Engine;
class MS_Component;
class MS_Schema;
class MS_Executable;
class MS_Interface;
class MS_Client;
class MS_Type;
class MS_Method;
class MS_DataMapIteratorOfMapOfGlobalEntity;
class MS_DataMapIteratorOfMapOfType;
class MS_DataMapIteratorOfMapOfMethod;
class TCollection_HAsciiString;
class MS_HSequenceOfInstClass;
class TColStd_HSequenceOfHAsciiString;
class MS_Class;
class MS_MemberMet;
class MS_ExternMet;
class MS_Field;
class MS_InstClass;



class MS_MetaSchema : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! create an empry workspace. <br>
Standard_EXPORT MS_MetaSchema();

//! add a object (if not defined) in the scope of the workspace. <br>
//!             Executable <br>
//!             Engine <br>
//!             Schemas <br>
//!             Interface <br>
//!             Package <br>
//!             Classe <br>
//!             and all other types... <br>
//! if result : <br>
//!             True  : Ok <br>
//!             False : already defined. <br>
Standard_EXPORT   Standard_Boolean AddPackage(const Handle(MS_Package)& aCommon) ;


Standard_EXPORT   Standard_Boolean AddEngine(const Handle(MS_Engine)& aCommon) ;


Standard_EXPORT   Standard_Boolean AddComponent(const Handle(MS_Component)& aCommon) ;


Standard_EXPORT   Standard_Boolean AddSchema(const Handle(MS_Schema)& aCommon) ;


Standard_EXPORT   Standard_Boolean AddExecutable(const Handle(MS_Executable)& aCommon) ;


Standard_EXPORT   Standard_Boolean AddInterface(const Handle(MS_Interface)& aCommon) ;


Standard_EXPORT   Standard_Boolean AddClient(const Handle(MS_Client)& aCommon) ;


Standard_EXPORT   Standard_Boolean AddType(const Handle(MS_Type)& aCommon) ;


Standard_EXPORT   Standard_Boolean AddMethod(const Handle(MS_Method)& aCommon) ;

//! returns the list of the executables defined in the workspace. <br>
Standard_EXPORT   MS_DataMapIteratorOfMapOfGlobalEntity Executables() const;

//! returns the list of the engines defined in the workspace. <br>
Standard_EXPORT   MS_DataMapIteratorOfMapOfGlobalEntity Engines() const;

//! returns the list of the components defined in the workspace. <br>
Standard_EXPORT   MS_DataMapIteratorOfMapOfGlobalEntity Components() const;

//! returns the list of the schemas defined in the workspace. <br>
Standard_EXPORT   MS_DataMapIteratorOfMapOfGlobalEntity Schemas() const;

//! returns the list of the interfaces defined in the workspace. <br>
Standard_EXPORT   MS_DataMapIteratorOfMapOfGlobalEntity Interfaces() const;

//! returns the list of the clients defined in the workspace. <br>
Standard_EXPORT   MS_DataMapIteratorOfMapOfGlobalEntity Clients() const;

//! returns the list of the packages defined in the workspace. <br>
Standard_EXPORT   MS_DataMapIteratorOfMapOfGlobalEntity Packages() const;

//! returns the list of the classes defined in the workspace. <br>
Standard_EXPORT   MS_DataMapIteratorOfMapOfType Types() const;


Standard_EXPORT   MS_DataMapIteratorOfMapOfMethod Methods() const;

//! returns the Executable named anExecutable <br>
Standard_EXPORT  const Handle_MS_Executable& GetExecutable(const Handle(TCollection_HAsciiString)& anExecutable) const;

//! returns the Engine named anEngine <br>
Standard_EXPORT  const Handle_MS_Engine& GetEngine(const Handle(TCollection_HAsciiString)& anEngine) const;

//! returns the Component named aComponent <br>
Standard_EXPORT  const Handle_MS_Component& GetComponent(const Handle(TCollection_HAsciiString)& aComponent) const;

//! returns the Schema named aSchema <br>
Standard_EXPORT  const Handle_MS_Schema& GetSchema(const Handle(TCollection_HAsciiString)& aSchema) const;

//! returns the Interface named anInterface <br>
Standard_EXPORT  const Handle_MS_Interface& GetInterface(const Handle(TCollection_HAsciiString)& anInterface) const;

//! returns the client named aClient <br>
Standard_EXPORT  const Handle_MS_Client& GetClient(const Handle(TCollection_HAsciiString)& aClient) const;

//! returns the list of the packages defined in the workspace. <br>
Standard_EXPORT  const Handle_MS_Package& GetPackage(const Handle(TCollection_HAsciiString)& aPackage) const;


Standard_EXPORT   void RemovePackage(const Handle(TCollection_HAsciiString)& aPackage) ;


Standard_EXPORT   void RemoveExecutable(const Handle(TCollection_HAsciiString)& anExec) ;


Standard_EXPORT   void RemoveEngine(const Handle(TCollection_HAsciiString)& aEngine) ;


Standard_EXPORT   void RemoveComponent(const Handle(TCollection_HAsciiString)& aComponent) ;


Standard_EXPORT   void RemoveSchema(const Handle(TCollection_HAsciiString)& aSchema) ;


Standard_EXPORT   void RemoveInterface(const Handle(TCollection_HAsciiString)& anInterface) ;


Standard_EXPORT   void RemoveClient(const Handle(TCollection_HAsciiString)& aClient) ;

//! returns the list of the classes defined in the workspace. <br>
Standard_EXPORT  const Handle_MS_Type& GetType(const Handle(TCollection_HAsciiString)& aType) const;


Standard_EXPORT   void RemoveType(const Handle(TCollection_HAsciiString)& aType,const Standard_Boolean mustUpdatePackage = Standard_True) ;


Standard_EXPORT  const Handle_MS_Method& GetMethod(const Handle(TCollection_HAsciiString)& aMethod) const;


Standard_EXPORT   void RemoveMethod(const Handle(TCollection_HAsciiString)& aMethod) ;

//! returns Standard_True if <anExecutable> is an executable. <br>
Standard_EXPORT   Standard_Boolean IsExecutable(const Handle(TCollection_HAsciiString)& anExecutable) const;

//! returns Standard_True if <anEngine> is an engine. <br>
Standard_EXPORT   Standard_Boolean IsEngine(const Handle(TCollection_HAsciiString)& anEngine) const;

//! returns Standard_True if <aComponent> is a component. <br>
Standard_EXPORT   Standard_Boolean IsComponent(const Handle(TCollection_HAsciiString)& aComponent) const;

//! returns Standard_True if <aSchema> is a schema. <br>
Standard_EXPORT   Standard_Boolean IsSchema(const Handle(TCollection_HAsciiString)& aSchema) const;

//! returns Standard_True if <anInterface> is an interface. <br>
Standard_EXPORT   Standard_Boolean IsInterface(const Handle(TCollection_HAsciiString)& anInterface) const;

//! returns Standard_True if <aClient> is a client. <br>
Standard_EXPORT   Standard_Boolean IsClient(const Handle(TCollection_HAsciiString)& aClient) const;

//! returns Standard_True if <aPackage> is a package. <br>
Standard_EXPORT   Standard_Boolean IsPackage(const Handle(TCollection_HAsciiString)& aPackage) const;

//! returns Standard_True if <aType> is a type defined in the package <aPackage>. <br>
Standard_EXPORT   Standard_Boolean IsDefined(const Handle(TCollection_HAsciiString)& aType,const Handle(TCollection_HAsciiString)& aPackage) const;

//! returns Standard_True if <aType> is a type defined. <br>
Standard_EXPORT   Standard_Boolean IsDefined(const Handle(TCollection_HAsciiString)& aType) const;


Standard_EXPORT   Standard_Boolean IsMethod(const Handle(TCollection_HAsciiString)& aMethod) const;

//! Returns the list of instantiations using <aGenClass> <br>
Standard_EXPORT   Handle_MS_HSequenceOfInstClass GetInstantiations(const Handle(TCollection_HAsciiString)& aGenClass) const;

//! Returns the list of persistent classes listed into the schema <aSchema> <br>
Standard_EXPORT   Handle_TColStd_HSequenceOfHAsciiString GetPersistentClassesFromSchema(const Handle(TCollection_HAsciiString)& aSchema,const Standard_Boolean withStorable = Standard_False) const;

//! Returns the list of persistent classes used by the classes listed into <aClassList> and not <br>
//!          present in <aClassList> <br>
Standard_EXPORT   Handle_TColStd_HSequenceOfHAsciiString GetPersistentClassesFromClasses(const Handle(TColStd_HSequenceOfHAsciiString)& aClassList,const Standard_Boolean withStorable = Standard_False) const;

//! Check the entity named <aName> <br>
//!          Returns Standard_False if checking failed <br>
//!          otherwise Standard_True <br>
Standard_EXPORT   Standard_Boolean Check(const Handle(TCollection_HAsciiString)& aName) const;
//Standard_EXPORT ~MS_MetaSchema();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   Standard_Boolean CheckClass(const Handle(MS_Class)& aClass) const;


Standard_EXPORT   Standard_Boolean CheckMemberMethod(const Handle(MS_MemberMet)& aMeth) const;


Standard_EXPORT   Standard_Boolean CheckExternMethod(const Handle(MS_ExternMet)& aMeth) const;


Standard_EXPORT   Standard_Boolean CheckField(const Handle(MS_Field)& aField) const;


Standard_EXPORT   Standard_Boolean CheckInstClass(const Handle(MS_InstClass)& anInst) const;


 // Fields PRIVATE
 //
MS_MapOfType myTypes;
MS_MapOfGlobalEntity myPackages;
MS_MapOfGlobalEntity mySchemas;
MS_MapOfGlobalEntity myExecutables;
MS_MapOfGlobalEntity myInterfaces;
MS_MapOfGlobalEntity myClients;
MS_MapOfGlobalEntity myEngines;
MS_MapOfGlobalEntity myComponents;
MS_MapOfMethod myMethods;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
