// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Law_S_HeaderFile
#define _Law_S_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Law_S_HeaderFile
#include <Handle_Law_S.hxx>
#endif

#ifndef _Law_BSpFunc_HeaderFile
#include <Law_BSpFunc.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif


//! Describes an "S" evolution law. <br>
class Law_S : public Law_BSpFunc {

public:
 // Methods PUBLIC
 // 

//! Constructs an empty "S" evolution law. <br>
Standard_EXPORT Law_S();


//! Defines this S evolution law by assigning both: <br>
//! -   the bounds Pdeb and Pfin of the parameter, and <br>
//! -   the values Valdeb and Valfin of the function at these <br>
//!   two parametric bounds. <br>
//! The function is assumed to have the first derivatives <br>
//! equal to 0 at the two parameter points Pdeb and Pfin. <br>
Standard_EXPORT   void Set(const Standard_Real Pdeb,const Standard_Real Valdeb,const Standard_Real Pfin,const Standard_Real Valfin) ;

//! Defines this S evolution law by assigning <br>
//! -   the bounds Pdeb and Pfin of the parameter, <br>
//! -   the values Valdeb and Valfin of the function at these <br>
//!   two parametric bounds, and <br>
//! -   the values Ddeb and Dfin of the first derivative of the <br>
//!   function at these two parametric bounds. <br>
Standard_EXPORT   void Set(const Standard_Real Pdeb,const Standard_Real Valdeb,const Standard_Real Ddeb,const Standard_Real Pfin,const Standard_Real Valfin,const Standard_Real Dfin) ;
//Standard_EXPORT ~Law_S();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
